/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.DurabilityUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class SoulDevourerItem
extends RelicItem<Stats> {
    private static final String TAG_UPDATE_TIME = "time";
    private static final String TAG_SOUL_AMOUNT = "soul";
    public static SoulDevourerItem INSTANCE;

    public SoulDevourerItem() {
        super(RelicData.builder().rarity(Rarity.EPIC).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#8261be", "#433994").ability(AbilityTooltip.builder().arg((int)(((Stats)this.stats).soulFromHealthMultiplier * 100.0f) + "%").arg(((Stats)this.stats).damageMultiplierPerSoul + "%").build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.relics.soul_devourer.tooltip_1", new Object[]{NBTUtils.getInt(stack, TAG_SOUL_AMOUNT, 0)}));
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (DurabilityUtils.isBroken(stack) || !(livingEntity instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)livingEntity;
        int soul = NBTUtils.getInt(stack, TAG_SOUL_AMOUNT, 0);
        int time = NBTUtils.getInt(stack, TAG_UPDATE_TIME, 0);
        if (player.field_70173_aa % 20 == 0) {
            if (time < ((Stats)this.stats).soulLooseCooldown) {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, time + 1);
            } else {
                NBTUtils.setInt(stack, TAG_UPDATE_TIME, 0);
                NBTUtils.setInt(stack, TAG_SOUL_AMOUNT, Math.round(Math.max((float)soul - ((float)soul * ((Stats)this.stats).soulLoseMultiplierPerSoul + (float)((Stats)this.stats).minSoulLooseAmount), 0.0f)));
            }
        }
    }

    public static class Stats
    extends RelicStats {
        public int soulLooseCooldown = 10;
        public int minSoulLooseAmount = 5;
        public float soulLoseMultiplierPerSoul = 0.1f;
        public int soulCapacity = 100;
        public float soulFromHealthMultiplier = 0.25f;
        public float damageMultiplierPerSoul = 0.1f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class SoulDevourerServerEvents {
        @SubscribeEvent
        public static void onEntityDeath(LivingDeathEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SOUL_DEVOURER.get());
            int soul = NBTUtils.getInt(stack, SoulDevourerItem.TAG_SOUL_AMOUNT, 0);
            int capacity = stats.soulCapacity;
            if (stack.func_190926_b() || soul >= capacity) {
                return;
            }
            NBTUtils.setInt(stack, SoulDevourerItem.TAG_SOUL_AMOUNT, Math.min(soul + (int)(target.func_110138_aP() * stats.soulFromHealthMultiplier), capacity));
            NBTUtils.setInt(stack, SoulDevourerItem.TAG_UPDATE_TIME, 0);
        }

        @SubscribeEvent
        public static void onEntityHurt(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SOUL_DEVOURER.get());
            if (stack.func_190926_b()) {
                return;
            }
            int soul = NBTUtils.getInt(stack, SoulDevourerItem.TAG_SOUL_AMOUNT, 0);
            if (soul > 0) {
                event.setAmount(event.getAmount() + event.getAmount() * ((float)soul * stats.damageMultiplierPerSoul));
            }
        }
    }
}

