/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.AbilityTooltip;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicTooltip;
import it.hurts.sskirillss.relics.configs.data.relics.RelicConfigData;
import it.hurts.sskirillss.relics.entities.StellarCatalystProjectileEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicStats;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class StellarCatalystItem
extends RelicItem<Stats> {
    public static StellarCatalystItem INSTANCE;

    public StellarCatalystItem() {
        super(RelicData.builder().rarity(Rarity.EPIC).build());
        INSTANCE = this;
    }

    @Override
    public RelicTooltip getTooltip(ItemStack stack) {
        return RelicTooltip.builder().borders("#0f4ca0", "#2f1d69").ability(AbilityTooltip.builder().arg((int)(((Stats)this.stats).chance * 100.0f) + "%").arg((int)(((Stats)this.stats).damageMultiplier * 100.0f) + "%").build()).build();
    }

    @Override
    public RelicConfigData<Stats> getConfigData() {
        return RelicConfigData.builder().stats(new Stats()).build();
    }

    public static class Stats
    extends RelicStats {
        public float chance = 0.15f;
        public float damageMultiplier = 2.0f;
        public int additionalSummonHeight = 20;
        public int minSummonHeight = 20;
        public int explosionRadius = 3;
        public float knockbackPower = 1.0f;
        public float projectileSpeed = 0.9f;
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class StellarCatalystServerEvents {
        @SubscribeEvent
        public static void onEntityDamage(LivingHurtEvent event) {
            Stats stats = (Stats)INSTANCE.stats;
            DamageSource source = event.getSource();
            if (!(source.func_76346_g() instanceof PlayerEntity) || source instanceof IndirectEntityDamageSource && source.func_76364_f() instanceof StellarCatalystProjectileEntity) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            if (EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.STELLAR_CATALYST.get()).func_190926_b()) {
                return;
            }
            LivingEntity target = event.getEntityLiving();
            World world = target.func_130014_f_();
            if (world.func_226690_K_() && world.func_226660_f_(target.func_233580_cy_()) && field_77697_d.nextFloat() <= stats.chance) {
                StellarCatalystProjectileEntity projectile = new StellarCatalystProjectileEntity((LivingEntity)event.getSource().func_76346_g(), event.getEntityLiving(), event.getAmount() * stats.damageMultiplier);
                projectile.func_70107_b(target.func_226277_ct_(), Math.min((double)target.func_130014_f_().func_217301_I(), Math.min((double)target.func_130014_f_().func_217301_I(), target.func_226278_cu_() + (double)target.func_130014_f_().func_201674_k().nextInt(stats.additionalSummonHeight) + (double)stats.minSummonHeight)), target.func_226281_cx_());
                projectile.owner = player;
                world.func_217376_c((Entity)projectile);
            }
        }
    }
}

