/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.tiles;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.crafting.RunicAltarContext;
import it.hurts.sskirillss.relics.crafting.RunicAltarRecipe;
import it.hurts.sskirillss.relics.crafting.SingletonInventory;
import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.items.RuneItem;
import it.hurts.sskirillss.relics.tiles.TileBase;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class RunicAltarTile
extends TileBase
implements ITickableTileEntity {
    private ItemStack relicStack = ItemStack.field_190927_a;
    private ItemStack eastStack = ItemStack.field_190927_a;
    private ItemStack westStack = ItemStack.field_190927_a;
    private ItemStack southStack = ItemStack.field_190927_a;
    private ItemStack northStack = ItemStack.field_190927_a;
    private ItemStack ingredient = ItemStack.field_190927_a;
    public int ticksExisted;
    private int progress;
    public static final Direction[] runeDirections = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH};

    public RunicAltarTile() {
        super((TileEntityType)TileRegistry.RUNIC_ALTAR_TILE.get());
    }

    public void setStack(ItemStack stack, Direction direction) {
        switch (direction) {
            case NORTH: {
                this.northStack = stack;
                break;
            }
            case WEST: {
                this.westStack = stack;
                break;
            }
            case EAST: {
                this.eastStack = stack;
                break;
            }
            case SOUTH: {
                this.southStack = stack;
                break;
            }
            case UP: {
                this.relicStack = stack;
            }
        }
        BlockPos pos = this.func_174877_v();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.func_180495_p(pos), 2);
        }
    }

    public ItemStack getStack(Direction direction) {
        switch (direction) {
            case NORTH: {
                return this.northStack;
            }
            case WEST: {
                return this.westStack;
            }
            case EAST: {
                return this.eastStack;
            }
            case SOUTH: {
                return this.southStack;
            }
            case UP: {
                return this.relicStack;
            }
        }
        return ItemStack.field_190927_a;
    }

    public List<ItemStack> getRunes() {
        return Arrays.stream(runeDirections).map(this::getStack).filter(stack -> !stack.func_190926_b()).collect(Collectors.toList());
    }

    public void addCraftingProgress(int progress) {
        this.setCraftingProgress(this.progress + progress);
    }

    public void setCraftingProgress(int progress) {
        this.progress = Math.min(100, progress);
        BlockPos pos = this.func_174877_v();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.func_180495_p(pos), 2);
        }
    }

    public int getCraftingProgress() {
        return this.progress;
    }

    public ItemStack getIngredient() {
        return this.ingredient;
    }

    public void setIngredient(ItemStack ingredient) {
        this.ingredient = ingredient;
        BlockPos pos = this.func_174877_v();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.func_180495_p(pos), 2);
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.ticksExisted;
        Random random = this.field_145850_b.func_201674_k();
        if (this.relicStack.func_190926_b() || this.getCraftingProgress() == 0) {
            return;
        }
        this.spawnParticles(this.field_145850_b, random);
        if (this.field_145850_b.func_201670_d()) {
            return;
        }
        this.handleRunes(this.field_145850_b);
        this.handleRecipe(this.field_145850_b, random);
    }

    protected void spawnParticles(World world, Random random) {
        if (!world.func_201670_d()) {
            return;
        }
        BlockPos pos = this.func_174877_v();
        world.func_195594_a((IParticleData)new CircleTintData(this.relicStack.func_77953_t().field_77937_e.func_211163_e() != null ? new Color(this.relicStack.func_77953_t().field_77937_e.func_211163_e(), false) : new Color(255, 255, 255), random.nextFloat() * 0.025f + 0.04f, 20, 0.94f, true), (double)pos.func_177958_n() + 0.5 + (double)(MathUtils.randomFloat(random) * 0.2f), (double)((float)pos.func_177956_o() + 0.85f), (double)pos.func_177952_p() + 0.5 + (double)(MathUtils.randomFloat(random) * 0.2f), 0.0, (double)random.nextFloat() * 0.05, 0.0);
    }

    protected void handleRecipe(World world, Random random) {
        BlockPos pos = this.func_174877_v();
        if (this.getCraftingProgress() >= 100) {
            world.func_199532_z().func_215371_a(RunicAltarRecipe.RECIPE, (IInventory)new RunicAltarContext(new SingletonInventory(this.getStack(Direction.UP)), world.func_217366_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 3.0, false), this.getRunes(), this.getStack(Direction.UP)), world).ifPresent(recipe -> {
                Arrays.stream(runeDirections).map(this::getStack).forEach(stack -> stack.func_190918_g(1));
                ItemStack result = recipe.func_77571_b();
                result.func_196085_b(Math.min(result.func_77958_k(), this.relicStack.func_77952_i()));
                this.setStack(result, Direction.UP);
                world.func_195594_a((IParticleData)ParticleTypes.field_197627_t, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0);
                world.func_184133_a(null, pos, SoundEvents.field_187802_ec, SoundCategory.BLOCKS, 1.0f, 1.0f);
                this.setIngredient(ItemStack.field_190927_a);
                this.setCraftingProgress(0);
                world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
            });
        } else if (this.getCraftingProgress() > 0) {
            if (this.getIngredient().func_190926_b()) {
                List runes = this.getRunes().stream().map(rune -> (RuneItem)rune.func_77973_b()).collect(Collectors.toList());
                runes.removeIf(rune -> rune.getIngredients().isEmpty());
                if (runes.isEmpty()) {
                    if (!world.func_201670_d() && this.ticksExisted % 20 == 0) {
                        this.addCraftingProgress(random.nextInt(20) + 1);
                    }
                    return;
                }
                RuneItem rune2 = (RuneItem)((RuneItem)((Object)runes.get(random.nextInt(runes.size())))).getItem();
                List ingredients = rune2.getIngredients().stream().map(name -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name))).collect(Collectors.toList());
                this.setIngredient(new ItemStack((IItemProvider)ingredients.get(random.nextInt(ingredients.size()))));
                world.func_184133_a(null, pos, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
            } else {
                world.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1))).stream().map(ItemEntity::func_92059_d).filter(stack -> this.ingredient.func_77973_b().equals(stack.func_77973_b())).findFirst().ifPresent(item -> {
                    if (!world.func_201670_d()) {
                        this.addCraftingProgress(random.nextInt(20) + 1);
                    }
                    this.setIngredient(ItemStack.field_190927_a);
                    item.func_190918_g(1);
                    world.func_184138_a(pos, world.func_180495_p(pos), world.func_180495_p(pos), 2);
                });
            }
        }
    }

    protected void handleRunes(World world) {
        if (this.getRunes().isEmpty() || this.ticksExisted % 20 == 0) {
            return;
        }
        BlockPos pos = this.func_174877_v().func_177963_a(0.5, 0.5, 0.5);
        for (ItemStack stack : this.getRunes()) {
            if (!(stack.func_77973_b() instanceof RuneItem)) continue;
            RuneItem rune = (RuneItem)stack.func_77973_b();
            rune.applyAbility(world, pos);
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.relicStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("relicStack")));
        this.eastStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("eastStack")));
        this.westStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("westStack")));
        this.southStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("southStack")));
        this.northStack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("northStack")));
        this.ingredient = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a("ingredient")));
        this.progress = compound.func_74762_e("progress");
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        CompoundNBT compoundNBT;
        if (this.relicStack != null) {
            compoundNBT = new CompoundNBT();
            this.relicStack.func_77955_b(compoundNBT);
            compound.func_218657_a("relicStack", (INBT)compoundNBT);
        }
        if (this.eastStack != null) {
            compoundNBT = new CompoundNBT();
            this.eastStack.func_77955_b(compoundNBT);
            compound.func_218657_a("eastStack", (INBT)compoundNBT);
        }
        if (this.westStack != null) {
            compoundNBT = new CompoundNBT();
            this.westStack.func_77955_b(compoundNBT);
            compound.func_218657_a("westStack", (INBT)compoundNBT);
        }
        if (this.southStack != null) {
            compoundNBT = new CompoundNBT();
            this.southStack.func_77955_b(compoundNBT);
            compound.func_218657_a("southStack", (INBT)compoundNBT);
        }
        if (this.northStack != null) {
            compoundNBT = new CompoundNBT();
            this.northStack.func_77955_b(compoundNBT);
            compound.func_218657_a("northStack", (INBT)compoundNBT);
        }
        if (this.ingredient != null) {
            compoundNBT = new CompoundNBT();
            this.ingredient.func_77955_b(compoundNBT);
            compound.func_218657_a("ingredient", (INBT)compoundNBT);
        }
        compound.func_74768_a("progress", this.getCraftingProgress());
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }
}

