/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.tiles;

import it.hurts.sskirillss.relics.init.TileRegistry;
import it.hurts.sskirillss.relics.tiles.TileBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class RunicAnvilTile
extends TileBase
implements ITickableTileEntity {
    private final ItemStackHandler handler = this.createHandler();
    private int ticksExisted;

    public RunicAnvilTile() {
        super((TileEntityType)TileRegistry.RUNIC_ANVIL_TILE.get());
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        ++this.ticksExisted;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                RunicAnvilTile.this.func_70296_d();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return super.isItemValid(slot, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            if (!this.handler.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int getLastItemSlot(boolean inverted) {
        if (inverted) {
            for (int i = this.handler.getSlots() - 1; i > -1; --i) {
                if (this.handler.getStackInSlot(i).func_190926_b()) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.handler.getSlots(); ++i) {
                if (this.handler.getStackInSlot(i).func_190926_b()) continue;
                return i;
            }
        }
        return -1;
    }

    public boolean insertItem(ItemStack stack) {
        int slot = this.getEmptySlot();
        if (slot == -1) {
            return false;
        }
        this.handler.insertItem(slot, stack.func_77946_l().func_77979_a(1), false);
        stack.func_190918_g(1);
        BlockPos pos = this.func_174877_v();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.func_180495_p(pos), 2);
        }
        return true;
    }

    public boolean takeItem(LivingEntity entity) {
        int slot = this.getLastItemSlot(true);
        if (slot == -1) {
            return false;
        }
        Vector3d vec = entity.func_213303_ch();
        World world = entity.func_130014_f_();
        ItemEntity item = new ItemEntity(world, vec.func_82615_a(), vec.func_82617_b(), vec.func_82616_c(), this.handler.getStackInSlot(slot));
        item.func_174868_q();
        world.func_217376_c((Entity)item);
        this.handler.extractItem(slot, 1, false);
        BlockPos pos = this.func_174877_v();
        if (this.field_145850_b != null) {
            this.field_145850_b.func_184138_a(pos, this.field_145850_b.func_180495_p(pos), this.field_145850_b.func_180495_p(pos), 2);
        }
        return true;
    }

    public List<ItemStack> getItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            items.add(stack);
        }
        return items;
    }

    public void func_230337_a_(@NotNull BlockState state, CompoundNBT compound) {
        this.handler.deserializeNBT(compound.func_74775_l("items"));
        super.func_230337_a_(state, compound);
    }

    @NotNull
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("items", (INBT)this.handler.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Override
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), -1, this.func_189517_E_());
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_230337_a_(this.func_195044_w(), packet.func_148857_g());
    }

    public ItemStackHandler getHandler() {
        return this.handler;
    }
}

