/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class NBTUtils {
    public static void setBoolean(ItemStack stack, String tag, boolean value) {
        stack.func_196082_o().func_74757_a(tag, value);
    }

    public static void setInt(ItemStack stack, String tag, int value) {
        stack.func_196082_o().func_74768_a(tag, value);
    }

    public static void setLong(ItemStack stack, String tag, long value) {
        stack.func_196082_o().func_74772_a(tag, value);
    }

    public static void setFloat(ItemStack stack, String tag, float value) {
        stack.func_196082_o().func_74776_a(tag, value);
    }

    public static void setDouble(ItemStack stack, String tag, double value) {
        stack.func_196082_o().func_74780_a(tag, value);
    }

    public static void setString(ItemStack stack, String tag, String value) {
        stack.func_196082_o().func_74778_a(tag, value);
    }

    public static boolean getBoolean(ItemStack stack, String tag, boolean defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.func_77978_p().func_74767_n(tag) : defaultValue;
    }

    public static int getInt(ItemStack stack, String tag, int defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.func_77978_p().func_74762_e(tag) : defaultValue;
    }

    public static long getLong(ItemStack stack, String tag, long defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.func_77978_p().func_74763_f(tag) : defaultValue;
    }

    public static float getFloat(ItemStack stack, String tag, float defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.func_77978_p().func_74760_g(tag) : defaultValue;
    }

    public static double getDouble(ItemStack stack, String tag, double defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? (double)stack.func_77978_p().func_74762_e(tag) : defaultValue;
    }

    public static String getString(ItemStack stack, String tag, String defaultValue) {
        return NBTUtils.safeCheck(stack, tag) ? stack.func_77978_p().func_74779_i(tag) : defaultValue;
    }

    public static boolean safeCheck(ItemStack stack, String tag) {
        return !stack.func_190926_b() && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(tag);
    }

    public static String writePosition(Vector3d vec) {
        return (float)Math.round(vec.func_82615_a() * 10.0) / 10.0f + "," + (float)Math.round(vec.func_82617_b() * 10.0) / 10.0f + "," + (float)Math.round(vec.func_82616_c() * 10.0) / 10.0f;
    }

    @Nullable
    public static Vector3d parsePosition(String value) {
        if (value != null && !value.equals("")) {
            String[] pos = value.split(",");
            return new Vector3d(Double.parseDouble(pos[0]), Double.parseDouble(pos[1]), Double.parseDouble(pos[2]));
        }
        return null;
    }

    @Nullable
    public static ServerWorld parseWorld(World world, String value) {
        return world.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(value)));
    }
}

