/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.IModCompat;
import de.teamlapen.lib.lib.util.ModCompatLoader;
import de.teamlapen.lib.lib.util.VersionChecker;
import de.teamlapen.vampirism_integrations.Config;
import de.teamlapen.vampirism_integrations.EventHandler;
import de.teamlapen.vampirism_integrations.VampirismCompat;
import de.teamlapen.vampirism_integrations.bloodmagic.BloodmagicCompat;
import de.teamlapen.vampirism_integrations.bop.BOPCompat;
import de.teamlapen.vampirism_integrations.consecration.ConsecrationCompat;
import de.teamlapen.vampirism_integrations.diet.DietCompat;
import de.teamlapen.vampirism_integrations.evilcraft.EvilCraftCompat;
import de.teamlapen.vampirism_integrations.survive.SurviveCompat;
import de.teamlapen.vampirism_integrations.tan.TANCompat;
import de.teamlapen.vampirism_integrations.tconstruct.TConstructCompat;
import de.teamlapen.vampirism_integrations.util.REFERENCE;
import de.teamlapen.vampirism_integrations.waila.WailaModCompat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.item.Item;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="vampirism_integrations")
public class VampirismIntegrationsMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static VampirismIntegrationsMod instance;
    public static boolean inDev;
    @Nonnull
    public final ModCompatLoader compatLoader;
    private VersionChecker.VersionInfo versionInfo;

    public VampirismIntegrationsMod() {
        instance = this;
        this.checkDevEnv();
        Optional opt = ModList.get().getModContainerById("vampirism_integrations");
        if (opt.isPresent()) {
            REFERENCE.VERSION = ((ModContainer)opt.get()).getModInfo().getVersion();
        } else {
            LOGGER.warn("Cannot get version from mod info");
        }
        this.compatLoader = new ModCompatLoader();
        this.compatLoader.addModCompat((IModCompat)new VampirismCompat());
        this.compatLoader.addModCompat((IModCompat)new BOPCompat());
        this.compatLoader.addModCompat((IModCompat)new WailaModCompat());
        this.compatLoader.addModCompat((IModCompat)new BloodmagicCompat());
        this.compatLoader.addModCompat((IModCompat)new EvilCraftCompat());
        this.compatLoader.addModCompat((IModCompat)new ConsecrationCompat());
        this.compatLoader.addModCompat((IModCompat)new TANCompat());
        this.compatLoader.addModCompat((IModCompat)new DietCompat());
        this.compatLoader.addModCompat((IModCompat)new TConstructCompat());
        this.compatLoader.addModCompat((IModCompat)new SurviveCompat());
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        MinecraftForge.EVENT_BUS.addListener(this::onCommandRegister);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public VersionChecker.VersionInfo getVersionInfo() {
        return this.versionInfo;
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.CLIENT_SETUP, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void loadComplete(FMLLoadCompleteEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.LOAD_COMPLETE, (ParallelDispatchEvent)event);
    }

    public void onCommandRegister(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"vampirism-integrations").then(Commands.func_197057_a((String)"loaded").executes(context -> {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Loaded and active mods"), false);
            for (IModCompat compat : this.compatLoader.getLoadedModCompats()) {
                ModList.get().getModContainerById(compat.getModID()).ifPresent(container -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Active: " + compat.getModID() + " Version: " + container.getModInfo().getVersion().getQualifier()), false));
            }
            return 0;
        }))).then(Commands.func_197057_a((String)"changelog").executes(context -> {
            if (!this.getVersionInfo().isNewVersionAvailable()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.vampirism.base.changelog.newversion"), false);
                return 0;
            }
            VersionChecker.Version newVersion = this.getVersionInfo().getNewVersion();
            List changes = newVersion.getChanges();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Vampirism Integrations" + newVersion.name + "(" + SharedConstants.func_215069_a().getName() + ")"), true);
            for (String c : changes) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("-" + c), false);
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(""), false);
            String homepage = this.getVersionInfo().getHomePage();
            IFormattableTextComponent download = new TranslationTextComponent("text.vampirism.update_message.download").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, newVersion.getUrl() == null ? homepage : newVersion.getUrl())).setUnderlined(Boolean.valueOf(true)).func_240712_a_(TextFormatting.BLUE));
            IFormattableTextComponent changelog = new TranslationTextComponent("text.vampirism.update_message.changelog").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/vampirism-integrations changelog")).setUnderlined(Boolean.valueOf(true)));
            IFormattableTextComponent modpage = new TranslationTextComponent("text.vampirism.update_message.modpage").func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, homepage)).setUnderlined(Boolean.valueOf(true)).func_240712_a_(TextFormatting.BLUE));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)download.func_240702_b_(" ").func_230529_a_((ITextComponent)changelog).func_240702_b_(" ").func_230529_a_((ITextComponent)modpage), false);
            return 0;
        })));
    }

    @SubscribeEvent
    public void processIMC(InterModProcessEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.PROCESS_IMC, (ParallelDispatchEvent)event);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Config.buildConfiguration();
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        this.compatLoader.onInitStep(IInitListener.Step.COMMON_SETUP, (ParallelDispatchEvent)event);
        this.versionInfo = (Boolean)VampirismCompat.disableVersionCheck.get() != false ? new VersionChecker.VersionInfo(REFERENCE.VERSION) : VersionChecker.executeVersionCheck((String)"http://maxanier.de/projects/vampirism/versions_integrations.json", (ArtifactVersion)REFERENCE.VERSION, (boolean)false);
    }

    private void checkDevEnv() {
        String launchTarget = System.getenv().get("target");
        if (launchTarget != null && launchTarget.contains("dev")) {
            inDev = true;
        }
    }

    static {
        inDev = false;
    }
}

