/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.survive;

import de.teamlapen.lib.lib.util.IInitListener;
import de.teamlapen.lib.lib.util.IModCompat;
import de.teamlapen.vampirism_integrations.survive.ThirstHandler;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.ParallelDispatchEvent;
import org.apache.logging.log4j.LogManager;

public class SurviveCompat
implements IModCompat {
    static ForgeConfigSpec.BooleanValue disableThirstForVampires;
    static ForgeConfigSpec.BooleanValue enableTemperatureVampires;
    static ForgeConfigSpec.BooleanValue enableStaminaBoostVampires;

    public void buildConfig(ForgeConfigSpec.Builder builder) {
        disableThirstForVampires = builder.comment("Whether vampires should not need to drink").define("disableThirstVampires", true);
        enableTemperatureVampires = builder.comment("Grant vampires cold resistance, but decrease heat resistance").define("enableTemperatureVampires", true);
        enableStaminaBoostVampires = builder.comment("Increase natural regeneration for vampires").define("enableStaminaBoostVampires", true);
    }

    public String getModID() {
        return "survive";
    }

    @Nullable
    public String getAcceptedVersionRange() {
        return "[1.16.5-3.4.4,)";
    }

    public void onInitStep(IInitListener.Step step, ParallelDispatchEvent event) {
        if (step == IInitListener.Step.COMMON_SETUP) {
            try {
                MinecraftForge.EVENT_BUS.register((Object)new ThirstHandler());
            }
            catch (Throwable e) {
                LogManager.getLogger().error("Failed to register survive thirst handler", e);
            }
        }
    }
}

