/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.items.wand;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.data.ICustomItemModel;
import thetadev.constructionwand.data.ItemModelGenerator;
import thetadev.constructionwand.items.ItemBase;
import thetadev.constructionwand.wand.WandJob;

public abstract class ItemWand
extends ItemBase
implements ICustomItemModel {
    public ItemWand(String name, Item.Properties properties) {
        super(name, properties);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        Hand hand = context.func_221531_n();
        World world = context.func_195991_k();
        if (world.field_72995_K || player == null) {
            return ActionResultType.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_() && ConstructionWand.instance.undoHistory.isUndoActive(player)) {
            return ConstructionWand.instance.undoHistory.undo(player, world, context.func_195995_a()) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        WandJob job = ItemWand.getWandJob(player, world, new BlockRayTraceResult(context.func_221532_j(), context.func_196000_l(), context.func_195995_a(), false), stack);
        return job.doIt() ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_225608_bj_()) {
            if (world.field_72995_K) {
                return ActionResult.func_226251_d_((Object)stack);
            }
            WandJob job = ItemWand.getWandJob(player, world, BlockRayTraceResult.func_216352_a((Vector3d)player.func_70040_Z(), (Direction)WandUtil.fromVector(player.func_70040_Z()), (BlockPos)WandUtil.playerPos(player)), stack);
            return job.doIt() ? ActionResult.func_226248_a_((Object)stack) : ActionResult.func_226251_d_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public static WandJob getWandJob(PlayerEntity player, World world, @Nullable BlockRayTraceResult rayTraceResult, ItemStack wand) {
        WandJob wandJob = new WandJob(player, world, rayTraceResult, wand);
        wandJob.getSnapshots();
        return wandJob;
    }

    public boolean func_150897_b(@Nonnull BlockState blockIn) {
        return false;
    }

    public boolean func_82789_a(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return false;
    }

    public int remainingDurability(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(@Nonnull ItemStack itemstack, World worldIn, @Nonnull List<ITextComponent> lines, @Nonnull ITooltipFlag extraInfo) {
        WandOptions options = new WandOptions(itemstack);
        int limit = ((IWandCore)options.cores.get()).getWandAction().getLimit(itemstack);
        String langTooltip = "constructionwand.tooltip.";
        if (Screen.func_231173_s_()) {
            for (int i = 1; i < options.allOptions.length; ++i) {
                IOption<?> opt = options.allOptions[i];
                lines.add((ITextComponent)new TranslationTextComponent(opt.getKeyTranslation()).func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent(opt.getValueTranslation()).func_240699_a_(TextFormatting.GRAY)));
            }
            if (!options.cores.getUpgrades().isEmpty()) {
                lines.add((ITextComponent)new StringTextComponent(""));
                lines.add((ITextComponent)new TranslationTextComponent(langTooltip + "cores").func_240699_a_(TextFormatting.GRAY));
                for (IWandCore core : options.cores.getUpgrades()) {
                    lines.add((ITextComponent)new TranslationTextComponent(options.cores.getKeyTranslation() + "." + core.getRegistryName().toString()));
                }
            }
        } else {
            IOption<?> opt = options.allOptions[0];
            lines.add((ITextComponent)new TranslationTextComponent(langTooltip + "blocks", new Object[]{limit}).func_240699_a_(TextFormatting.GRAY));
            lines.add((ITextComponent)new TranslationTextComponent(opt.getKeyTranslation()).func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent(opt.getValueTranslation()).func_240699_a_(TextFormatting.WHITE)));
            lines.add((ITextComponent)new TranslationTextComponent(langTooltip + "shift").func_240699_a_(TextFormatting.AQUA));
        }
    }

    public static void optionMessage(PlayerEntity player, IOption<?> option) {
        player.func_146105_b((ITextComponent)new TranslationTextComponent(option.getKeyTranslation()).func_240699_a_(TextFormatting.AQUA).func_230529_a_((ITextComponent)new TranslationTextComponent(option.getValueTranslation()).func_240699_a_(TextFormatting.WHITE)).func_230529_a_((ITextComponent)new StringTextComponent(" - ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)new TranslationTextComponent(option.getDescTranslation()).func_240699_a_(TextFormatting.WHITE)), true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator, String name) {
        ModelBuilder wandWithCore = ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(name + "_core", "item/handheld")).texture("layer0", generator.modLoc("item/" + name))).texture("layer1", generator.modLoc("item/overlay_core"));
        ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(name, "item/handheld")).texture("layer0", generator.modLoc("item/" + name))).override().predicate(generator.modLoc("using_core"), 1.0f).model((ModelFile)wandWithCore).end();
    }
}

