/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.wand.undo;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.wand.undo.ISnapshot;

public class DestroySnapshot
implements ISnapshot {
    private final BlockState block;
    private final BlockPos pos;

    public DestroySnapshot(BlockState block, BlockPos pos) {
        this.pos = pos;
        this.block = block;
    }

    @Nullable
    public static DestroySnapshot get(World world, PlayerEntity player, BlockPos pos) {
        if (!WandUtil.isBlockRemovable(world, player, pos)) {
            return null;
        }
        return new DestroySnapshot(world.func_180495_p(pos), pos);
    }

    @Override
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public BlockState getBlockState() {
        return this.block;
    }

    @Override
    public ItemStack getRequiredItems() {
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean execute(World world, PlayerEntity player, BlockRayTraceResult rayTraceResult) {
        return WandUtil.removeBlock(world, player, this.block, this.pos);
    }

    @Override
    public boolean canRestore(World world, PlayerEntity player) {
        if (!world.func_195588_v(this.pos)) {
            return false;
        }
        if (!world.func_175660_a(player, this.pos)) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        if (!world.func_175623_d(this.pos) && !world.func_180495_p(this.pos).func_227032_a_(Fluids.field_204541_a)) {
            return false;
        }
        return !WandUtil.entitiesCollidingWithBlock(world, this.block, this.pos);
    }

    @Override
    public boolean restore(World world, PlayerEntity player) {
        return WandUtil.placeBlock(world, player, this.block, this.pos, null);
    }

    @Override
    public void forceRestore(World world) {
        world.func_175656_a(this.pos, this.block);
    }
}

