/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import net.blay09.mods.inventoryessentials.InventoryEssentials;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.client.ClientOnlyInventoryControls;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.blay09.mods.inventoryessentials.client.ServerSupportedInventoryControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="inventoryessentials", value={Dist.CLIENT})
public class ClientEventHandler {
    private static final InventoryControls clientOnlyControls = new ClientOnlyInventoryControls();
    private static final InventoryControls serverSupportedControls = new ServerSupportedInventoryControls();
    private static Slot lastDragHoverSlot;

    private static InventoryControls getInventoryControls() {
        return InventoryEssentials.isServerSideInstalled && (Boolean)InventoryEssentialsConfig.CLIENT.forceClientImplementation.get() == false ? serverSupportedControls : clientOnlyControls;
    }

    @SubscribeEvent
    public static void onMouseDrag(GuiScreenEvent.MouseDragEvent event) {
        if (Screen.func_231173_s_() && ((Boolean)InventoryEssentialsConfig.CLIENT.enableShiftDrag.get()).booleanValue()) {
            ContainerScreen screen;
            Slot hoverSlot;
            InventoryControls controls = ClientEventHandler.getInventoryControls();
            if (event.getGui() instanceof ContainerScreen && (hoverSlot = (screen = (ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && hoverSlot.func_75216_d() && hoverSlot != lastDragHoverSlot) {
                controls.dragTransfer(screen, hoverSlot);
                lastDragHoverSlot = hoverSlot;
            }
        } else {
            lastDragHoverSlot = null;
        }
    }

    @SubscribeEvent
    public static void onMouseClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        InventoryControls controls = ClientEventHandler.getInventoryControls();
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen screen = (ContainerScreen)event.getGui();
            Slot hoverSlot = screen.getSlotUnderMouse();
            if (hoverSlot instanceof CraftingResultSlot) {
                return;
            }
            if (Screen.func_231173_s_() && Screen.func_231172_r_() && ((Boolean)InventoryEssentialsConfig.CLIENT.enableBulkTransfer.get()).booleanValue()) {
                if (hoverSlot != null && controls.bulkTransferByType(screen, hoverSlot)) {
                    event.setCanceled(true);
                }
            } else if (Screen.func_231172_r_() && ((Boolean)InventoryEssentialsConfig.CLIENT.enableSingleTransfer.get()).booleanValue()) {
                if (hoverSlot != null && controls.singleTransfer(screen, hoverSlot)) {
                    event.setCanceled(true);
                }
            } else if (ClientEventHandler.hasSpaceDown() && ((Boolean)InventoryEssentialsConfig.CLIENT.enableBulkTransferAll.get()).booleanValue() && hoverSlot != null && controls.bulkTransferAll(screen, hoverSlot)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onKeyPress(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
        InventoryControls controls = ClientEventHandler.getInventoryControls();
        if (event.getGui() instanceof ContainerScreen) {
            ContainerScreen screen = (ContainerScreen)event.getGui();
            Slot hoverSlot = screen.getSlotUnderMouse();
            InputMappings.Input input = InputMappings.func_197954_a((int)event.getKeyCode(), (int)event.getScanCode());
            if (Screen.func_231173_s_() && Screen.func_231172_r_() && Minecraft.func_71410_x().field_71474_y.field_74316_C.isActiveAndMatches(input) && ((Boolean)InventoryEssentialsConfig.CLIENT.enableBulkDrop.get()).booleanValue() && hoverSlot != null && controls.dropByType(screen, hoverSlot)) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean hasSpaceDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32);
    }
}

