/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials.client;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.blay09.mods.inventoryessentials.InventoryEssentialsConfig;
import net.blay09.mods.inventoryessentials.InventoryUtils;
import net.blay09.mods.inventoryessentials.client.InventoryControls;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class ClientOnlyInventoryControls
implements InventoryControls {
    @Override
    public boolean singleTransfer(ContainerScreen<?> screen, Slot clickedSlot) {
        Container container = screen.func_212873_a_();
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!clickedSlot.func_82869_a((PlayerEntity)Objects.requireNonNull(player))) {
            return false;
        }
        ItemStack targetStack = clickedSlot.func_75211_c().func_77946_l();
        if (targetStack.func_190916_E() == 1) {
            this.slotClick(container, clickedSlot, 0, ClickType.QUICK_MOVE);
            return true;
        }
        Slot fallbackSlot = null;
        for (Slot slot : container.field_75151_b) {
            ItemStack stack = slot.func_75211_c();
            if (slot == clickedSlot || !slot.func_75214_a(targetStack) || InventoryUtils.isSameInventory(clickedSlot, slot) || stack.func_190916_E() >= Math.min(slot.func_75219_a(), slot.func_178170_b(stack))) continue;
            if (ItemStack.func_185132_d((ItemStack)targetStack, (ItemStack)stack)) {
                this.slotClick(container, clickedSlot, 1, ClickType.PICKUP);
                this.slotClick(container, slot, 1, ClickType.PICKUP);
                this.slotClick(container, clickedSlot, 0, ClickType.PICKUP);
                return true;
            }
            if (slot.func_75216_d() || fallbackSlot != null) continue;
            fallbackSlot = slot;
        }
        if (fallbackSlot != null) {
            this.slotClick(container, clickedSlot, 1, ClickType.PICKUP);
            this.slotClick(container, fallbackSlot, 1, ClickType.PICKUP);
            this.slotClick(container, clickedSlot, 0, ClickType.PICKUP);
            return true;
        }
        return false;
    }

    @Override
    public boolean bulkTransferByType(ContainerScreen<?> screen, Slot clickedSlot) {
        ItemStack targetStack = clickedSlot.func_75211_c().func_77946_l();
        Container container = screen.func_212873_a_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(clickedSlot);
        for (Slot slot : container.field_75151_b) {
            ItemStack stack;
            if (slot == clickedSlot || !InventoryUtils.isSameInventory(slot, clickedSlot) || !ItemStack.func_185132_d((ItemStack)targetStack, (ItemStack)(stack = slot.func_75211_c()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(container, transferSlot, 0, ClickType.QUICK_MOVE);
        }
        return true;
    }

    @Override
    public boolean bulkTransferAll(ContainerScreen<?> screen, Slot clickedSlot) {
        if (!((Boolean)InventoryEssentialsConfig.CLIENT.allowBulkTransferAllOnEmptySlot.get()).booleanValue() && !clickedSlot.func_75216_d()) {
            return false;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Container container = screen.func_212873_a_();
        boolean isProbablyMovingToPlayerInventory = false;
        if (!(clickedSlot.field_75224_c instanceof PlayerInventory)) {
            isProbablyMovingToPlayerInventory = InventoryUtils.containerContainsPlayerInventory(container);
        }
        boolean movedAny = false;
        if (isProbablyMovingToPlayerInventory) {
            ArrayDeque<Slot> emptySlots = new ArrayDeque<Slot>();
            ArrayList<Slot> nonEmptySlots = new ArrayList<Slot>();
            for (Slot slot : container.field_75151_b) {
                if (InventoryUtils.isSameInventory(slot, clickedSlot) || !(slot.field_75224_c instanceof PlayerInventory)) continue;
                if (slot.func_75216_d()) {
                    nonEmptySlots.add(slot);
                    continue;
                }
                if (PlayerInventory.func_184435_e((int)slot.getSlotIndex())) continue;
                emptySlots.add(slot);
            }
            for (Slot slot : container.field_75151_b) {
                if (!slot.func_82869_a((PlayerEntity)Objects.requireNonNull(player)) || !InventoryUtils.isSameInventory(slot, clickedSlot, true) || !this.bulkTransferPreferInventory(container, player.field_71071_by, emptySlots, nonEmptySlots, slot)) continue;
                movedAny = true;
            }
        } else {
            for (Slot slot : container.field_75151_b) {
                if (!slot.func_82869_a((PlayerEntity)Objects.requireNonNull(player)) || !InventoryUtils.isSameInventory(slot, clickedSlot, true)) continue;
                this.slotClick(container, slot, 0, ClickType.QUICK_MOVE);
                movedAny = true;
            }
        }
        return movedAny;
    }

    private boolean bulkTransferPreferInventory(Container container, PlayerInventory playerInventory, Deque<Slot> emptySlots, List<Slot> nonEmptySlots, Slot slot) {
        ItemStack targetStack = slot.func_75211_c();
        if (targetStack.func_190926_b()) {
            return false;
        }
        this.slotClick(container, slot, 0, ClickType.PICKUP);
        for (Slot nonEmptySlot : nonEmptySlots) {
            boolean hasSpaceLeft;
            ItemStack stack = slot.func_75211_c();
            if (!ItemStack.func_185132_d((ItemStack)targetStack, (ItemStack)stack)) continue;
            boolean bl = hasSpaceLeft = stack.func_190916_E() < Math.min(slot.func_75219_a(), slot.func_178170_b(stack));
            if (!hasSpaceLeft) continue;
            this.slotClick(container, nonEmptySlot, 0, ClickType.PICKUP);
            ItemStack mouseItem = playerInventory.func_70445_o();
            if (!mouseItem.func_190926_b()) continue;
            return true;
        }
        Iterator<Slot> iterator = emptySlots.iterator();
        while (iterator.hasNext()) {
            ItemStack mouseItem;
            Slot emptySlot = iterator.next();
            this.slotClick(container, emptySlot, 0, ClickType.PICKUP);
            if (emptySlot.func_75216_d()) {
                nonEmptySlots.add(emptySlot);
                iterator.remove();
            }
            if (!(mouseItem = playerInventory.func_70445_o()).func_190926_b()) continue;
            return true;
        }
        ItemStack mouseItem = playerInventory.func_70445_o();
        if (!mouseItem.func_190926_b()) {
            this.slotClick(container, slot, 0, ClickType.PICKUP);
        }
        return false;
    }

    @Override
    public void dragTransfer(ContainerScreen<?> screen, Slot clickedSlot) {
        this.slotClick(screen.func_212873_a_(), clickedSlot, 0, ClickType.QUICK_MOVE);
    }

    private void slotClick(Container container, Slot slot, int mouseButton, ClickType clickType) {
        Minecraft.func_71410_x().field_71442_b.func_187098_a(container.field_75152_c, slot.field_75222_d, mouseButton, clickType, (PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public boolean dropByType(ContainerScreen<?> screen, Slot hoverSlot) {
        ItemStack targetStack = hoverSlot.func_75211_c().func_77946_l();
        Container container = screen.func_212873_a_();
        ArrayList<Slot> transferSlots = new ArrayList<Slot>();
        transferSlots.add(hoverSlot);
        for (Slot slot : container.field_75151_b) {
            ItemStack stack;
            if (slot == hoverSlot || !InventoryUtils.isSameInventory(slot, hoverSlot) || !ItemStack.func_185132_d((ItemStack)targetStack, (ItemStack)(stack = slot.func_75211_c()))) continue;
            transferSlots.add(slot);
        }
        for (Slot transferSlot : transferSlots) {
            this.slotClick(container, transferSlot, 1, ClickType.THROW);
        }
        return true;
    }
}

