/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigLibClient;
import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="supermartijn642configlib")
public class ConfigLib {
    public static final Logger LOGGER = LogManager.getLogger((String)"configlib");
    protected static final ResourceLocation CHANNEL_ID = new ResourceLocation("supermartijn642configlib", "sync_configs");
    private static SimpleChannel channel;
    private static final List<ModConfig<?>> CONFIGS;
    private static final Set<String> CONFIG_NAMES;
    private static final List<ModConfig<?>> SYNCABLE_CONFIGS;
    private static final Map<String, ModConfig<?>> SYNCABLE_CONFIGS_BY_IDENTIFIER;

    public ConfigLib() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(ConfigLib::getModVersion, (remoteVersion, isFromServer) -> ConfigLib.canConnectWith(remoteVersion)));
        MinecraftForge.EVENT_BUS.addListener(e -> ConfigLib.onLoadGame());
        MinecraftForge.EVENT_BUS.addListener(e -> {
            if (e.getPlayer() instanceof ServerPlayerEntity) {
                ConfigLib.onPlayerJoinServer((ServerPlayerEntity)e.getPlayer());
            }
        });
        if (ConfigLib.isClientEnvironment()) {
            ConfigLibClient.registerEventListeners();
        }
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)CHANNEL_ID, ConfigLib::getModVersion, ConfigLib::canConnectWith, ConfigLib::canConnectWith);
        channel.registerMessage(0, ConfigSyncPacket.class, ConfigLib::createSyncedEntriesPacket, buffer -> ConfigLib.handleSyncConfigPacket(buffer), (packet, context) -> ((NetworkEvent.Context)context.get()).setPacketHandled(true));
    }

    public static boolean isClientEnvironment() {
        return FMLEnvironment.dist == Dist.CLIENT;
    }

    public static boolean isServerEnvironment() {
        return FMLEnvironment.dist == Dist.DEDICATED_SERVER;
    }

    public static String getModVersion() {
        return ((ModContainer)ModList.get().getModContainerById("supermartijn642configlib").orElseThrow(AssertionError::new)).getModInfo().getVersion().toString();
    }

    public static boolean canConnectWith(String remoteVersion) {
        return SYNCABLE_CONFIGS.isEmpty() || ConfigLib.getModVersion().equals(remoteVersion);
    }

    public static File getConfigFolder() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    protected static synchronized void addConfig(ModConfig<?> config) {
        if (CONFIG_NAMES.contains(config.getIdentifier())) {
            throw new IllegalStateException("Config '" + config.getIdentifier() + "' for mod '" + config.getModid() + "' already exists!");
        }
        CONFIGS.add(config);
        CONFIG_NAMES.add(config.getIdentifier());
        if (config.hasSyncableEntries()) {
            SYNCABLE_CONFIGS.add(config);
            SYNCABLE_CONFIGS_BY_IDENTIFIER.put(config.getIdentifier(), config);
        }
        config.initialize();
    }

    protected static void onLoadGame() {
        CONFIGS.forEach(ModConfig::onJoinGame);
    }

    protected static void onLeaveGame() {
        CONFIGS.forEach(ModConfig::onLeaveGame);
    }

    protected static void onPlayerJoinServer(ServerPlayerEntity sender) {
        ConfigLib.sendSyncConfigPackets(sender);
    }

    private static void sendSyncConfigPackets(ServerPlayerEntity sender) {
        for (ModConfig<?> config : SYNCABLE_CONFIGS) {
            channel.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new ConfigSyncPacket(config));
        }
    }

    private static void createSyncedEntriesPacket(ConfigSyncPacket packet, PacketBuffer buffer) {
        ModConfig<?> config = packet.config;
        buffer.func_180714_a(config.getIdentifier());
        try {
            config.writeSyncableEntries((ByteBuf)buffer);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to write syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", e);
        }
    }

    protected static ConfigSyncPacket handleSyncConfigPacket(PacketBuffer buffer) {
        String identifier = buffer.func_218666_n();
        ModConfig<?> config = SYNCABLE_CONFIGS_BY_IDENTIFIER.get(identifier);
        if (config == null) {
            LOGGER.error("Received config sync packet for unknown config '" + identifier + "'!");
            return null;
        }
        try {
            config.readSyncableValues((ByteBuf)buffer);
        }
        catch (Exception e) {
            LOGGER.error("Failed to read syncable config entries for config '" + config.getIdentifier() + "' from mod '" + config.getModid() + "'!", (Throwable)e);
        }
        return new ConfigSyncPacket();
    }

    static {
        CONFIGS = new ArrayList();
        CONFIG_NAMES = new HashSet<String>();
        SYNCABLE_CONFIGS = new ArrayList();
        SYNCABLE_CONFIGS_BY_IDENTIFIER = new HashMap();
    }
}

