/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import com.tom.storagemod.Config;
import com.tom.storagemod.block.BlockInventoryCable;
import com.tom.storagemod.block.BlockInventoryCableConnector;
import com.tom.storagemod.block.BlockInventoryCableConnectorFiltered;
import com.tom.storagemod.block.BlockInventoryCableFramed;
import com.tom.storagemod.block.BlockInventoryHopperBasic;
import com.tom.storagemod.block.BlockInventoryProxy;
import com.tom.storagemod.block.BlockLevelEmitter;
import com.tom.storagemod.block.BlockOpenCrate;
import com.tom.storagemod.block.BlockPaintedTrim;
import com.tom.storagemod.block.BlockTrim;
import com.tom.storagemod.block.CraftingTerminal;
import com.tom.storagemod.block.InventoryConnector;
import com.tom.storagemod.block.StorageTerminal;
import com.tom.storagemod.gui.ContainerCraftingTerminal;
import com.tom.storagemod.gui.ContainerFiltered;
import com.tom.storagemod.gui.ContainerLevelEmitter;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.item.ItemAdvWirelessTerminal;
import com.tom.storagemod.item.ItemBlockPainted;
import com.tom.storagemod.item.ItemPaintKit;
import com.tom.storagemod.item.ItemWirelessTerminal;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.proxy.ClientProxy;
import com.tom.storagemod.proxy.IProxy;
import com.tom.storagemod.proxy.ServerProxy;
import com.tom.storagemod.tile.TileEntityCraftingTerminal;
import com.tom.storagemod.tile.TileEntityInventoryCableConnector;
import com.tom.storagemod.tile.TileEntityInventoryCableConnectorFiltered;
import com.tom.storagemod.tile.TileEntityInventoryConnector;
import com.tom.storagemod.tile.TileEntityInventoryHopperBasic;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import com.tom.storagemod.tile.TileEntityLevelEmitter;
import com.tom.storagemod.tile.TileEntityOpenCrate;
import com.tom.storagemod.tile.TileEntityPainted;
import com.tom.storagemod.tile.TileEntityStorageTerminal;
import net.minecraft.block.Block;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypePreset;

@Mod(value="toms_storage")
public class StorageMod {
    public static final String modid = "toms_storage";
    public static IProxy proxy = (IProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static InventoryConnector connector;
    public static StorageTerminal terminal;
    public static BlockTrim inventoryTrim;
    public static BlockOpenCrate openCrate;
    public static BlockPaintedTrim paintedTrim;
    public static BlockInventoryCable invCable;
    public static BlockInventoryCableFramed invCableFramed;
    public static BlockInventoryCableConnector invCableConnector;
    public static BlockInventoryCableConnectorFiltered invCableConnectorFiltered;
    public static BlockInventoryProxy invProxy;
    public static CraftingTerminal craftingTerminal;
    public static BlockInventoryHopperBasic invHopperBasic;
    public static BlockLevelEmitter levelEmitter;
    public static ItemPaintKit paintingKit;
    public static ItemWirelessTerminal wirelessTerminal;
    public static ItemAdvWirelessTerminal advWirelessTerminal;
    public static TileEntityType<TileEntityInventoryConnector> connectorTile;
    public static TileEntityType<TileEntityStorageTerminal> terminalTile;
    public static TileEntityType<TileEntityOpenCrate> openCrateTile;
    public static TileEntityType<TileEntityPainted> paintedTile;
    public static TileEntityType<TileEntityInventoryCableConnector> invCableConnectorTile;
    public static TileEntityType<TileEntityInventoryCableConnectorFiltered> invCableConnectorFilteredTile;
    public static TileEntityType<TileEntityInventoryProxy> invProxyTile;
    public static TileEntityType<TileEntityCraftingTerminal> craftingTerminalTile;
    public static TileEntityType<TileEntityInventoryHopperBasic> invHopperBasicTile;
    public static TileEntityType<TileEntityLevelEmitter> levelEmitterTile;
    public static ContainerType<ContainerStorageTerminal> storageTerminal;
    public static ContainerType<ContainerCraftingTerminal> craftingTerminalCont;
    public static ContainerType<ContainerFiltered> filteredConatiner;
    public static ContainerType<ContainerLevelEmitter> levelEmitterConatiner;
    public static final Logger LOGGER;
    public static final ItemGroup STORAGE_MOD_TAB;

    public StorageMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.serverSpec);
        FMLJavaModLoadingContext.get().getModEventBus().register(Config.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Tom's Storage Setup starting");
        proxy.setup();
        NetworkHandler.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        proxy.clientSetup();
    }

    public void enqueueIMC(InterModEnqueueEvent e) {
        if (ModList.get().isLoaded("curios")) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        }
    }

    static {
        LOGGER = LogManager.getLogger();
        STORAGE_MOD_TAB = new ItemGroup(modid){

            @OnlyIn(value=Dist.CLIENT)
            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)terminal);
            }
        };
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            connector = new InventoryConnector();
            terminal = new StorageTerminal();
            openCrate = new BlockOpenCrate();
            inventoryTrim = new BlockTrim();
            paintedTrim = new BlockPaintedTrim();
            invCable = new BlockInventoryCable();
            invCableFramed = new BlockInventoryCableFramed();
            invCableConnector = new BlockInventoryCableConnector();
            invCableConnectorFiltered = new BlockInventoryCableConnectorFiltered();
            invProxy = new BlockInventoryProxy();
            craftingTerminal = new CraftingTerminal();
            invHopperBasic = new BlockInventoryHopperBasic();
            levelEmitter = new BlockLevelEmitter();
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)connector);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)terminal);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)openCrate);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)inventoryTrim);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)paintedTrim);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)invCable);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)invCableFramed);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)invCableConnector);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)invCableConnectorFiltered);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)invProxy);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)craftingTerminal);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)invHopperBasic);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)levelEmitter);
        }

        @SubscribeEvent
        public static void onItemsRegistry(RegistryEvent.Register<Item> itemRegistryEvent) {
            paintingKit = new ItemPaintKit();
            wirelessTerminal = new ItemWirelessTerminal();
            advWirelessTerminal = new ItemAdvWirelessTerminal();
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)connector);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)terminal);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)openCrate);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, inventoryTrim);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new ItemBlockPainted((Block)paintedTrim));
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCable);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new ItemBlockPainted((Block)invCableFramed, new Item.Properties().func_200916_a(STORAGE_MOD_TAB)));
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCableConnector);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invCableConnectorFiltered);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)new ItemBlockPainted((Block)invProxy, new Item.Properties().func_200916_a(STORAGE_MOD_TAB)));
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)craftingTerminal);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)invHopperBasic);
            RegistryEvents.registerItemForBlock(itemRegistryEvent, (Block)levelEmitter);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)paintingKit);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)wirelessTerminal);
            itemRegistryEvent.getRegistry().register((IForgeRegistryEntry)advWirelessTerminal);
        }

        private static void registerItemForBlock(RegistryEvent.Register<Item> itemRegistryEvent, Block block) {
            itemRegistryEvent.getRegistry().register(new BlockItem(block, new Item.Properties().func_200916_a(STORAGE_MOD_TAB)).setRegistryName(block.getRegistryName()));
        }

        @SubscribeEvent
        public static void onTileRegistry(RegistryEvent.Register<TileEntityType<?>> tileRegistryEvent) {
            connectorTile = TileEntityType.Builder.func_223042_a(TileEntityInventoryConnector::new, (Block[])new Block[]{connector}).func_206865_a(null);
            connectorTile.setRegistryName("ts.inventory_connector.tile");
            terminalTile = TileEntityType.Builder.func_223042_a(TileEntityStorageTerminal::new, (Block[])new Block[]{terminal}).func_206865_a(null);
            terminalTile.setRegistryName("ts.storage_terminal.tile");
            openCrateTile = TileEntityType.Builder.func_223042_a(TileEntityOpenCrate::new, (Block[])new Block[]{openCrate}).func_206865_a(null);
            openCrateTile.setRegistryName("ts.open_crate.tile");
            paintedTile = TileEntityType.Builder.func_223042_a(TileEntityPainted::new, (Block[])new Block[]{paintedTrim, invCableFramed}).func_206865_a(null);
            paintedTile.setRegistryName("ts.painted.tile");
            invCableConnectorTile = TileEntityType.Builder.func_223042_a(TileEntityInventoryCableConnector::new, (Block[])new Block[]{invCableConnector}).func_206865_a(null);
            invCableConnectorTile.setRegistryName("ts.inventory_cable_connector.tile");
            invCableConnectorFilteredTile = TileEntityType.Builder.func_223042_a(TileEntityInventoryCableConnectorFiltered::new, (Block[])new Block[]{invCableConnectorFiltered}).func_206865_a(null);
            invCableConnectorFilteredTile.setRegistryName("ts.inventory_cable_connector_filtered.tile");
            invProxyTile = TileEntityType.Builder.func_223042_a(TileEntityInventoryProxy::new, (Block[])new Block[]{invProxy}).func_206865_a(null);
            invProxyTile.setRegistryName("ts.inventory_proxy.tile");
            craftingTerminalTile = TileEntityType.Builder.func_223042_a(TileEntityCraftingTerminal::new, (Block[])new Block[]{craftingTerminal}).func_206865_a(null);
            craftingTerminalTile.setRegistryName("ts.crafting_terminal.tile");
            invHopperBasicTile = TileEntityType.Builder.func_223042_a(TileEntityInventoryHopperBasic::new, (Block[])new Block[]{invHopperBasic}).func_206865_a(null);
            invHopperBasicTile.setRegistryName("ts.inventoty_hopper_basic.tile");
            levelEmitterTile = TileEntityType.Builder.func_223042_a(TileEntityLevelEmitter::new, (Block[])new Block[]{levelEmitter}).func_206865_a(null);
            levelEmitterTile.setRegistryName("ts.level_emitter.tile");
            tileRegistryEvent.getRegistry().register(connectorTile);
            tileRegistryEvent.getRegistry().register(terminalTile);
            tileRegistryEvent.getRegistry().register(openCrateTile);
            tileRegistryEvent.getRegistry().register(paintedTile);
            tileRegistryEvent.getRegistry().register(invCableConnectorTile);
            tileRegistryEvent.getRegistry().register(invCableConnectorFilteredTile);
            tileRegistryEvent.getRegistry().register(invProxyTile);
            tileRegistryEvent.getRegistry().register(craftingTerminalTile);
            tileRegistryEvent.getRegistry().register(invHopperBasicTile);
            tileRegistryEvent.getRegistry().register(levelEmitterTile);
        }

        @SubscribeEvent
        public static void onContainerRegistry(RegistryEvent.Register<ContainerType<?>> containerRegistryEvent) {
            storageTerminal = new ContainerType(ContainerStorageTerminal::new);
            storageTerminal.setRegistryName("ts.storage_terminal.container");
            craftingTerminalCont = new ContainerType(ContainerCraftingTerminal::new);
            craftingTerminalCont.setRegistryName("ts.crafting_terminal.container");
            filteredConatiner = new ContainerType(ContainerFiltered::new);
            filteredConatiner.setRegistryName("ts.filtered.container");
            levelEmitterConatiner = new ContainerType(ContainerLevelEmitter::new);
            levelEmitterConatiner.setRegistryName("ts.level_emitter.container");
            containerRegistryEvent.getRegistry().register(storageTerminal);
            containerRegistryEvent.getRegistry().register(craftingTerminalCont);
            containerRegistryEvent.getRegistry().register(filteredConatiner);
            containerRegistryEvent.getRegistry().register(levelEmitterConatiner);
        }
    }
}

