/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod;

import java.util.Comparator;
import java.util.function.Function;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class StoredItemStack {
    private ItemStack stack;
    private long count;
    private static final String ITEM_COUNT_NAME = "c";
    private static final String ITEMSTACK_NAME = "s";

    public StoredItemStack(ItemStack stack, long count) {
        this.stack = stack;
        this.count = count;
    }

    public StoredItemStack(ItemStack stack) {
        this.stack = stack.func_77946_l();
        this.stack.func_190920_e(1);
        this.count = stack.func_190916_E();
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public long getQuantity() {
        return this.count;
    }

    public ItemStack getActualStack() {
        ItemStack s = this.stack.func_77946_l();
        s.func_190920_e((int)this.count);
        return s;
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74772_a(ITEM_COUNT_NAME, this.getQuantity());
        tag.func_218657_a(ITEMSTACK_NAME, (INBT)this.stack.func_77955_b(new CompoundNBT()));
        tag.func_74775_l(ITEMSTACK_NAME).func_82580_o("Count");
    }

    public void writeToNBT(CompoundNBT tag, long q) {
        tag.func_74772_a(ITEM_COUNT_NAME, q);
        tag.func_218657_a(ITEMSTACK_NAME, (INBT)this.stack.func_77955_b(new CompoundNBT()));
        tag.func_74775_l(ITEMSTACK_NAME).func_82580_o("Count");
    }

    public static StoredItemStack readFromNBT(CompoundNBT tag) {
        ItemStack cheat = ItemStack.func_199557_a((CompoundNBT)tag);
        tag.func_74775_l(ITEMSTACK_NAME).func_74774_a("Count", (byte)1);
        StoredItemStack stack = new StoredItemStack(!cheat.func_190926_b() ? cheat : ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l(ITEMSTACK_NAME)), !cheat.func_190926_b() ? (long)cheat.func_190916_E() : tag.func_74763_f(ITEM_COUNT_NAME));
        return !stack.stack.func_190926_b() ? stack : null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.stack == null ? 0 : this.stack.func_77973_b().hashCode());
        result = 31 * result + (this.stack == null || !this.stack.func_77942_o() ? 0 : this.stack.func_77978_p().hashCode());
        return result;
    }

    public String getDisplayName() {
        return this.stack.func_200301_q().getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoredItemStack other = (StoredItemStack)obj;
        return !(this.stack == null ? other.stack != null : !ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)other.stack) || !ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other.stack));
    }

    public boolean equals(StoredItemStack other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.count != other.count) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !ItemStack.func_179545_c((ItemStack)this.stack, (ItemStack)other.stack) || !ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)other.stack));
    }

    public void grow(long c) {
        this.count += c;
    }

    public static enum SortingTypes {
        AMOUNT(ComparatorAmount::new),
        NAME(ComparatorName::new);

        public static final SortingTypes[] VALUES;
        private final Function<Boolean, IStoredItemStackComparator> factory;

        private SortingTypes(Function<Boolean, IStoredItemStackComparator> factory) {
            this.factory = factory;
        }

        public IStoredItemStackComparator create(boolean rev) {
            return this.factory.apply(rev);
        }

        static {
            VALUES = SortingTypes.values();
        }
    }

    public static interface IStoredItemStackComparator
    extends Comparator<StoredItemStack> {
        public boolean isReversed();

        public void setReversed(boolean var1);

        public int type();
    }

    public static class ComparatorName
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorName(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in1.getDisplayName().compareTo(in2.getDisplayName());
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 1;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }

    public static class ComparatorAmount
    implements IStoredItemStackComparator {
        public boolean reversed;

        public ComparatorAmount(boolean reversed) {
            this.reversed = reversed;
        }

        @Override
        public int compare(StoredItemStack in1, StoredItemStack in2) {
            int c = in2.getQuantity() > in1.getQuantity() ? 1 : (in1.getQuantity() == in2.getQuantity() ? in1.getStack().func_200301_q().func_150261_e().compareTo(in2.getStack().func_200301_q().func_150261_e()) : -1);
            return this.reversed ? -c : c;
        }

        @Override
        public boolean isReversed() {
            return this.reversed;
        }

        @Override
        public int type() {
            return 0;
        }

        @Override
        public void setReversed(boolean rev) {
            this.reversed = rev;
        }
    }
}

