/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.block.IPaintable;
import com.tom.storagemod.proxy.ClientProxy;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import com.tom.storagemod.tile.TileEntityPainted;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootContext;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class BlockInventoryProxy
extends ContainerBlock
implements IPaintable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final EnumProperty<DirectionWithNull> FILTER_FACING = EnumProperty.func_177709_a((String)"filter_facing", DirectionWithNull.class);

    public BlockInventoryProxy() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).harvestTool(ToolType.AXE));
        this.setRegistryName("ts.inventory_proxy");
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.DOWN)).func_206870_a(FILTER_FACING, (Comparable)((Object)DirectionWithNull.NULL)));
    }

    public void func_190948_a(ItemStack stack, IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.paintable"));
        ClientProxy.tooltip("inventory_proxy", tooltip, new Object[0]);
        if (Screen.func_231173_s_()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.inventory_proxy.key", new Object[]{"ignoreSize", new TranslationTextComponent("tooltip.toms_storage.inventory_proxy.ignoreSize")}));
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.inventory_proxy.value", new Object[]{"maxCount", new TranslationTextComponent("tooltip.toms_storage.inventory_proxy.maxCount.arg"), new TranslationTextComponent("tooltip.toms_storage.inventory_proxy.maxCount.desc")}));
        }
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntityInventoryProxy();
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_196000_l().func_176734_d());
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, FILTER_FACING});
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Override
    public boolean paint(World world, BlockPos pos, BlockState to) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityPainted) {
            return ((TileEntityPainted)te).setPaintedBlockState(to);
        }
        return false;
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List stacks = super.func_220076_a(state, builder);
        if (state.func_177229_b(FILTER_FACING) != DirectionWithNull.NULL) {
            stacks.add(new ItemStack((IItemProvider)Items.field_151045_i));
        }
        return stacks;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177229_b(FILTER_FACING) != DirectionWithNull.NULL && te instanceof TileEntityInventoryProxy) {
            return ((TileEntityInventoryProxy)te).getComparatorOutput();
        }
        return Container.func_178144_a((TileEntity)te);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151045_i && state.func_177229_b((Property)FACING) != hit.func_216354_b()) {
            if (state.func_177229_b(FILTER_FACING) == DirectionWithNull.NULL && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a(FILTER_FACING, (Comparable)((Object)DirectionWithNull.of(hit.func_216354_b()))));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static enum DirectionWithNull implements IStringSerializable
    {
        NULL("notset"),
        DOWN(Direction.DOWN),
        UP(Direction.UP),
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST);

        private final String name;
        private final Direction dir;
        private static final Map<Direction, DirectionWithNull> dir2dirwn;

        private DirectionWithNull(Direction dir) {
            this.name = dir.func_176610_l();
            this.dir = dir;
        }

        public static DirectionWithNull of(Direction side) {
            return dir2dirwn.get(side);
        }

        private DirectionWithNull(String name) {
            this.name = name;
            this.dir = null;
        }

        public String func_176610_l() {
            return this.name;
        }

        public Direction getDir() {
            return this.dir;
        }

        static {
            dir2dirwn = new HashMap<Direction, DirectionWithNull>();
            for (DirectionWithNull dwn : DirectionWithNull.values()) {
                if (dwn.dir == null) continue;
                dir2dirwn.put(dwn.dir, dwn);
            }
        }
    }
}

