/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.tom.storagemod.tile.TileEntityStorageTerminal;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public abstract class StorageTerminalBase
extends ContainerBlock
implements IWaterLoggable {
    public static final EnumProperty<TerminalPos> TERMINAL_POS = EnumProperty.func_177709_a((String)"pos", TerminalPos.class);
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape SHAPE_N = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)6.0);
    private static final VoxelShape SHAPE_S = Block.func_208617_a((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E = Block.func_208617_a((double)10.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_U = Block.func_208617_a((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_D = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);

    public StorageTerminalBase() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200943_b(3.0f).harvestTool(ToolType.AXE).func_235838_a_(s -> 6));
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TERMINAL_POS, (Comparable)((Object)TerminalPos.CENTER))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED, TERMINAL_POS});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rtr) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity blockEntity_1 = world.func_175625_s(pos);
        if (blockEntity_1 instanceof TileEntityStorageTerminal) {
            TileEntityStorageTerminal term = (TileEntityStorageTerminal)blockEntity_1;
            if (term.canInteractWith(player)) {
                player.func_213829_a((INamedContainerProvider)term);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.toms_storage.terminal_out_of_range"), true);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l().func_176734_d();
        FluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        TerminalPos pos = TerminalPos.CENTER;
        if (direction.func_176740_k() == Direction.Axis.Y) {
            if (direction == Direction.UP) {
                pos = TerminalPos.UP;
            }
            if (direction == Direction.DOWN) {
                pos = TerminalPos.DOWN;
            }
            direction = context.func_195992_f();
        }
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)(direction.func_176740_k() == Direction.Axis.Y ? Direction.NORTH : direction))).func_206870_a(TERMINAL_POS, (Comparable)((Object)pos))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((TerminalPos)((Object)state.func_177229_b(TERMINAL_POS))) {
            case CENTER: {
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        return SHAPE_N;
                    }
                    case SOUTH: {
                        return SHAPE_S;
                    }
                    case EAST: {
                        return SHAPE_E;
                    }
                    case WEST: {
                        return SHAPE_W;
                    }
                }
                break;
            }
            case UP: {
                return SHAPE_U;
            }
            case DOWN: {
                return SHAPE_D;
            }
        }
        return SHAPE_N;
    }

    public static enum TerminalPos implements IStringSerializable
    {
        CENTER("center"),
        UP("up"),
        DOWN("down");

        private String name;

        private TerminalPos(String name) {
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

