/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.GuiStorageTerminal;
import com.tom.storagemod.gui.GuiStorageTerminalBase;
import com.tom.storagemod.network.IDataReceiver;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.tile.TileEntityStorageTerminal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class ContainerStorageTerminal
extends RecipeBookContainer<CraftingInventory>
implements IDataReceiver {
    private static final int DIVISION_BASE = 1000;
    private static final char[] ENCODED_POSTFIXES = "KMGTPE".toCharArray();
    public static final Format format;
    protected TileEntityStorageTerminal te;
    protected int playerSlotsStart;
    protected List<SlotStorage> storageSlotList = new ArrayList<SlotStorage>();
    public List<StoredItemStack> itemList = Lists.newArrayList();
    public List<StoredItemStack> itemListClient = Lists.newArrayList();
    public List<StoredItemStack> itemListClientSorted = Lists.newArrayList();
    private Map<StoredItemStack, Long> itemsCount = new HashMap<StoredItemStack, Long>();
    private int lines;
    protected PlayerInventory pinv;
    public Runnable onPacket;
    public int terminalData;
    public String search;

    public ContainerStorageTerminal(int id, PlayerInventory inv, TileEntityStorageTerminal te) {
        this(StorageMod.storageTerminal, id, inv, te);
        this.addPlayerSlots(inv, 8, 120);
    }

    public ContainerStorageTerminal(ContainerType<?> type, int id, PlayerInventory inv, TileEntityStorageTerminal te) {
        super(type, id);
        this.te = te;
        this.pinv = inv;
        this.addStorageSlots();
    }

    public ContainerStorageTerminal(ContainerType<?> type, int id, PlayerInventory inv) {
        this(type, id, inv, null);
    }

    protected void addStorageSlots() {
        this.addStorageSlots(5, 8, 18);
    }

    public ContainerStorageTerminal(int id, PlayerInventory inv) {
        this(StorageMod.storageTerminal, id, inv);
        this.addPlayerSlots(inv, 8, 120);
    }

    protected void addPlayerSlots(PlayerInventory playerInventory, int x, int y) {
        int i;
        this.playerSlotsStart = this.field_75151_b.size() - 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j + i * 9 + 9, x + j * 18, y + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, x + i * 18, y + 58));
        }
    }

    public final void addStorageSlots(int lines, int x, int y) {
        this.storageSlotList.clear();
        this.lines = lines;
        for (int i = 0; i < lines; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new SlotStorage(this.te, i * 9 + j, x + j * 18, y + i * 18));
            }
        }
        this.scrollTo(0.0f);
    }

    protected final void addSlotToContainer(SlotStorage slotStorage) {
        this.storageSlotList.add(slotStorage);
    }

    public static String formatNumber(long number) {
        String slimResult;
        int width = 4;
        assert (number >= 0L);
        String numberString = Long.toString(number);
        int numberSize = numberString.length();
        if (numberSize <= width) {
            return numberString;
        }
        long base = number;
        double last = base * 1000L;
        int exponent = -1;
        String postFix = "";
        while (numberSize > width) {
            last = base;
            numberSize = Long.toString(base /= 1000L).length() + 1;
            postFix = String.valueOf(ENCODED_POSTFIXES[++exponent]);
        }
        String withPrecision = format.format(last / 1000.0) + postFix;
        String withoutPrecision = Long.toString(base) + postFix;
        String string = slimResult = withPrecision.length() <= width ? withPrecision : withoutPrecision;
        assert (slimResult.length() <= width);
        return slimResult;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.te == null || this.te.canInteractWith(playerIn);
    }

    public final void scrollTo(float p_148329_1_) {
        int i = (this.itemListClientSorted.size() + 9 - 1) / 9 - this.lines;
        int j = (int)((double)(p_148329_1_ * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < this.lines; ++k) {
            for (int l = 0; l < 9; ++l) {
                int i1 = l + (k + j) * 9;
                if (i1 >= 0 && i1 < this.itemListClientSorted.size()) {
                    this.setSlotContents(l + k * 9, this.itemListClientSorted.get(i1));
                    continue;
                }
                this.setSlotContents(l + k * 9, null);
            }
        }
    }

    public final void setSlotContents(int id, StoredItemStack stack) {
        this.storageSlotList.get((int)id).stack = stack;
    }

    public int drawSlots(MatrixStack st, GuiStorageTerminalBase gui, int mouseX, int mouseY) {
        int i;
        for (i = 0; i < this.storageSlotList.size(); ++i) {
            this.storageSlotList.get(i).drawSlot(st, gui, mouseX, mouseY);
        }
        RenderSystem.disableLighting();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        st.func_227860_a_();
        st.func_227861_a_(0.0, 0.0, 100.0);
        for (i = 0; i < this.storageSlotList.size(); ++i) {
            if (!this.storageSlotList.get(i).drawTooltip(st, gui, mouseX, mouseY)) continue;
            st.func_227865_b_();
            return i;
        }
        st.func_227865_b_();
        return -1;
    }

    public final SlotStorage getSlotByID(int id) {
        return this.storageSlotList.get(id);
    }

    public void func_75142_b() {
        if (this.te == null) {
            return;
        }
        Map<StoredItemStack, Long> itemsCount = this.te.getStacks();
        if (!this.itemsCount.equals(itemsCount)) {
            ListNBT list = new ListNBT();
            CompoundNBT mainTag = new CompoundNBT();
            this.itemList.clear();
            for (Map.Entry<StoredItemStack, Long> e : itemsCount.entrySet()) {
                StoredItemStack storedS = e.getKey();
                CompoundNBT tag = new CompoundNBT();
                storedS.writeToNBT(tag, e.getValue());
                list.add((Object)tag);
                this.itemList.add(new StoredItemStack(e.getKey().getStack(), e.getValue()));
            }
            mainTag.func_218657_a("l", (INBT)list);
            mainTag.func_74768_a("p", this.te.getSorting());
            mainTag.func_74778_a("s", this.te.getLastSearch());
            NetworkHandler.sendTo((ServerPlayerEntity)this.pinv.field_70458_d, mainTag);
            this.itemsCount = new HashMap<StoredItemStack, Long>(itemsCount);
        }
        super.func_75142_b();
    }

    public final void receiveClientNBTPacket(CompoundNBT message) {
        ListNBT list = message.func_150295_c("l", 10);
        this.itemList.clear();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tag = list.func_150305_b(i);
            this.itemList.add(StoredItemStack.readFromNBT(tag));
        }
        this.itemListClient = new ArrayList<StoredItemStack>(this.itemList);
        this.pinv.func_70296_d();
        this.terminalData = message.func_74762_e("p");
        this.search = message.func_74779_i("s");
        if (this.onPacket != null) {
            this.onPacket.run();
        }
    }

    public final ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (this.field_75151_b.size() > index) {
            if (index > this.playerSlotsStart && this.te != null) {
                if (this.field_75151_b.get(index) != null && ((Slot)this.field_75151_b.get(index)).func_75216_d()) {
                    Slot slot = (Slot)this.field_75151_b.get(index);
                    ItemStack slotStack = slot.func_75211_c();
                    StoredItemStack c = this.te.pushStack(new StoredItemStack(slotStack, slotStack.func_190916_E()));
                    ItemStack itemstack = c != null ? c.getActualStack() : ItemStack.field_190927_a;
                    slot.func_75215_d(itemstack);
                    if (!playerIn.field_70170_p.field_72995_K) {
                        this.func_75142_b();
                    }
                }
            } else {
                return this.shiftClickItems(playerIn, index);
            }
        }
        return ItemStack.field_190927_a;
    }

    protected ItemStack shiftClickItems(PlayerEntity playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    public static boolean areItemStacksEqual(ItemStack stack, ItemStack matchTo, boolean checkNBT) {
        if (stack.func_190926_b() && matchTo.func_190926_b()) {
            return false;
        }
        if (!stack.func_190926_b() && !matchTo.func_190926_b() && stack.func_77973_b() == matchTo.func_77973_b()) {
            boolean equals = true;
            if (checkNBT) {
                equals = equals && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)matchTo);
            }
            return equals;
        }
        return false;
    }

    public void func_201771_a(RecipeItemHelper itemHelperIn) {
    }

    public void func_201768_e() {
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        return false;
    }

    public int func_201767_f() {
        return 0;
    }

    public int func_201770_g() {
        return 0;
    }

    public int func_201772_h() {
        return 0;
    }

    public int func_203721_h() {
        return 0;
    }

    public void sendMessage(CompoundNBT compound) {
        NetworkHandler.sendDataToServer(compound);
    }

    @Override
    public void receive(CompoundNBT message) {
        if (this.pinv.field_70458_d.func_175149_v()) {
            return;
        }
        if (message.func_74764_b("s")) {
            this.te.setLastSearch(message.func_74779_i("s"));
        }
        if (message.func_74764_b("a")) {
            ServerPlayerEntity player = (ServerPlayerEntity)this.pinv.field_70458_d;
            player.func_143004_u();
            CompoundNBT d = message.func_74775_l("a");
            ItemStack clicked = ItemStack.func_199557_a((CompoundNBT)d.func_74775_l("s"));
            SlotAction act = SlotAction.VALUES[Math.abs(d.func_74762_e("a")) % SlotAction.VALUES.length];
            if (act == SlotAction.SPACE_CLICK) {
                for (int i = this.playerSlotsStart + 1; i < this.playerSlotsStart + 28; ++i) {
                    this.func_82846_b((PlayerEntity)player, i);
                }
            } else if (act == SlotAction.PULL_OR_PUSH_STACK) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                if (!stack.func_190926_b()) {
                    StoredItemStack rem = this.te.pushStack(new StoredItemStack(stack));
                    ItemStack itemstack = rem == null ? ItemStack.field_190927_a : rem.getActualStack();
                    player.field_71071_by.func_70437_b(itemstack);
                } else {
                    if (clicked.func_190926_b()) {
                        return;
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), clicked.func_77976_d());
                    if (pulled != null) {
                        player.field_71071_by.func_70437_b(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.PULL_ONE) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                if (clicked.func_190926_b()) {
                    return;
                }
                if (d.func_74767_n("m")) {
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), 1L);
                    if (pulled != null) {
                        ItemStack itemstack = pulled.getActualStack();
                        this.func_75135_a(itemstack, this.playerSlotsStart + 1, this.field_75151_b.size(), true);
                        if (itemstack.func_190916_E() > 0) {
                            this.te.pushOrDrop(itemstack);
                        }
                        player.field_71071_by.func_70296_d();
                    }
                } else if (!stack.func_190926_b()) {
                    StoredItemStack pulled;
                    if (ContainerStorageTerminal.areItemStacksEqual(stack, clicked, true) && stack.func_190916_E() + 1 <= stack.func_77976_d() && (pulled = this.te.pullStack(new StoredItemStack(clicked), 1L)) != null) {
                        stack.func_190917_f(1);
                    }
                } else {
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), 1L);
                    if (pulled != null) {
                        player.field_71071_by.func_70437_b(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_HALF) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                if (!stack.func_190926_b()) {
                    ItemStack stack1 = stack.func_77979_a(Math.max(Math.min(stack.func_190916_E(), stack.func_77976_d()) / 2, 1));
                    ItemStack itemstack = this.te.pushStack(stack1);
                    stack.func_190917_f(!itemstack.func_190926_b() ? itemstack.func_190916_E() : 0);
                    player.field_71071_by.func_70437_b(stack);
                } else {
                    if (clicked.func_190926_b()) {
                        return;
                    }
                    long maxCount = 64L;
                    StoredItemStack clickedSt = new StoredItemStack(clicked);
                    for (int i = 0; i < this.itemList.size(); ++i) {
                        StoredItemStack e = this.itemList.get(i);
                        if (!e.equals((Object)clickedSt)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), Math.max(Math.min(maxCount, (long)clicked.func_77976_d()) / 2L, 1L));
                    if (pulled != null) {
                        player.field_71071_by.func_70437_b(pulled.getActualStack());
                    }
                }
            } else if (act == SlotAction.GET_QUARTER) {
                ItemStack stack = player.field_71071_by.func_70445_o();
                if (!stack.func_190926_b()) {
                    ItemStack stack1 = stack.func_77979_a(Math.max(Math.min(stack.func_190916_E(), stack.func_77976_d()) / 4, 1));
                    ItemStack itemstack = this.te.pushStack(stack1);
                    stack.func_190917_f(!itemstack.func_190926_b() ? itemstack.func_190916_E() : 0);
                    player.field_71071_by.func_70437_b(stack);
                } else {
                    if (clicked.func_190926_b()) {
                        return;
                    }
                    long maxCount = 64L;
                    StoredItemStack clickedSt = new StoredItemStack(clicked);
                    for (int i = 0; i < this.itemList.size(); ++i) {
                        StoredItemStack e = this.itemList.get(i);
                        if (!e.equals((Object)clickedSt)) continue;
                        maxCount = e.getQuantity();
                    }
                    StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), Math.max(Math.min(maxCount, (long)clicked.func_77976_d()) / 4L, 1L));
                    if (pulled != null) {
                        player.field_71071_by.func_70437_b(pulled.getActualStack());
                    }
                }
            } else {
                if (clicked.func_190926_b()) {
                    return;
                }
                StoredItemStack pulled = this.te.pullStack(new StoredItemStack(clicked), clicked.func_77976_d());
                if (pulled != null) {
                    ItemStack itemstack = pulled.getActualStack();
                    this.func_75135_a(itemstack, this.playerSlotsStart + 1, this.field_75151_b.size(), true);
                    if (itemstack.func_190916_E() > 0) {
                        this.te.pushOrDrop(itemstack);
                    }
                    player.field_71071_by.func_70296_d();
                }
            }
            player.func_71113_k();
        }
        if (message.func_74764_b("c")) {
            CompoundNBT d = message.func_74775_l("c");
            this.te.setSorting(d.func_74762_e("d"));
        }
    }

    public RecipeBookCategory func_241850_m() {
        return RecipeBookCategory.CRAFTING;
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format_ = new DecimalFormat(".#;0.#");
        format_.setDecimalFormatSymbols(symbols);
        format_.setRoundingMode(RoundingMode.DOWN);
        format = format_;
    }

    public static enum SlotAction {
        PULL_OR_PUSH_STACK,
        PULL_ONE,
        SPACE_CLICK,
        SHIFT_PULL,
        GET_HALF,
        GET_QUARTER;

        public static final SlotAction[] VALUES;

        static {
            VALUES = SlotAction.values();
        }
    }

    public static class SlotStorage {
        public int xDisplayPosition;
        public int yDisplayPosition;
        private final int slotIndex;
        public final TileEntityStorageTerminal inventory;
        public StoredItemStack stack;

        public SlotStorage(TileEntityStorageTerminal inventory, int slotIndex, int xPosition, int yPosition) {
            this.xDisplayPosition = xPosition;
            this.yDisplayPosition = yPosition;
            this.slotIndex = slotIndex;
            this.inventory = inventory;
        }

        public ItemStack pullFromSlot(long max) {
            if (this.stack == null || max < 1L || this.inventory == null) {
                return ItemStack.field_190927_a;
            }
            StoredItemStack r = this.inventory.pullStack(this.stack, max);
            if (r != null) {
                return r.getActualStack();
            }
            return ItemStack.field_190927_a;
        }

        public ItemStack pushStack(ItemStack pushStack) {
            if (this.inventory == null) {
                return pushStack;
            }
            StoredItemStack r = this.inventory.pushStack(new StoredItemStack(pushStack, pushStack.func_190916_E()));
            if (r != null) {
                return r.getActualStack();
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotIndex() {
            return this.slotIndex;
        }

        public void drawSlot(MatrixStack st, GuiStorageTerminalBase gui, int mouseX, int mouseY) {
            if (mouseX >= gui.getGuiLeft() + this.xDisplayPosition - 1 && mouseY >= gui.getGuiTop() + this.yDisplayPosition - 1 && mouseX < gui.getGuiLeft() + this.xDisplayPosition + 17 && mouseY < gui.getGuiTop() + this.yDisplayPosition + 17) {
                int l = gui.getGuiLeft() + this.xDisplayPosition;
                int t = gui.getGuiTop() + this.yDisplayPosition;
                GuiStorageTerminal.func_238467_a_((MatrixStack)st, (int)l, (int)t, (int)(l + 16), (int)(t + 16), (int)-2130706433);
            }
            if (this.stack != null) {
                st.func_227860_a_();
                gui.renderItemInGui(st, this.stack.getStack().func_77946_l().func_77979_a(1), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition, 0, 0, false, 0xFFFFFF, false, new String[0]);
                FontRenderer r = this.stack.getStack().func_77973_b().getFontRenderer(this.stack.getStack());
                if (r == null) {
                    r = gui.getFont();
                }
                this.drawStackSize(st, r, this.stack.getQuantity(), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition);
                st.func_227865_b_();
            }
        }

        public boolean drawTooltip(MatrixStack st, GuiStorageTerminalBase gui, int mouseX, int mouseY) {
            if (this.stack != null) {
                if (this.stack.getQuantity() > 9999L) {
                    gui.renderItemInGui(st, this.stack.getStack(), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition, mouseX, mouseY, false, 0, true, I18n.func_135052_a((String)"tooltip.toms_storage.amount", (Object[])new Object[]{this.stack.getQuantity()}));
                } else {
                    gui.renderItemInGui(st, this.stack.getStack(), gui.getGuiLeft() + this.xDisplayPosition, gui.getGuiTop() + this.yDisplayPosition, mouseX, mouseY, false, 0, true, new String[0]);
                }
            }
            return mouseX >= gui.getGuiLeft() + this.xDisplayPosition - 1 && mouseY >= gui.getGuiTop() + this.yDisplayPosition - 1 && mouseX < gui.getGuiLeft() + this.xDisplayPosition + 17 && mouseY < gui.getGuiTop() + this.yDisplayPosition + 17;
        }

        private void drawStackSize(MatrixStack st, FontRenderer fr, long size, int x, int y) {
            float scaleFactor = 0.6f;
            RenderSystem.disableLighting();
            RenderSystem.disableDepthTest();
            RenderSystem.disableBlend();
            String stackSize = ContainerStorageTerminal.formatNumber(size);
            st.func_227860_a_();
            st.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
            st.func_227861_a_(0.0, 0.0, 450.0);
            float inverseScaleFactor = 1.0f / scaleFactor;
            int X = (int)(((float)x + 0.0f + 16.0f - (float)fr.func_78256_a(stackSize) * scaleFactor) * inverseScaleFactor);
            int Y = (int)(((float)y + 0.0f + 16.0f - 7.0f * scaleFactor) * inverseScaleFactor);
            fr.func_238405_a_(st, stackSize, (float)X, (float)Y, 0xFFFFFF);
            st.func_227865_b_();
            RenderSystem.enableLighting();
            RenderSystem.enableDepthTest();
        }
    }
}

