/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.gui.ControllMode;
import com.tom.storagemod.gui.GuiCraftingTerminal;
import com.tom.storagemod.jei.JEIHandler;
import com.tom.storagemod.network.IDataReceiver;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;
import org.lwjgl.glfw.GLFW;

public abstract class GuiStorageTerminalBase<T extends ContainerStorageTerminal>
extends ContainerScreen<T>
implements IDataReceiver {
    private static final LoadingCache<StoredItemStack, List<String>> tooltipCache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<StoredItemStack, List<String>>(){

        public List<String> load(StoredItemStack key) throws Exception {
            return key.getStack().func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, GuiStorageTerminalBase.getTooltipFlag()).stream().map(ITextComponent::getString).collect(Collectors.toList());
        }
    });
    protected Minecraft mc = Minecraft.func_71410_x();
    protected float currentScroll;
    protected boolean isScrolling;
    private boolean refreshItemList;
    protected boolean wasClicking;
    protected TextFieldWidget searchField;
    protected int slotIDUnderMouse = -1;
    protected int controllMode;
    protected int rowCount;
    protected int searchType;
    private String searchLast = "";
    protected boolean loadedSearch = false;
    private StoredItemStack.IStoredItemStackComparator comparator = new StoredItemStack.ComparatorAmount(false);
    protected static final ResourceLocation creativeInventoryTabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    protected GuiButton buttonSortingType;
    protected GuiButton buttonDirection;
    protected GuiButton buttonSearchType;
    protected GuiButton buttonCtrlMode;

    public GuiStorageTerminalBase(T screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super(screenContainer, inv, titleIn);
        ((ContainerStorageTerminal)screenContainer).onPacket = this::onPacket;
    }

    protected void onPacket() {
        int s = ((ContainerStorageTerminal)this.field_147002_h).terminalData;
        this.controllMode = (s & 3) % ControllMode.VALUES.length;
        boolean rev = (s & 4) > 0;
        int type = (s & 0x18) >> 3;
        this.comparator = StoredItemStack.SortingTypes.VALUES[type % StoredItemStack.SortingTypes.VALUES.length].create(rev);
        this.searchType = (s & 0xE0) >> 5;
        this.searchField.func_146205_d((this.searchType & 1) == 0);
        if (!this.searchField.func_230999_j_() && (this.searchType & 1) > 0) {
            this.searchField.func_146195_b(true);
        }
        this.buttonSortingType.state = type;
        this.buttonDirection.state = rev ? 1 : 0;
        this.buttonSearchType.state = this.searchType;
        this.buttonCtrlMode.state = this.controllMode;
        if (!this.loadedSearch && ((ContainerStorageTerminal)this.field_147002_h).search != null) {
            this.loadedSearch = true;
            if ((this.searchType & 2) > 0) {
                this.searchField.func_146180_a(((ContainerStorageTerminal)this.field_147002_h).search);
            }
        }
    }

    protected void sendUpdate() {
        CompoundNBT c = new CompoundNBT();
        c.func_74768_a("d", this.updateData());
        CompoundNBT msg = new CompoundNBT();
        msg.func_218657_a("c", (INBT)c);
        ((ContainerStorageTerminal)this.field_147002_h).sendMessage(msg);
    }

    protected int updateData() {
        int d = 0;
        d |= this.controllMode & 3;
        d |= (this.comparator.isReversed() ? 1 : 0) << 2;
        d |= this.comparator.type() << 3;
        return d |= (this.searchType & 7) << 5;
    }

    protected void func_231160_c_() {
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.field_238745_s_ = this.field_147000_g - 92;
        super.func_231160_c_();
        FontRenderer fontRenderer = this.getFont();
        this.getFont().getClass();
        this.searchField = new TextFieldWidget(fontRenderer, this.field_147003_i + 82, this.field_147009_r + 6, 89, 9, (ITextComponent)new TranslationTextComponent("narrator.toms_storage.terminal_search"));
        this.searchField.func_146203_f(100);
        this.searchField.func_146185_a(false);
        this.searchField.func_146189_e(true);
        this.searchField.func_146193_g(0xFFFFFF);
        this.field_230710_m_.add(this.searchField);
        this.buttonSortingType = (GuiButton)this.func_230480_a_((Widget)new GuiButton(this.field_147003_i - 18, this.field_147009_r + 5, 0, b -> {
            this.comparator = StoredItemStack.SortingTypes.VALUES[(this.comparator.type() + 1) % StoredItemStack.SortingTypes.VALUES.length].create(this.comparator.isReversed());
            this.buttonSortingType.state = this.comparator.type();
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonDirection = (GuiButton)this.func_230480_a_((Widget)new GuiButton(this.field_147003_i - 18, this.field_147009_r + 5 + 18, 1, b -> {
            this.comparator.setReversed(!this.comparator.isReversed());
            this.buttonDirection.state = this.comparator.isReversed() ? 1 : 0;
            this.sendUpdate();
            this.refreshItemList = true;
        }));
        this.buttonSearchType = (GuiButton)this.func_230480_a_((Widget)new GuiButton(this.field_147003_i - 18, this.field_147009_r + 5 + 36, 2, b -> {
            this.buttonSearchType.state = this.searchType = this.searchType + 1 & (ModList.get().isLoaded("jei") || this instanceof GuiCraftingTerminal ? 7 : 3);
            this.sendUpdate();
        }){

            @Override
            public void func_230431_b_(MatrixStack st, int mouseX, int mouseY, float pt) {
                if (this.field_230694_p_) {
                    GuiStorageTerminalBase.this.mc.func_110434_K().func_110577_a(GuiStorageTerminalBase.this.getGui());
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    this.func_238474_b_(st, this.field_230690_l_, this.field_230691_m_, this.texX, this.texY + this.tile * 16, this.field_230688_j_, this.field_230689_k_);
                    if ((this.state & 1) > 0) {
                        this.func_238474_b_(st, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.texX + 16, this.texY + this.tile * 16, this.field_230688_j_ - 2, this.field_230689_k_ - 2);
                    }
                    if ((this.state & 2) > 0) {
                        this.func_238474_b_(st, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.texX + 16 + 14, this.texY + this.tile * 16, this.field_230688_j_ - 2, this.field_230689_k_ - 2);
                    }
                    if ((this.state & 4) > 0) {
                        this.func_238474_b_(st, this.field_230690_l_ + 1, this.field_230691_m_ + 1, this.texX + 16 + 28, this.texY + this.tile * 16, this.field_230688_j_ - 2, this.field_230689_k_ - 2);
                    }
                }
            }
        });
        this.buttonCtrlMode = (GuiButton)this.func_230480_a_((Widget)new GuiButton(this.field_147003_i - 18, this.field_147009_r + 5 + 54, 3, b -> {
            this.buttonCtrlMode.state = this.controllMode = (this.controllMode + 1) % ControllMode.VALUES.length;
            this.sendUpdate();
        }));
        this.updateSearch();
    }

    protected void updateSearch() {
        String searchString = this.searchField.func_146179_b();
        if (this.refreshItemList || !this.searchLast.equals(searchString)) {
            ((ContainerStorageTerminal)this.func_212873_a_()).itemListClientSorted.clear();
            boolean searchMod = false;
            if (searchString.startsWith("@")) {
                searchMod = true;
                searchString = searchString.substring(1);
            }
            Pattern m = null;
            try {
                m = Pattern.compile(searchString.toLowerCase(), 2);
            }
            catch (Throwable ignore) {
                try {
                    m = Pattern.compile(Pattern.quote(searchString.toLowerCase()), 2);
                }
                catch (Throwable __) {
                    return;
                }
            }
            boolean notDone = false;
            try {
                block6: for (int i = 0; i < ((ContainerStorageTerminal)this.func_212873_a_()).itemListClient.size(); ++i) {
                    StoredItemStack is = ((ContainerStorageTerminal)this.func_212873_a_()).itemListClient.get(i);
                    if (is == null || is.getStack() == null) continue;
                    String dspName = searchMod ? is.getStack().func_77973_b().delegate.name().func_110624_b() : is.getStack().func_200301_q().getString();
                    notDone = true;
                    if (m.matcher(dspName.toLowerCase()).find()) {
                        this.addStackToClientList(is);
                        notDone = false;
                    }
                    if (!notDone) continue;
                    for (String lp : (List)tooltipCache.get((Object)is)) {
                        if (!m.matcher(lp).find()) continue;
                        this.addStackToClientList(is);
                        notDone = false;
                        continue block6;
                    }
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            Collections.sort(((ContainerStorageTerminal)this.func_212873_a_()).itemListClientSorted, this.comparator);
            if (!this.searchLast.equals(searchString)) {
                ((ContainerStorageTerminal)this.func_212873_a_()).scrollTo(0.0f);
                this.currentScroll = 0.0f;
                if ((this.searchType & 4) > 0 && ModList.get().isLoaded("jei")) {
                    JEIHandler.setJeiSearchText(searchString);
                }
                if ((this.searchType & 2) > 0) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74778_a("s", searchString);
                    ((ContainerStorageTerminal)this.field_147002_h).sendMessage(nbt);
                }
                this.onUpdateSearch(searchString);
            } else {
                ((ContainerStorageTerminal)this.func_212873_a_()).scrollTo(this.currentScroll);
            }
            this.refreshItemList = false;
            this.searchLast = searchString;
        }
    }

    private void addStackToClientList(StoredItemStack is) {
        ((ContainerStorageTerminal)this.func_212873_a_()).itemListClientSorted.add(is);
    }

    public static ITooltipFlag getTooltipFlag() {
        return Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.updateSearch();
    }

    public void func_230430_a_(MatrixStack st, int mouseX, int mouseY, float partialTicks) {
        boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)0) != 0;
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        int k = i + 174;
        int l = j + 18;
        int i1 = k + 14;
        int j1 = l + this.rowCount * 18;
        if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!flag) {
            this.isScrolling = false;
        }
        this.wasClicking = flag;
        if (this.isScrolling) {
            this.currentScroll = ((float)(mouseY - l) - 7.5f) / ((float)(j1 - l) - 15.0f);
            this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
            ((ContainerStorageTerminal)this.func_212873_a_()).scrollTo(this.currentScroll);
        }
        super.func_230430_a_(st, mouseX, mouseY, partialTicks);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        this.field_230706_i_.field_71446_o.func_110577_a(creativeInventoryTabs);
        i = k;
        j = l;
        k = j1;
        this.func_238474_b_(st, i, j + (int)((float)(k - j - 17) * this.currentScroll), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        st.func_227860_a_();
        RenderHelper.func_227780_a_();
        this.slotIDUnderMouse = ((ContainerStorageTerminal)this.func_212873_a_()).drawSlots(st, this, mouseX, mouseY);
        st.func_227865_b_();
        this.func_230459_a_(st, mouseX, mouseY);
        if (this.buttonSortingType.func_230449_g_()) {
            this.func_238652_a_(st, (ITextComponent)new TranslationTextComponent("tooltip.toms_storage.sorting_" + this.buttonSortingType.state), mouseX, mouseY);
        }
        if (this.buttonSearchType.func_230449_g_()) {
            this.func_238652_a_(st, (ITextComponent)new TranslationTextComponent("tooltip.toms_storage.search_" + this.buttonSearchType.state), mouseX, mouseY);
        }
        if (this.buttonCtrlMode.func_230449_g_()) {
            this.func_243308_b(st, Arrays.stream(I18n.func_135052_a((String)("tooltip.toms_storage.ctrlMode_" + this.buttonCtrlMode.state), (Object[])new Object[0]).split("\\\\")).map(StringTextComponent::new).collect(Collectors.toList()), mouseX, mouseY);
        }
    }

    protected boolean needsScrollBars() {
        return ((ContainerStorageTerminal)this.func_212873_a_()).itemListClientSorted.size() > this.rowCount * 9;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        block15: {
            block14: {
                block12: {
                    block11: {
                        block13: {
                            if (this.slotIDUnderMouse <= -1) break block11;
                            if (this.isPullOne(mouseButton)) break block12;
                            if (!this.pullHalf(mouseButton)) break block13;
                            if (!this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                                this.storageSlotClick(ItemStack.field_190927_a, GuiStorageTerminalBase.func_231172_r_() ? ContainerStorageTerminal.SlotAction.GET_QUARTER : ContainerStorageTerminal.SlotAction.GET_HALF, 0);
                                return true;
                            }
                            break block14;
                        }
                        if (!this.pullNormal(mouseButton)) return true;
                        if (!this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
                            this.storageSlotClick(ItemStack.field_190927_a, ContainerStorageTerminal.SlotAction.PULL_OR_PUSH_STACK, 0);
                            return true;
                        }
                        break block15;
                    }
                    if (GLFW.glfwGetKey((long)this.mc.func_228018_at_().func_198092_i(), (int)32) != 0) {
                        this.storageSlotClick(ItemStack.field_190927_a, ContainerStorageTerminal.SlotAction.SPACE_CLICK, 0);
                        return true;
                    }
                    if (mouseButton == 1) {
                        int n = this.searchField.field_230690_l_ - this.field_147003_i;
                        int n2 = this.searchField.field_230691_m_ - this.field_147009_r;
                        this.getFont().getClass();
                        if (this.func_195359_a(n, n2, 89, 9, mouseX, mouseY)) {
                            this.searchField.func_146180_a("");
                            return true;
                        }
                    }
                    if (!this.searchField.func_231044_a_(mouseX, mouseY, mouseButton)) return super.func_231044_a_(mouseX, mouseY, mouseButton);
                    return true;
                }
                if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
                if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
                int i = 0;
                while (i < ((ContainerStorageTerminal)this.func_212873_a_()).itemList.size()) {
                    if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.func_212873_a_()).itemList.get(i))) {
                        this.storageSlotClick(((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), ContainerStorageTerminal.SlotAction.PULL_ONE, this.isTransferOne(mouseButton) ? 1 : 0);
                        return true;
                    }
                    ++i;
                }
                return true;
            }
            if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
            if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
            int i = 0;
            while (i < ((ContainerStorageTerminal)this.func_212873_a_()).itemList.size()) {
                if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.func_212873_a_()).itemList.get(i))) {
                    this.storageSlotClick(((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), GuiStorageTerminalBase.func_231172_r_() ? ContainerStorageTerminal.SlotAction.GET_QUARTER : ContainerStorageTerminal.SlotAction.GET_HALF, 0);
                    return true;
                }
                ++i;
            }
            return true;
        }
        if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack == null) return true;
        if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.getQuantity() <= 0L) return true;
        int i = 0;
        while (i < ((ContainerStorageTerminal)this.func_212873_a_()).itemList.size()) {
            if (((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.equals(((ContainerStorageTerminal)this.func_212873_a_()).itemList.get(i))) {
                this.storageSlotClick(((ContainerStorageTerminal)this.func_212873_a_()).getSlotByID((int)this.slotIDUnderMouse).stack.getStack(), GuiStorageTerminalBase.func_231173_s_() ? ContainerStorageTerminal.SlotAction.SHIFT_PULL : ContainerStorageTerminal.SlotAction.PULL_OR_PUSH_STACK, 0);
                return true;
            }
            ++i;
        }
        return true;
    }

    protected void storageSlotClick(ItemStack slotStack, ContainerStorageTerminal.SlotAction act, int mod) {
        CompoundNBT c = new CompoundNBT();
        c.func_218657_a("s", (INBT)slotStack.func_77955_b(new CompoundNBT()));
        c.func_74768_a("a", act.ordinal());
        c.func_74774_a("m", (byte)mod);
        CompoundNBT msg = new CompoundNBT();
        msg.func_218657_a("a", (INBT)c);
        ((ContainerStorageTerminal)this.field_147002_h).sendMessage(msg);
    }

    public boolean isPullOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1 && GuiStorageTerminalBase.func_231173_s_();
            }
            case RS: {
                return mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && !this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
            }
        }
        return false;
    }

    public boolean isTransferOne(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return GuiStorageTerminalBase.func_231173_s_() && GuiStorageTerminalBase.func_231172_r_();
            }
            case RS: {
                return GuiStorageTerminalBase.func_231173_s_() && mouseButton == 2;
            }
            case DEF: {
                return mouseButton == 1 && GuiStorageTerminalBase.func_231173_s_();
            }
        }
        return false;
    }

    public boolean pullHalf(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: {
                return mouseButton == 1;
            }
            case RS: {
                return mouseButton == 1;
            }
            case DEF: {
                return mouseButton == 1 && this.mc.field_71439_g.field_71071_by.func_70445_o().func_190926_b();
            }
        }
        return false;
    }

    public boolean pullNormal(int mouseButton) {
        switch (this.ctrlm()) {
            case AE: 
            case RS: 
            case DEF: {
                return mouseButton == 0;
            }
        }
        return false;
    }

    private ControllMode ctrlm() {
        return ControllMode.VALUES[this.controllMode];
    }

    public final void renderItemInGui(MatrixStack st, ItemStack stack, int x, int y, int mouseX, int mouseY, boolean hasBg, int color, boolean tooltip, String ... extraInfo) {
        if (stack != null) {
            if (!tooltip) {
                if (hasBg) {
                    GuiStorageTerminalBase.func_238467_a_((MatrixStack)st, (int)x, (int)y, (int)16, (int)16, (int)(color | Integer.MIN_VALUE));
                }
                st.func_227861_a_(0.0, 0.0, 32.0);
                FontRenderer font = null;
                if (stack != null) {
                    font = stack.func_77973_b().getFontRenderer(stack);
                }
                if (font == null) {
                    font = this.getFont();
                }
                RenderSystem.enableDepthTest();
                this.field_230707_j_.func_180450_b(stack, x, y);
                this.field_230707_j_.func_180453_a(font, stack, x, y, null);
            } else if (mouseX >= x - 1 && mouseY >= y - 1 && mouseX < x + 17 && mouseY < y + 17) {
                int i;
                List list = this.func_231151_a_(stack);
                if (extraInfo != null && extraInfo.length > 0) {
                    for (i = 0; i < extraInfo.length; ++i) {
                        list.add(new StringTextComponent(extraInfo[i]));
                    }
                }
                for (i = 0; i < list.size(); ++i) {
                    IFormattableTextComponent t2;
                    ITextComponent t = (ITextComponent)list.get(i);
                    IFormattableTextComponent iFormattableTextComponent = t2 = t instanceof IFormattableTextComponent ? (IFormattableTextComponent)t : t.func_230532_e_();
                    if (i == 0) {
                        list.set(i, t2.func_240699_a_(stack.func_77953_t().field_77937_e));
                        continue;
                    }
                    list.set(i, t2.func_240699_a_(TextFormatting.GRAY));
                }
                this.func_243308_b(st, list, mouseX, mouseY);
            }
        }
    }

    public FontRenderer getFont() {
        return this.field_230712_o_;
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (p_keyPressed_1_ == 256) {
            this.func_231175_as__();
            return true;
        }
        return !this.searchField.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) && !this.searchField.func_212955_f() ? super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_) : true;
    }

    public boolean func_231042_a_(char p_charTyped_1_, int p_charTyped_2_) {
        if (this.searchField.func_231042_a_(p_charTyped_1_, p_charTyped_2_)) {
            return true;
        }
        return super.func_231042_a_(p_charTyped_1_, p_charTyped_2_);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        if (!this.needsScrollBars()) {
            return false;
        }
        int i = (((ContainerStorageTerminal)this.field_147002_h).itemListClientSorted.size() + 9 - 1) / 9 - 5;
        this.currentScroll = (float)((double)this.currentScroll - p_mouseScrolled_5_ / (double)i);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((ContainerStorageTerminal)this.field_147002_h).scrollTo(this.currentScroll);
        return true;
    }

    public abstract ResourceLocation getGui();

    protected void func_230450_a_(MatrixStack st, float partialTicks, int mouseX, int mouseY) {
        this.mc.field_71446_o.func_110577_a(this.getGui());
        this.func_238474_b_(st, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void onUpdateSearch(String text) {
    }

    @Override
    public void receive(CompoundNBT tag) {
        ((ContainerStorageTerminal)this.field_147002_h).receiveClientNBTPacket(tag);
        this.refreshItemList = true;
    }

    public class GuiButton
    extends Button {
        protected int tile;
        protected int state;
        protected int texX;
        protected int texY;

        public GuiButton(int x, int y, int tile, Button.IPressable pressable) {
            super(x, y, 16, 16, null, pressable);
            this.texX = 194;
            this.texY = 30;
            this.tile = tile;
        }

        public void setX(int i) {
            this.field_230690_l_ = i;
        }

        public void func_230431_b_(MatrixStack st, int mouseX, int mouseY, float pt) {
            if (this.field_230694_p_) {
                GuiStorageTerminalBase.this.mc.func_110434_K().func_110577_a(GuiStorageTerminalBase.this.getGui());
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                this.func_238474_b_(st, this.field_230690_l_, this.field_230691_m_, this.texX + this.state * 16, this.texY + this.tile * 16, this.field_230688_j_, this.field_230689_k_);
            }
        }
    }
}

