/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.item;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StorageTags;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.proxy.ClientProxy;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ItemAdvWirelessTerminal
extends Item
implements WirelessTerminal {
    public ItemAdvWirelessTerminal() {
        super(new Item.Properties().func_200916_a(StorageMod.STORAGE_MOD_TAB).func_200917_a(1));
        this.setRegistryName("ts.adv_wireless_terminal");
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        ClientProxy.tooltip("adv_wireless_terminal", tooltip, Config.advWirelessRange);
        if (Config.wirelessTermBeaconLvl != -1) {
            ClientProxy.tooltip("adv_wireless_terminal.beacon1", false, tooltip, Config.wirelessTermBeaconLvl);
            if (Config.wirelessTermBeaconLvlDim != -1) {
                ClientProxy.tooltip("adv_wireless_terminal.beacon2", false, tooltip, Config.wirelessTermBeaconLvlDim);
            }
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BindX")) {
            int x = stack.func_77978_p().func_74762_e("BindX");
            int y = stack.func_77978_p().func_74762_e("BindY");
            int z = stack.func_77978_p().func_74762_e("BindZ");
            String dim = stack.func_77978_p().func_74779_i("BindDim");
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.adv_wireless_terminal.bound", new Object[]{x, y, z, dim}));
        }
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.toms_storage.adv_wireless_terminal.keybind", new Object[]{new TranslationTextComponent("tooltip.toms_storage.adv_wireless_terminal.keybind.outline", new Object[]{new KeybindTextComponent("key.toms_storage.open_terminal").func_240699_a_(TextFormatting.GREEN)})}));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return this.activateTerminal(worldIn, stack, playerIn, handIn);
    }

    public ActionResult<ItemStack> activateTerminal(World worldIn, ItemStack stack, PlayerEntity playerIn, Hand handIn) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("BindX")) {
            if (!worldIn.field_72995_K) {
                int x = stack.func_77978_p().func_74762_e("BindX");
                int y = stack.func_77978_p().func_74762_e("BindY");
                int z = stack.func_77978_p().func_74762_e("BindZ");
                String dim = stack.func_77978_p().func_74779_i("BindDim");
                ServerWorld termWorld = worldIn.func_73046_m().func_71218_a(RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dim)));
                if (termWorld.func_195588_v(new BlockPos(x, y, z))) {
                    BlockRayTraceResult lookingAt = new BlockRayTraceResult(new Vector3d((double)x, (double)y, (double)z), Direction.UP, new BlockPos(x, y, z), true);
                    BlockState state = termWorld.func_180495_p(lookingAt.func_216350_a());
                    if (StorageTags.REMOTE_ACTIVATE.func_230235_a_((Object)state.func_177230_c())) {
                        ActionResultType r = state.func_227031_a_((World)termWorld, playerIn, handIn, lookingAt);
                        return new ActionResult(r, (Object)playerIn.func_184586_b(handIn));
                    }
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("chat.toms_storage.terminal_invalid_block"), true);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("chat.toms_storage.terminal_out_of_range"), true);
                }
            } else {
                return ActionResult.func_226249_b_((Object)playerIn.func_184586_b(handIn));
            }
        }
        return ActionResult.func_226250_c_((Object)playerIn.func_184586_b(handIn));
    }

    public ActionResultType func_195939_a(ItemUseContext c) {
        if (c.func_225518_g_() && !c.func_195991_k().field_72995_K) {
            BlockPos pos = c.func_195995_a();
            BlockState state = c.func_195991_k().func_180495_p(pos);
            if (StorageTags.REMOTE_ACTIVATE.func_230235_a_((Object)state.func_177230_c())) {
                ItemStack stack = c.func_195996_i();
                if (!stack.func_77942_o()) {
                    stack.func_77982_d(new CompoundNBT());
                }
                stack.func_77978_p().func_74768_a("BindX", pos.func_177958_n());
                stack.func_77978_p().func_74768_a("BindY", pos.func_177956_o());
                stack.func_77978_p().func_74768_a("BindZ", pos.func_177952_p());
                stack.func_77978_p().func_74778_a("BindDim", c.func_195991_k().func_234923_W_().func_240901_a_().toString());
                if (c.func_195999_j() != null) {
                    c.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("chat.toms_storage.terminal_bound"), true);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Override
    public int getRange(PlayerEntity pl, ItemStack stack) {
        return Config.advWirelessRange;
    }

    @Override
    public void open(PlayerEntity sender, ItemStack t) {
        this.activateTerminal(sender.field_70170_p, t, sender, Hand.MAIN_HAND);
    }

    @Override
    public boolean canOpen(ItemStack t) {
        return true;
    }
}

