/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.network;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.network.DataPacket;
import com.tom.storagemod.network.IDataReceiver;
import com.tom.storagemod.network.OpenTerminalPacket;
import com.tom.storagemod.util.PlayerInvUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("toms_storage", "main"), () -> "1", "1"::equals, "1"::equals);

    public static void init() {
        INSTANCE.registerMessage(0, DataPacket.class, DataPacket::toBytes, DataPacket::new, NetworkHandler::handleData);
        INSTANCE.registerMessage(1, OpenTerminalPacket.class, (a, b) -> {}, b -> new OpenTerminalPacket(), NetworkHandler::handleData);
        StorageMod.LOGGER.info("Initilaized Network Handler");
    }

    public static void handleData(DataPacket packet, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_SERVER) {
            ctx.get().enqueueWork(() -> {
                ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
                if (sender.field_71070_bA instanceof IDataReceiver) {
                    ((IDataReceiver)sender.field_71070_bA).receive(packet.tag);
                }
            });
        } else if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> {
                if (Minecraft.func_71410_x().field_71462_r instanceof IDataReceiver) {
                    ((IDataReceiver)Minecraft.func_71410_x().field_71462_r).receive(packet.tag);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static void handleData(OpenTerminalPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity sender = ((NetworkEvent.Context)ctx.get()).getSender();
            ItemStack t = PlayerInvUtil.findItem((PlayerEntity)sender, i -> i.func_77973_b() instanceof WirelessTerminal && ((WirelessTerminal)i.func_77973_b()).canOpen((ItemStack)i), ItemStack.field_190927_a, Function.identity());
            if (!t.func_190926_b()) {
                ((WirelessTerminal)t.func_77973_b()).open((PlayerEntity)sender, t);
            }
        });
    }

    public static void sendDataToServer(CompoundNBT tag) {
        INSTANCE.sendToServer((Object)new DataPacket(tag));
    }

    public static void sendTo(ServerPlayerEntity pl, CompoundNBT tag) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> pl), (Object)new DataPacket(tag));
    }

    public static void openTerminal() {
        INSTANCE.sendToServer((Object)new OpenTerminalPacket());
    }
}

