/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.gui.ContainerCraftingTerminal;
import com.tom.storagemod.tile.TileEntityStorageTerminal;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityCraftingTerminal
extends TileEntityStorageTerminal {
    private Container craftingContainer = new Container(ContainerType.field_221518_l, 0){

        public boolean func_75145_c(PlayerEntity player) {
            return false;
        }

        public void func_75130_a(IInventory inventory) {
            if (TileEntityCraftingTerminal.this.field_145850_b != null && !((TileEntityCraftingTerminal)TileEntityCraftingTerminal.this).field_145850_b.field_72995_K) {
                TileEntityCraftingTerminal.this.onCraftingMatrixChanged();
            }
        }
    };
    private ICraftingRecipe currentRecipe;
    private final CraftingInventory craftMatrix = new CraftingInventory(this.craftingContainer, 3, 3);
    private CraftResultInventory craftResult = new CraftResultInventory();
    private HashSet<ContainerCraftingTerminal> craftingListeners = new HashSet();
    private boolean reading;

    public TileEntityCraftingTerminal() {
        super(StorageMod.craftingTerminalTile);
    }

    @Override
    public Container createMenu(int id, PlayerInventory plInv, PlayerEntity arg2) {
        return new ContainerCraftingTerminal(id, plInv, this);
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("ts.crafting_terminal");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack itemstack = this.craftMatrix.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.func_218657_a("CraftingTable", (INBT)listnbt);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState st, CompoundNBT compound) {
        super.func_230337_a_(st, compound);
        this.reading = true;
        ListNBT listnbt = compound.func_150295_c("CraftingTable", 10);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundNBT compoundnbt = listnbt.func_150305_b(i);
            int j = compoundnbt.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.craftMatrix.func_70302_i_()) continue;
            this.craftMatrix.func_70299_a(j, ItemStack.func_199557_a((CompoundNBT)compoundnbt));
        }
        this.reading = false;
    }

    public CraftingInventory getCraftingInv() {
        return this.craftMatrix;
    }

    public CraftResultInventory getCraftResult() {
        return this.craftResult;
    }

    public void craftShift(PlayerEntity player) {
        ArrayList<ItemStack> craftedItemsList = new ArrayList<ItemStack>();
        int amountCrafted = 0;
        ItemStack crafted = this.craftResult.func_70301_a(0);
        do {
            this.craft(player);
            craftedItemsList.add(crafted.func_77946_l());
        } while (ItemStack.func_179545_c((ItemStack)crafted, (ItemStack)this.craftResult.func_70301_a(0)) && (amountCrafted += crafted.func_190916_E()) + crafted.func_190916_E() < crafted.func_77976_d());
        for (ItemStack craftedItem : craftedItemsList) {
            ItemStack is;
            if (player.field_71071_by.func_70441_a(craftedItem.func_77946_l()) || (is = this.pushStack(craftedItem)).func_190926_b()) continue;
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)player.func_226277_ct_(), (double)player.func_226278_cu_(), (double)player.func_226281_cx_(), (ItemStack)is);
        }
        crafted.func_77980_a(player.field_70170_p, player, amountCrafted);
        BasicEventHooks.firePlayerCraftingEvent((PlayerEntity)player, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)crafted, (int)amountCrafted), (IInventory)this.craftMatrix);
    }

    public void craft(PlayerEntity thePlayer) {
        if (this.currentRecipe != null) {
            NonNullList remainder = this.currentRecipe.func_179532_b((IInventory)this.craftMatrix);
            boolean playerInvUpdate = false;
            for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
                StoredItemStack is;
                ItemStack slot = this.craftMatrix.func_70301_a(i);
                if (i < remainder.size() && !((ItemStack)remainder.get(i)).func_190926_b()) {
                    if (!slot.func_190926_b() && slot.func_190916_E() > 1) {
                        is = this.pushStack(((ItemStack)remainder.get(i)).func_77946_l());
                        if (!is.func_190926_b() && !thePlayer.field_71071_by.func_70441_a((ItemStack)is)) {
                            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)thePlayer.func_226277_ct_(), (double)thePlayer.func_226278_cu_(), (double)thePlayer.func_226281_cx_(), (ItemStack)is);
                        }
                        this.craftMatrix.func_70298_a(i, 1);
                        continue;
                    }
                    this.craftMatrix.func_70299_a(i, ((ItemStack)remainder.get(i)).func_77946_l());
                    continue;
                }
                if (slot.func_190926_b()) continue;
                if (slot.func_190916_E() == 1) {
                    is = this.pullStack(new StoredItemStack(slot), 1L);
                    if (is == null && (this.getSorting() & 0x100) != 0) {
                        for (int j = 0; j < thePlayer.field_71071_by.func_70302_i_(); ++j) {
                            ItemStack st = thePlayer.field_71071_by.func_70301_a(j);
                            if (!ItemStack.func_179545_c((ItemStack)slot, (ItemStack)st) || !ItemStack.func_77970_a((ItemStack)slot, (ItemStack)st) || (st = thePlayer.field_71071_by.func_70298_a(j, 1)).func_190926_b()) continue;
                            is = new StoredItemStack(st, 1L);
                            playerInvUpdate = true;
                            break;
                        }
                    }
                    if (is == null) {
                        this.craftMatrix.func_70299_a(i, ItemStack.field_190927_a);
                        continue;
                    }
                    this.craftMatrix.func_70299_a(i, is.getActualStack());
                    continue;
                }
                this.craftMatrix.func_70298_a(i, 1);
            }
            if (playerInvUpdate) {
                thePlayer.field_71070_bA.func_75142_b();
            }
            this.onCraftingMatrixChanged();
        }
    }

    public void unregisterCrafting(ContainerCraftingTerminal containerCraftingTerminal) {
        this.craftingListeners.remove(containerCraftingTerminal);
    }

    public void registerCrafting(ContainerCraftingTerminal containerCraftingTerminal) {
        this.craftingListeners.add(containerCraftingTerminal);
    }

    protected void onCraftingMatrixChanged() {
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a((IInventory)this.craftMatrix, this.field_145850_b)) {
            this.currentRecipe = this.field_145850_b.func_199532_z().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, this.field_145850_b).orElse(null);
        }
        if (this.currentRecipe == null) {
            this.craftResult.func_70299_a(0, ItemStack.field_190927_a);
        } else {
            this.craftResult.func_70299_a(0, this.currentRecipe.func_77572_b((IInventory)this.craftMatrix));
        }
        this.craftingListeners.forEach(ContainerCraftingTerminal::onCraftMatrixChanged);
        if (!this.reading) {
            this.func_70296_d();
        }
    }

    public void clear() {
        for (int i = 0; i < this.craftMatrix.func_70302_i_(); ++i) {
            ItemStack st = this.craftMatrix.func_70304_b(i);
            if (st.func_190926_b()) continue;
            this.pushOrDrop(st);
        }
        this.onCraftingMatrixChanged();
    }

    public void handlerItemTransfer(PlayerEntity player, ItemStack[][] items) {
        this.clear();
        for (int i = 0; i < 9; ++i) {
            int j;
            if (items[i] == null) continue;
            ItemStack stack = ItemStack.field_190927_a;
            for (j = 0; j < items[i].length; ++j) {
                ItemStack pulled = this.pullStack(items[i][j]);
                if (pulled.func_190926_b()) continue;
                stack = pulled;
                break;
            }
            if (stack.func_190926_b()) {
                for (j = 0; j < items[i].length; ++j) {
                    boolean br = false;
                    for (int k = 0; k < player.field_71071_by.func_70302_i_(); ++k) {
                        if (!ItemStack.func_179545_c((ItemStack)player.field_71071_by.func_70301_a(k), (ItemStack)items[i][j])) continue;
                        stack = player.field_71071_by.func_70298_a(k, 1);
                        br = true;
                        break;
                    }
                    if (br) break;
                }
            }
            if (stack.func_190926_b()) continue;
            this.craftMatrix.func_70299_a(i, stack);
        }
        this.onCraftingMatrixChanged();
    }

    private ItemStack pullStack(ItemStack itemStack) {
        StoredItemStack is = this.pullStack(new StoredItemStack(itemStack), 1L);
        if (is == null) {
            return ItemStack.field_190927_a;
        }
        return is.getActualStack();
    }
}

