/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.BlockInventoryCableConnector;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.tile.IProxy;
import com.tom.storagemod.tile.TileEntityInventoryConnector;
import java.util.HashSet;
import java.util.Stack;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryCableConnectorBase
extends TileEntity
implements ITickableTileEntity {
    protected TileEntityInventoryConnector master;
    protected LazyOptional<IItemHandler> invHandler;
    protected LazyOptional<IItemHandler> pointedAt;
    protected TileEntityInventoryConnector.LinkedInv linv;

    public TileEntityInventoryCableConnectorBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 19L) {
            TileEntity te;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            Direction facing = (Direction)state.func_177229_b((Property)BlockInventoryCableConnector.FACING);
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            checkedBlocks.add(this.field_174879_c);
            toCheck.addAll(((IInventoryCable)state.func_177230_c()).next(this.field_145850_b, state, this.field_174879_c));
            if (this.master != null) {
                this.master.unLink(this.linv);
            }
            this.master = null;
            this.linv = new TileEntityInventoryConnector.LinkedInv();
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                if (checkedBlocks.contains(cp)) continue;
                checkedBlocks.add(cp);
                if (this.field_145850_b.func_175667_e(cp)) {
                    state = this.field_145850_b.func_180495_p(cp);
                    if (state.func_177230_c() == StorageMod.connector) {
                        TileEntity te2 = this.field_145850_b.func_175625_s(cp);
                        if (!(te2 instanceof TileEntityInventoryConnector)) break;
                        this.master = (TileEntityInventoryConnector)te2;
                        this.linv.time = this.field_145850_b.func_82737_E();
                        this.linv.handler = this::applyFilter;
                        this.master.addLinked(this.linv);
                        break;
                    }
                    if (state.func_177230_c() instanceof IInventoryCable) {
                        toCheck.addAll(((IInventoryCable)state.func_177230_c()).next(this.field_145850_b, state, cp));
                    }
                }
                if (checkedBlocks.size() <= Config.invConnectorMax) continue;
                break;
            }
            if (!(this.pointedAt != null && this.pointedAt.isPresent() || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing))) == null)) {
                this.pointedAt = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            }
        }
    }

    protected LazyOptional<IItemHandler> applyFilter() {
        return this.pointedAt == null ? LazyOptional.empty() : this.pointedAt;
    }

    protected LazyOptional<IItemHandler> getCapability() {
        return LazyOptional.of(() -> new InvHandler());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.invHandler == null) {
                this.invHandler = this.getCapability();
            }
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    private class InvHandler
    implements IItemHandler,
    IProxy {
        private boolean calling;

        private InvHandler() {
        }

        public <R> R call(Function<IItemHandler, R> func, R def) {
            if (this.calling) {
                return def;
            }
            this.calling = true;
            if (TileEntityInventoryCableConnectorBase.this.master != null && !TileEntityInventoryCableConnectorBase.this.master.func_145837_r()) {
                R r = func.apply((IItemHandler)TileEntityInventoryCableConnectorBase.this.master.getInventory().orElse((Object)EmptyHandler.INSTANCE));
                this.calling = false;
                return r;
            }
            this.calling = false;
            return def;
        }

        public int getSlots() {
            return this.call(IItemHandler::getSlots, 0);
        }

        public ItemStack getStackInSlot(int slot) {
            return this.call(i -> i.getStackInSlot(slot), ItemStack.field_190927_a);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return this.call(i -> i.insertItem(slot, stack, simulate), stack);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.call(i -> i.extractItem(slot, amount, simulate), ItemStack.field_190927_a);
        }

        public int getSlotLimit(int slot) {
            return this.call(i -> i.getSlotLimit(slot), 0);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return this.call(i -> i.isItemValid(slot, stack), false);
        }

        @Override
        public IItemHandler get() {
            if (TileEntityInventoryCableConnectorBase.this.master != null && !TileEntityInventoryCableConnectorBase.this.master.func_145837_r()) {
                return (IItemHandler)TileEntityInventoryCableConnectorBase.this.master.getInventory().orElse(null);
            }
            return null;
        }
    }
}

