/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.block.ITrim;
import com.tom.storagemod.tile.IProxy;
import com.tom.storagemod.tile.InfoHandler;
import com.tom.storagemod.tile.TileEntityInventoryCableConnector;
import com.tom.storagemod.tile.TileEntityInventoryProxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileEntityInventoryConnector
extends TileEntity
implements ITickableTileEntity {
    private List<LazyOptional<IItemHandler>> handlers = new ArrayList<LazyOptional<IItemHandler>>();
    private List<LinkedInv> linkedInvs = new ArrayList<LinkedInv>();
    private LazyOptional<IItemHandler> invHandler;
    private int[] invSizes = new int[0];
    private int invSize;

    public TileEntityInventoryConnector() {
        super(StorageMod.connectorTile);
    }

    public void func_73660_a() {
        long time = this.field_145850_b.func_82737_E();
        if (!this.field_145850_b.field_72995_K && time % 20L == 0L) {
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            toCheck.add(this.field_174879_c);
            checkedBlocks.add(this.field_174879_c);
            this.handlers.clear();
            HashSet<LinkedInv> toRM = new HashSet<LinkedInv>();
            for (LinkedInv linkedInv : this.linkedInvs) {
                if (linkedInv.time + 40L < time) {
                    toRM.add(linkedInv);
                    continue;
                }
                this.handlers.add(linkedInv.handler.get());
            }
            this.linkedInvs.removeAll(toRM);
            Collections.sort(this.linkedInvs);
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                for (Direction d : Direction.values()) {
                    ChestType type;
                    Block block;
                    BlockPos p = cp.func_177972_a(d);
                    if (checkedBlocks.contains(p) || !(p.func_177951_i((Vector3i)this.field_174879_c) < (double)Config.invRange)) continue;
                    checkedBlocks.add(p);
                    BlockState state = this.field_145850_b.func_180495_p(p);
                    if (state.func_177230_c() instanceof ITrim) {
                        toCheck.add(p);
                        continue;
                    }
                    TileEntity te = this.field_145850_b.func_175625_s(p);
                    if (te instanceof TileEntityInventoryConnector || te instanceof TileEntityInventoryProxy || te instanceof TileEntityInventoryCableConnector || te == null || Config.onlyTrims) continue;
                    LazyOptional inv = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d());
                    if (te instanceof ChestTileEntity && (block = state.func_177230_c()) instanceof ChestBlock && (type = (ChestType)state.func_177229_b((Property)ChestBlock.field_196314_b)) != ChestType.SINGLE) {
                        ChestType otype;
                        BlockPos opos = p.func_177972_a(ChestBlock.func_196311_i((BlockState)state));
                        BlockState ostate = this.func_145831_w().func_180495_p(opos);
                        if (state.func_177230_c() == ostate.func_177230_c() && (otype = (ChestType)ostate.func_177229_b((Property)ChestBlock.field_196314_b)) != ChestType.SINGLE && type != otype && state.func_177229_b((Property)ChestBlock.field_176459_a) == ostate.func_177229_b((Property)ChestBlock.field_176459_a)) {
                            toCheck.add(opos);
                            checkedBlocks.add(opos);
                        }
                    }
                    if (inv.isPresent()) {
                        InvHandler ih;
                        IItemHandler ihr = IProxy.resolve((IItemHandler)inv.orElse(null));
                        if (ihr instanceof InvHandler && this.checkHandlers(ih = (InvHandler)ihr, 0)) {
                            if (this.handlers.contains(InfoHandler.INSTANCE)) continue;
                            this.handlers.add(InfoHandler.INSTANCE);
                            continue;
                        }
                        toCheck.add(p);
                        this.handlers.add((LazyOptional<IItemHandler>)inv);
                    }
                    if (!Config.multiblockInvs.contains(state.func_177230_c())) continue;
                    this.skipBlocks(p, checkedBlocks, toCheck, state.func_177230_c());
                }
            }
            if (this.invSizes.length != this.handlers.size()) {
                this.invSizes = new int[this.handlers.size()];
            }
            this.invSize = 0;
            for (int i = 0; i < this.invSizes.length; ++i) {
                int s;
                IItemHandler iItemHandler = (IItemHandler)this.handlers.get(i).orElse(null);
                if (iItemHandler == null) {
                    this.invSizes[i] = 0;
                    continue;
                }
                this.invSizes[i] = s = iItemHandler.getSlots();
                this.invSize += s;
            }
        }
    }

    private void skipBlocks(BlockPos pos, Set<BlockPos> checkedBlocks, Stack<BlockPos> edges, Block block) {
        Stack<BlockPos> toCheck = new Stack<BlockPos>();
        toCheck.add(pos);
        edges.add(pos);
        while (!toCheck.isEmpty()) {
            BlockPos cp = (BlockPos)toCheck.pop();
            for (Direction d : Direction.values()) {
                BlockState state;
                BlockPos p = cp.func_177972_a(d);
                if (checkedBlocks.contains(p) || !(p.func_177951_i((Vector3i)this.field_174879_c) < (double)Config.invRange) || (state = this.field_145850_b.func_180495_p(p)).func_177230_c() != block) continue;
                checkedBlocks.add(p);
                edges.add(p);
                toCheck.add(p);
            }
        }
    }

    private boolean checkHandlers(InvHandler ih, int depth) {
        if (depth > 3) {
            return true;
        }
        for (LazyOptional<IItemHandler> lo : ih.getHandlers()) {
            IItemHandler ihr = IProxy.resolve((IItemHandler)lo.orElse(null));
            if (!(ihr instanceof InvHandler) || !this.checkHandlers((InvHandler)ihr, depth + 1)) continue;
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventory().cast();
        }
        return super.getCapability(cap, side);
    }

    public LazyOptional<IItemHandler> getInventory() {
        if (this.invHandler == null) {
            this.invHandler = LazyOptional.of(() -> new InvHandler());
        }
        return this.invHandler;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void addLinked(LinkedInv inv) {
        this.linkedInvs.add(inv);
    }

    public void unLink(LinkedInv linv) {
        this.linkedInvs.remove(linv);
    }

    public int getFreeSlotCount() {
        return (Integer)this.getInventory().lazyMap(inv -> {
            int empty = 0;
            for (int i = 0; i < this.invSize; ++i) {
                if (!inv.getStackInSlot(i).func_190926_b()) continue;
                ++empty;
            }
            return empty;
        }).orElse((Object)0);
    }

    public int getInvSize() {
        return this.invSize;
    }

    public static class LinkedInv
    implements Comparable<LinkedInv> {
        public Supplier<LazyOptional<IItemHandler>> handler;
        public long time;
        public int priority;

        @Override
        public int compareTo(LinkedInv o) {
            return Integer.compare(this.priority, o.priority);
        }
    }

    private class InvHandler
    implements IItemHandler {
        private boolean calling;

        private InvHandler() {
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (this.calling) {
                return false;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                boolean r = ((IItemHandler)((LazyOptional)TileEntityInventoryConnector.this.handlers.get(i)).orElse((Object)EmptyHandler.INSTANCE)).isItemValid(slot, stack);
                this.calling = false;
                return r;
            }
            this.calling = false;
            return false;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (this.calling) {
                return stack;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                ItemStack s = ((IItemHandler)((LazyOptional)TileEntityInventoryConnector.this.handlers.get(i)).orElse((Object)EmptyHandler.INSTANCE)).insertItem(slot, stack, simulate);
                this.calling = false;
                return s;
            }
            this.calling = false;
            return stack;
        }

        public ItemStack getStackInSlot(int slot) {
            if (this.calling) {
                return ItemStack.field_190927_a;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                ItemStack s = ((IItemHandler)((LazyOptional)TileEntityInventoryConnector.this.handlers.get(i)).orElse((Object)EmptyHandler.INSTANCE)).getStackInSlot(slot);
                this.calling = false;
                return s;
            }
            this.calling = false;
            return ItemStack.field_190927_a;
        }

        public int getSlots() {
            return TileEntityInventoryConnector.this.invSize;
        }

        public int getSlotLimit(int slot) {
            if (this.calling) {
                return 0;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                int r = ((IItemHandler)((LazyOptional)TileEntityInventoryConnector.this.handlers.get(i)).orElse((Object)EmptyHandler.INSTANCE)).getSlotLimit(slot);
                this.calling = false;
                return r;
            }
            this.calling = false;
            return 0;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.calling) {
                return ItemStack.field_190927_a;
            }
            this.calling = true;
            for (int i = 0; i < TileEntityInventoryConnector.this.invSizes.length; ++i) {
                if (slot >= TileEntityInventoryConnector.this.invSizes[i]) {
                    slot -= TileEntityInventoryConnector.this.invSizes[i];
                    continue;
                }
                ItemStack s = ((IItemHandler)((LazyOptional)TileEntityInventoryConnector.this.handlers.get(i)).orElse((Object)EmptyHandler.INSTANCE)).extractItem(slot, amount, simulate);
                this.calling = false;
                return s;
            }
            this.calling = false;
            return ItemStack.field_190927_a;
        }

        public List<LazyOptional<IItemHandler>> getHandlers() {
            return TileEntityInventoryConnector.this.handlers;
        }
    }
}

