/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Config;
import com.tom.storagemod.StorageMod;
import com.tom.storagemod.StoredItemStack;
import com.tom.storagemod.block.StorageTerminalBase;
import com.tom.storagemod.gui.ContainerStorageTerminal;
import com.tom.storagemod.item.WirelessTerminal;
import com.tom.storagemod.util.PlayerInvUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityStorageTerminal
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity {
    private IItemHandler itemHandler;
    private Map<StoredItemStack, Long> items = new HashMap<StoredItemStack, Long>();
    private int sort;
    private String lastSearch = "";
    private boolean updateItems;
    private int beaconLevel;

    public TileEntityStorageTerminal() {
        super(StorageMod.terminalTile);
    }

    public TileEntityStorageTerminal(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public Container createMenu(int id, PlayerInventory plInv, PlayerEntity arg2) {
        return new ContainerStorageTerminal(id, plInv, this);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("ts.storage_terminal");
    }

    public Map<StoredItemStack, Long> getStacks() {
        this.updateItems = true;
        return this.items;
    }

    public StoredItemStack pullStack(StoredItemStack stack, long max) {
        if (stack != null && this.itemHandler != null && max > 0L) {
            ItemStack st = stack.getStack();
            StoredItemStack ret = null;
            for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                ItemStack pulled;
                ItemStack s = this.itemHandler.getStackInSlot(i);
                if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)st) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)st) || (pulled = this.itemHandler.extractItem(i, (int)max, false)).func_190926_b()) continue;
                if (ret == null) {
                    ret = new StoredItemStack(pulled);
                } else {
                    ret.grow(pulled.func_190916_E());
                }
                if ((max -= (long)pulled.func_190916_E()) < 1L) break;
            }
            return ret;
        }
        return null;
    }

    public StoredItemStack pushStack(StoredItemStack stack) {
        if (stack != null && this.itemHandler != null) {
            ItemStack is = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)stack.getActualStack(), (boolean)false);
            if (is.func_190926_b()) {
                return null;
            }
            return new StoredItemStack(is);
        }
        return stack;
    }

    public ItemStack pushStack(ItemStack itemstack) {
        StoredItemStack is = this.pushStack(new StoredItemStack(itemstack));
        return is == null ? ItemStack.field_190927_a : is.getActualStack();
    }

    public void pushOrDrop(ItemStack st) {
        if (st.func_190926_b()) {
            return;
        }
        StoredItemStack st0 = this.pushStack(new StoredItemStack(st));
        if (st0 != null) {
            InventoryHelper.func_180173_a((World)this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + 0.5f), (double)((float)this.field_174879_c.func_177956_o() + 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.5f), (ItemStack)st0.getActualStack());
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateItems) {
                BlockState st = this.field_145850_b.func_180495_p(this.field_174879_c);
                Direction d = (Direction)st.func_177229_b((Property)StorageTerminalBase.FACING);
                StorageTerminalBase.TerminalPos p2 = (StorageTerminalBase.TerminalPos)((Object)st.func_177229_b(StorageTerminalBase.TERMINAL_POS));
                if (p2 == StorageTerminalBase.TerminalPos.UP) {
                    d = Direction.UP;
                }
                if (p2 == StorageTerminalBase.TerminalPos.DOWN) {
                    d = Direction.DOWN;
                }
                TileEntity invTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
                this.items.clear();
                if (invTile != null) {
                    LazyOptional lih = invTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, d.func_176734_d());
                    this.itemHandler = (IItemHandler)lih.orElse(null);
                    if (this.itemHandler != null) {
                        IntStream.range(0, this.itemHandler.getSlots()).mapToObj(arg_0 -> ((IItemHandler)this.itemHandler).getStackInSlot(arg_0)).filter(s -> !s.func_190926_b()).map(StoredItemStack::new).forEach(s -> this.items.merge((StoredItemStack)s, s.getQuantity(), (a, b) -> a + b));
                    }
                }
                this.updateItems = false;
            }
            if (this.field_145850_b.func_82737_E() % 40L == 5L) {
                this.beaconLevel = BlockPos.func_239581_a_((AxisAlignedBB)new AxisAlignedBB(this.field_174879_c).func_186662_g(8.0)).mapToInt(p -> {
                    BlockState st;
                    if (this.field_145850_b.func_195588_v(p) && (st = this.field_145850_b.func_180495_p(p)).func_203425_a(Blocks.field_150461_bJ)) {
                        return this.calcBeaconLevel(p.func_177958_n(), p.func_177956_o(), p.func_177952_p());
                    }
                    return 0;
                }).max().orElse(0);
            }
        }
    }

    public boolean canInteractWith(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        int termReach = PlayerInvUtil.findItem(player, i -> i.func_77973_b() instanceof WirelessTerminal, 0, i -> ((WirelessTerminal)i.func_77973_b()).getRange(player, (ItemStack)i));
        if (Config.wirelessTermBeaconLvl != -1 && this.beaconLevel >= Config.wirelessTermBeaconLvl && termReach > 0) {
            if (Config.wirelessTermBeaconLvlDim != -1 && this.beaconLevel >= Config.wirelessTermBeaconLvlDim) {
                return true;
            }
            return player.field_70170_p == this.field_145850_b;
        }
        int d = Math.max(termReach, 4);
        return player.field_70170_p == this.field_145850_b && !(player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) > (double)(d * 2 * d * 2));
    }

    public int getSorting() {
        return this.sort;
    }

    public void setSorting(int newC) {
        this.sort = newC;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("sort", this.sort);
        return super.func_189515_b(compound);
    }

    public void func_230337_a_(BlockState st, CompoundNBT compound) {
        this.sort = compound.func_74762_e("sort");
        super.func_230337_a_(st, compound);
    }

    public String getLastSearch() {
        return this.lastSearch;
    }

    public void setLastSearch(String string) {
        this.lastSearch = string;
    }

    private int calcBeaconLevel(int x, int y, int z) {
        int i = 0;
        TileEntity ent = this.field_145850_b.func_175625_s(new BlockPos(x, y, z));
        if (ent instanceof BeaconTileEntity) {
            int k;
            BeaconTileEntity b = (BeaconTileEntity)ent;
            if (b.func_191979_s() == 0) {
                return 0;
            }
            int j = 1;
            while (j <= 4 && (k = y - j) >= 0) {
                boolean flag = true;
                block1: for (int l = x - j; l <= x + j && flag; ++l) {
                    for (int i1 = z - j; i1 <= z + j; ++i1) {
                        if (this.field_145850_b.func_180495_p(new BlockPos(l, k, i1)).func_235714_a_((ITag)BlockTags.field_232875_ap_)) continue;
                        flag = false;
                        continue block1;
                    }
                }
                if (!flag) break;
                i = j++;
            }
        }
        return i;
    }
}

