/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental;

import alexthw.ars_elemental.ArsElemental;
import alexthw.ars_elemental.HellFireEffect;
import alexthw.ars_elemental.bag.CurioHolder;
import alexthw.ars_elemental.bag.CurioHolderContainer;
import alexthw.ars_elemental.entity.AllyVhexEntity;
import alexthw.ars_elemental.entity.EntityArcProjectile;
import alexthw.ars_elemental.entity.EntityHomingProjectile;
import alexthw.ars_elemental.entity.SummonDirewolf;
import alexthw.ars_elemental.entity.SummonSkeleHorse;
import alexthw.ars_elemental.item.ElementalFocus;
import alexthw.ars_elemental.item.NecroticFocus;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"ars_elemental");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"ars_elemental");
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"ars_elemental");
    public static final DeferredRegister<Effect> EFFECTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POTIONS, (String)"ars_elemental");
    public static final RegistryObject<EntityType<SummonSkeleHorse>> SKELEHORSE_SUMMON;
    public static final RegistryObject<EntityType<SummonDirewolf>> DIREWOLF_SUMMON;
    public static final RegistryObject<EntityType<AllyVhexEntity>> VHEX_SUMMON;
    public static final RegistryObject<EntityType<EntityHomingProjectile>> HOMING_PROJECTILE;
    public static final RegistryObject<EntityType<EntityArcProjectile>> ARC_PROJECTILE;
    public static final RegistryObject<Effect> HELLFIRE;
    public static final RegistryObject<Item> CURIO_BAG;
    public static final RegistryObject<Item> FIRE_FOCUS;
    public static final RegistryObject<Item> AIR_FOCUS;
    public static final RegistryObject<Item> WATER_FOCUS;
    public static final RegistryObject<Item> EARTH_FOCUS;
    public static final RegistryObject<Item> NECRO_FOCUS;
    public static final RegistryObject<ContainerType<CurioHolderContainer>> CURIO_POUCH;

    public static Item.Properties addTabProps() {
        return new Item.Properties().func_200916_a(ArsElemental.TAB);
    }

    static <T extends Entity> RegistryObject<EntityType<T>> registerEntity(String name, float width, float height, EntityType.IFactory<T> factory, EntityClassification kind) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)kind).func_233606_a_(10).setTrackingRange(64).setUpdateInterval(1).func_220321_a(width, height).func_206830_a("ars_elemental:" + name);
        return ENTITIES.register(name, () -> type);
    }

    static <T extends Entity> RegistryObject<EntityType<T>> registerProjectile(String name, EntityType.IFactory<T> factory) {
        EntityType type = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.MISC).func_200706_c().func_233606_a_(10).setTrackingRange(64).setUpdateInterval(1).func_220321_a(0.5f, 0.5f).func_206830_a("ars_elemental:" + name);
        return ENTITIES.register(name, () -> type);
    }

    public static void registerRegistries(IEventBus bus) {
        ITEMS.register(bus);
        ENTITIES.register(bus);
        CONTAINERS.register(bus);
        EFFECTS.register(bus);
    }

    static {
        HELLFIRE = EFFECTS.register("hellfire", HellFireEffect::new);
        FIRE_FOCUS = ITEMS.register("fire_focus", () -> new ElementalFocus(ModRegistry.addTabProps(), SpellSchools.ELEMENTAL_FIRE));
        WATER_FOCUS = ITEMS.register("water_focus", () -> new ElementalFocus(ModRegistry.addTabProps(), SpellSchools.ELEMENTAL_WATER));
        AIR_FOCUS = ITEMS.register("air_focus", () -> new ElementalFocus(ModRegistry.addTabProps(), SpellSchools.ELEMENTAL_AIR));
        EARTH_FOCUS = ITEMS.register("earth_focus", () -> new ElementalFocus(ModRegistry.addTabProps(), SpellSchools.ELEMENTAL_EARTH));
        NECRO_FOCUS = ITEMS.register("necrotic_focus", () -> new NecroticFocus(ModRegistry.addTabProps()));
        CURIO_BAG = ITEMS.register("curio_bag", () -> new CurioHolder(ModRegistry.addTabProps().func_200917_a(1)));
        HOMING_PROJECTILE = ModRegistry.registerProjectile("homing_projectile", EntityHomingProjectile::new);
        ARC_PROJECTILE = ModRegistry.registerProjectile("arc_projectile", EntityArcProjectile::new);
        SKELEHORSE_SUMMON = ENTITIES.register("summon_skelehorse", () -> EntityType.Builder.func_220322_a(SummonSkeleHorse::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f).setTrackingRange(10).func_206830_a("ars_elemental:summon_skelehorse"));
        DIREWOLF_SUMMON = ModRegistry.registerEntity("summon_direwolf", 0.6f, 0.85f, SummonDirewolf::new, EntityClassification.CREATURE);
        VHEX_SUMMON = ModRegistry.registerEntity("summon_vhex", 0.4f, 0.8f, AllyVhexEntity::new, EntityClassification.MONSTER);
        CURIO_POUCH = CONTAINERS.register("curio_bag", () -> IForgeContainerType.create((id, inv, extraData) -> new CurioHolderContainer(id, inv, extraData.func_150791_c())));
    }
}

