/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.entity;

import alexthw.ars_elemental.ModRegistry;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.client.particle.GlowParticleData;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.setup.BlockRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class EntityHomingProjectile
extends EntityProjectileSpell {
    LivingEntity target;
    List<Predicate<LivingEntity>> ignore;

    public EntityHomingProjectile(World world, SpellResolver resolver, List<Predicate<LivingEntity>> ignored) {
        this(world, resolver);
        this.ignore = ignored;
    }

    public EntityHomingProjectile(World world, SpellResolver resolver) {
        super(world, resolver);
    }

    public EntityHomingProjectile(EntityType<EntityHomingProjectile> entityType, World level) {
        super(entityType, level);
    }

    public EntityType<?> func_200600_R() {
        return (EntityType)ModRegistry.HOMING_PROJECTILE.get();
    }

    public void shoot(Entity entityThrower, float rotationPitchIn, float rotationYawIn, float pitchOffset, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)((rotationPitchIn + pitchOffset) * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(rotationYawIn * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(rotationPitchIn * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, 0.0f, inaccuracy);
        Vector3d vec3d = entityThrower.func_70040_Z();
        this.func_213317_d(this.func_213322_ci().func_72441_c(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c).func_186678_a((double)velocity));
    }

    public void func_70071_h_() {
        EntityRayTraceResult entityraytraceresult;
        Vector3d vector3d3;
        Vector3d vector3d2;
        BlockRayTraceResult raytraceresult;
        ++this.age;
        if (this.age > 600 || !this.field_70170_p.field_72995_K && this.spellResolver == null) {
            this.func_70106_y();
            return;
        }
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        if (this.field_70254_i) {
            this.field_70254_i = false;
            this.func_213317_d(this.func_213322_ci());
        }
        if ((raytraceresult = this.field_70170_p.func_217299_a(new RayTraceContext(vector3d2 = this.func_213303_ch(), vector3d3 = vector3d2.func_178787_e(this.func_213322_ci()), this.numSensitive > 0 ? RayTraceContext.BlockMode.OUTLINE : RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this))).func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d3 = raytraceresult.func_216347_e();
        }
        if ((entityraytraceresult = this.func_213866_a(vector3d2, vector3d3)) != null) {
            raytraceresult = entityraytraceresult;
        }
        if (raytraceresult instanceof EntityRayTraceResult) {
            Entity entity = ((EntityRayTraceResult)raytraceresult).func_216348_a();
            Entity entity1 = this.func_234616_v_();
            if (entity instanceof PlayerEntity && entity1 instanceof PlayerEntity && !((PlayerEntity)entity1).func_96122_a((PlayerEntity)entity)) {
                raytraceresult = null;
            }
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((AbstractArrowEntity)this, (RayTraceResult)raytraceresult)) {
            this.func_70227_a((RayTraceResult)raytraceresult);
            this.field_70160_al = true;
        }
        if (raytraceresult != null && raytraceresult.func_216346_c() == RayTraceResult.Type.MISS && raytraceresult instanceof BlockRayTraceResult) {
            BlockRegistry.PORTAL_BLOCK.func_220066_a(this.field_70170_p, this.field_70170_p.func_180495_p(new BlockPos(raytraceresult.func_216347_e())), raytraceresult, (ProjectileEntity)this);
        }
        this.tickNextPosition();
        if (this.field_70170_p.field_72995_K && this.age > 2) {
            for (int i = 0; i < 10; ++i) {
                double deltaX = this.func_226277_ct_() - this.field_70142_S;
                double deltaY = this.func_226278_cu_() - this.field_70137_T;
                double deltaZ = this.func_226281_cx_() - this.field_70136_U;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 8.0);
                for (double j = 0.0; j < dist; j += 1.0) {
                    double coeff = j / dist;
                    this.field_70170_p.func_195594_a(GlowParticleData.createData((ParticleColor)this.getParticleColor()), (double)((float)(this.field_70169_q + deltaX * coeff)), (double)((float)(this.field_70167_r + deltaY * coeff)), (double)((float)(this.field_70166_s + deltaZ * coeff)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)), (double)(0.0125f * (this.field_70146_Z.nextFloat() - 0.5f)));
                }
            }
        }
    }

    public void tickNextPosition() {
        if (this.func_70089_S()) {
            if (this.target != null && (!this.target.func_70089_S() || this.target.func_70068_e((Entity)this) > 50.0)) {
                this.target = null;
            }
            if (this.target == null && this.field_70173_aa % 5 == 0) {
                List entities = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(4.0), this::shouldTarget);
                if (entities.isEmpty() && this.target == null) {
                    this.oldTick();
                } else if (!entities.isEmpty()) {
                    this.target = entities.stream().filter(e -> e.func_70068_e((Entity)this) < 50.0).min(Comparator.comparingDouble(e -> e.func_70068_e((Entity)this))).orElse(this.target);
                }
            }
            if (this.target != null) {
                this.homeTo(this.target.func_233580_cy_());
            } else {
                this.oldTick();
            }
        }
    }

    private void oldTick() {
        Vector3d vec3d = this.func_213322_ci();
        double x = this.func_226277_ct_() + vec3d.field_72450_a;
        double y = this.func_226278_cu_() + vec3d.field_72448_b;
        double z = this.func_226281_cx_() + vec3d.field_72449_c;
        if (!this.func_189652_ae()) {
            Vector3d vec3d1 = this.func_213322_ci();
            this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c);
        }
        this.func_70107_b(x, y, z);
    }

    private void homeTo(BlockPos dest) {
        double posX = this.func_226277_ct_();
        double posY = this.func_226278_cu_();
        double posZ = this.func_226281_cx_();
        double motionX = this.func_213322_ci().field_72450_a;
        double motionY = this.func_213322_ci().field_72448_b;
        double motionZ = this.func_213322_ci().field_72449_c;
        if (dest.func_177958_n() != 0 || dest.func_177956_o() != 0 || dest.func_177952_p() != 0) {
            double targetX = (double)dest.func_177958_n() + 0.5;
            double targetY = (double)dest.func_177956_o() + 0.5;
            double targetZ = (double)dest.func_177952_p() + 0.5;
            Vector3d targetVector = new Vector3d(targetX - posX, targetY - posY, targetZ - posZ);
            double length = targetVector.func_72433_c();
            targetVector = targetVector.func_186678_a(0.3 / length);
            double weight = 0.0;
            if (length <= 3.0) {
                weight = (3.0 - length) * 0.3;
            }
            motionX = (0.9 - weight) * motionX + (0.1 + weight) * targetVector.field_72450_a;
            motionY = (0.9 - weight) * motionY + (0.1 + weight) * targetVector.field_72448_b;
            motionZ = (0.9 - weight) * motionZ + (0.1 + weight) * targetVector.field_72449_c;
        }
        this.func_70107_b(posX += motionX, posY += motionY, posZ += motionZ);
        this.func_213293_j(motionX, motionY, motionZ);
    }

    protected boolean func_230298_a_(Entity p_230298_1_) {
        if (p_230298_1_ instanceof LivingEntity) {
            return this.shouldTarget((LivingEntity)p_230298_1_) && super.func_230298_a_(p_230298_1_);
        }
        return super.func_230298_a_(p_230298_1_);
    }

    private boolean shouldTarget(LivingEntity e) {
        if (this.ignore != null && this.ignore.stream().anyMatch(p -> p.test(e))) {
            return false;
        }
        return e != this.func_234616_v_() && e.func_70089_S();
    }

    public boolean func_70039_c(CompoundNBT pCompound) {
        return super.func_70039_c(pCompound);
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
    }
}

