/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.glyphs;

import alexthw.ars_elemental.glyphs.GlyphEffectUtil;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractEffect;
import com.hollingsworth.arsnouveau.api.spell.AbstractSpellPart;
import com.hollingsworth.arsnouveau.api.spell.ISpellTier;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectCrush;
import com.hollingsworth.arsnouveau.common.spell.effect.EffectSmelt;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class ConjureTerrain
extends AbstractEffect {
    public static ConjureTerrain INSTANCE = new ConjureTerrain();

    public ConjureTerrain() {
        super("conjure_terrain", "Conjure Dirt");
    }

    public void onResolveBlock(BlockRayTraceResult rayTraceResult, World world, LivingEntity shooter, SpellStats spellStats, SpellContext spellContext) {
        BlockState toPlace = spellStats.hasBuff((AbstractAugment)AugmentAmplify.INSTANCE) ? Blocks.field_150347_e.func_176223_P() : Blocks.field_150346_d.func_176223_P();
        for (int i = spellContext.getCurrentIndex(); i < spellContext.getSpell().getSpellSize() && spellContext.getCurrentIndex() < spellContext.getSpell().getSpellSize(); ++i) {
            AbstractSpellPart next = spellContext.nextSpell();
            if (next instanceof AbstractAugment) continue;
            if (!(next instanceof AbstractEffect)) break;
            if (next == EffectCrush.INSTANCE) {
                toPlace = spellStats.hasBuff((AbstractAugment)AugmentAmplify.INSTANCE) ? Blocks.field_150322_A.func_176223_P() : Blocks.field_150354_m.func_176223_P();
                spellContext.setCanceled(true);
                break;
            }
            if (next != EffectSmelt.INSTANCE || !spellStats.hasBuff((AbstractAugment)AugmentAmplify.INSTANCE)) break;
            toPlace = Blocks.field_150348_b.func_176223_P();
            Spell spell = spellContext.getSpell();
            spell.setCost((int)((float)spell.getCastingCost() * 1.5f));
            spellContext.setCanceled(true);
            break;
        }
        GlyphEffectUtil.placeBlocks(rayTraceResult, world, shooter, spellStats, toPlace);
    }

    public int getManaCost() {
        return 10;
    }

    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentAOE.INSTANCE, AugmentPierce.INSTANCE});
    }

    protected Map<String, Integer> getDefaultAugmentLimits() {
        Map map = super.getDefaultAugmentLimits();
        map.put("amplify", 1);
        return map;
    }

    public String getBookDescription() {
        return "Places terrain block at a location. Can place more blocks if augmented with AoE or Pierce";
    }

    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH, SpellSchools.CONJURATION});
    }

    public ISpellTier.Tier getTier() {
        return ISpellTier.Tier.ONE;
    }

    public Item getCraftingReagent() {
        return Items.field_221582_j;
    }
}

