/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.glyphs;

import alexthw.ars_elemental.entity.EntityArcProjectile;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.AbstractCastMethod;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAccelerate;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentPierce;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentSplit;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.World;

public class MethodArcProj
extends AbstractCastMethod {
    public static MethodArcProj INSTANCE = new MethodArcProj();

    public MethodArcProj() {
        super("arc_projectile", "Arc Projectile");
    }

    public void summonProjectiles(World world, PlayerEntity shooter, List<AbstractAugment> augments, SpellResolver resolver) {
        ArrayList<EntityArcProjectile> projectiles = new ArrayList<EntityArcProjectile>();
        EntityArcProjectile projectileSpell = new EntityArcProjectile(world, resolver);
        projectiles.add(projectileSpell);
        int numSplits = MethodArcProj.getBuffCount(augments, AugmentSplit.class);
        for (int i = 1; i < numSplits + 1; ++i) {
            Direction offset = shooter.func_174811_aO().func_176746_e();
            if (i % 2 == 0) {
                offset = offset.func_176734_d();
            }
            BlockPos projPos = shooter.func_233580_cy_().func_177967_a(offset, i);
            projPos = projPos.func_177963_a(0.0, 1.5, 0.0);
            EntityArcProjectile spell = new EntityArcProjectile(world, resolver);
            spell.func_70107_b(projPos.func_177958_n(), projPos.func_177956_o(), projPos.func_177952_p());
            projectiles.add(spell);
        }
        float velocity = 0.8f + (float)MethodArcProj.getBuffCount(augments, AugmentAccelerate.class) / 10.0f;
        for (EntityArcProjectile proj : projectiles) {
            proj.func_70107_b(proj.func_226277_ct_(), proj.func_226278_cu_() + 0.25, proj.func_226281_cx_());
            proj.shoot((Entity)shooter, shooter.field_70177_z, shooter.field_70177_z, 0.0f, velocity, 0.3f);
            world.func_217376_c((Entity)proj);
        }
    }

    public void onCast(ItemStack itemStack, LivingEntity shooter, World world, List<AbstractAugment> list, SpellContext spellContext, SpellResolver resolver) {
        this.summonProjectiles(world, (PlayerEntity)shooter, list, resolver);
        resolver.expendMana(shooter);
    }

    public void onCastOnBlock(ItemUseContext context, List<AbstractAugment> list, SpellContext spellStats, SpellResolver resolver) {
        World world = context.func_195991_k();
        PlayerEntity shooter = context.func_195999_j();
        this.summonProjectiles(world, shooter, list, resolver);
        resolver.expendMana((LivingEntity)shooter);
    }

    public void onCastOnBlock(BlockRayTraceResult blockRayTraceResult, LivingEntity livingEntity, List<AbstractAugment> list, SpellContext spellContext, SpellResolver spellResolver) {
    }

    public void onCastOnEntity(ItemStack itemStack, LivingEntity livingEntity, Entity entity, Hand hand, List<AbstractAugment> list, SpellContext spellContext, SpellResolver spellResolver) {
    }

    public boolean wouldCastSuccessfully(ItemStack itemStack, LivingEntity livingEntity, World world, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public boolean wouldCastOnBlockSuccessfully(ItemUseContext itemUseContext, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public boolean wouldCastOnBlockSuccessfully(BlockRayTraceResult blockRayTraceResult, LivingEntity livingEntity, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public boolean wouldCastOnEntitySuccessfully(ItemStack itemStack, LivingEntity livingEntity, Entity entity, Hand hand, List<AbstractAugment> list, SpellResolver spellResolver) {
        return false;
    }

    public int getManaCost() {
        return 10;
    }

    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentPierce.INSTANCE, AugmentSplit.INSTANCE, AugmentAccelerate.INSTANCE});
    }
}

