/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.altar;

import elucent.rootsclassic.block.brazier.BrazierTile;
import elucent.rootsclassic.client.particles.MagicAltarParticleData;
import elucent.rootsclassic.client.particles.MagicLineParticleData;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.ritual.RitualBase;
import elucent.rootsclassic.ritual.RitualBaseRegistry;
import elucent.rootsclassic.ritual.RitualRegistry;
import elucent.rootsclassic.tile.TEBase;
import elucent.rootsclassic.util.InventoryUtil;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class AltarTile
extends TEBase
implements ITickableTileEntity {
    private static final int RECIPE_PROGRESS_TIME = 200;
    private ArrayList<ItemStack> incenses = new ArrayList();
    private int ticker = 0;
    private int progress = 0;
    private ResourceLocation ritualName = null;
    private RitualBase ritualCurrent = null;
    public final ItemStackHandler inventory = new ItemStackHandler(3){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public AltarTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public AltarTile() {
        super((TileEntityType)RootsRegistry.ALTAR_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("InventoryHandler"));
        this.setIncenses(new ArrayList<ItemStack>());
        if (tag.func_74764_b("incenses")) {
            ListNBT list = tag.func_150295_c("incenses", 10);
            for (int i = 0; i < list.size(); ++i) {
                this.getIncenses().add(ItemStack.func_199557_a((CompoundNBT)list.func_150305_b(i)));
            }
        }
        if (tag.func_74764_b("ritualName")) {
            this.setRitualNameFromString(tag.func_74779_i("ritualName"));
            this.setRitualCurrent((RitualBase)RitualBaseRegistry.RITUALS.getValue(this.getRitualName()));
        }
        if (tag.func_74764_b("progress")) {
            this.setProgress(tag.func_74762_e("progress"));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("InventoryHandler", (INBT)this.inventory.serializeNBT());
        if (this.getIncenses().size() > 0) {
            ListNBT list = new ListNBT();
            for (int i = 0; i < this.getIncenses().size(); ++i) {
                list.add((Object)this.getIncenses().get(i).func_77955_b(new CompoundNBT()));
            }
            tag.func_218657_a("incenses", (INBT)list);
        }
        if (this.getRitualName() != null) {
            tag.func_74778_a("ritualName", this.getRitualName().toString());
        }
        tag.func_74768_a("progress", this.getProgress());
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack slotStack;
            if (world.field_72995_K || (slotStack = this.inventory.getStackInSlot(i)).func_190926_b()) continue;
            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, slotStack));
        }
        this.func_145843_s();
    }

    @Override
    public ActionResultType activate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, ItemStack heldItem, BlockRayTraceResult hit) {
        if (hand == Hand.MAIN_HAND) {
            if (heldItem.func_190926_b() && !player.func_225608_bj_() && this.getProgress() == 0) {
                if (this.inventory.getSlots() > 0) {
                    ItemStack lastStack = InventoryUtil.getLastStack((IItemHandler)this.inventory);
                    if (!lastStack.func_190926_b()) {
                        if (!world.field_72995_K) {
                            world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, lastStack.func_77946_l()));
                        }
                        lastStack.func_190918_g(1);
                        this.func_70296_d();
                        world.func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (player.func_225608_bj_() && heldItem.func_190926_b() && this.getProgress() == 0) {
                    this.setRitualName(null);
                    this.setRitualCurrent(null);
                    RitualBase ritual = RitualRegistry.findMatchingByIngredients(this);
                    if (ritual == null) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.error.noritual.ingredients"), true);
                        return ActionResultType.FAIL;
                    }
                    if (!ritual.verifyPositionBlocks(world, pos)) {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.error.noritual.stones"), true);
                        return ActionResultType.FAIL;
                    }
                    if (ritual.incenseMatches(this.func_145831_w(), this.func_174877_v())) {
                        this.setRitualCurrent(ritual);
                        this.setRitualName(ritual.getRegistryName());
                        this.setIncenses(RitualRegistry.getIncenses(world, this.func_174877_v()));
                        this.setProgress(200);
                        for (BrazierTile brazier : ritual.getRecipeBraziers(world, pos)) {
                            brazier.setBurning(true);
                            brazier.setHeldItem(ItemStack.field_190927_a);
                        }
                        this.func_70296_d();
                        world.func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.ritual.started"), true);
                    } else {
                        player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.error.noritual.incense"), true);
                    }
                    return ActionResultType.SUCCESS;
                }
                if (!InventoryUtil.isFull((IItemHandler)this.inventory) && this.getProgress() == 0) {
                    ItemStack copyStack = heldItem.func_77946_l();
                    copyStack.func_190920_e(1);
                    ItemStack remaining = ItemHandlerHelper.insertItem((IItemHandler)this.inventory, (ItemStack)copyStack, (boolean)false);
                    if (remaining.func_190926_b()) {
                        heldItem.func_190918_g(1);
                        this.func_70296_d();
                        world.func_184138_a(this.func_174877_v(), state, world.func_180495_p(pos), 3);
                    }
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }

    public void func_73660_a() {
        this.setTicker(this.getTicker() + 3);
        if (this.getTicker() > 360) {
            this.setTicker(0);
        }
        if (this.getProgress() > 0 && this.getRitualCurrent() != null) {
            this.setProgress(this.getProgress() - 1);
            if (this.field_145850_b.field_72995_K) {
                if (this.getRitualCurrent().getPositionsRelative().size() > 0) {
                    BlockPos pos = this.getRitualCurrent().getPositionsRelative().get(this.field_145850_b.field_73012_v.nextInt(this.getRitualCurrent().getPositionsRelative().size())).func_177984_a().func_177982_a(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
                    if (this.field_145850_b.field_73012_v.nextInt(6) == 0) {
                        this.field_145850_b.func_195594_a(MagicLineParticleData.createData(this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5);
                    } else {
                        this.field_145850_b.func_195594_a(MagicLineParticleData.createData(this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.125, (double)pos.func_177952_p() + 0.5, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5);
                    }
                }
                if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)));
                } else {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(360.0 * (double)(this.getProgress() % 100) / 100.0)));
                }
                if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)));
                } else {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(90.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)));
                }
                if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)));
                } else {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(180.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)));
                }
                if (this.field_145850_b.field_73012_v.nextInt(4) == 0) {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getColor().field_72450_a, this.getRitualCurrent().getColor().field_72448_b, this.getRitualCurrent().getColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)));
                } else {
                    this.field_145850_b.func_195594_a(MagicAltarParticleData.createData(this.getRitualCurrent().getSecondaryColor().field_72450_a, this.getRitualCurrent().getSecondaryColor().field_72448_b, this.getRitualCurrent().getSecondaryColor().field_72449_c), (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.875, (double)this.func_174877_v().func_177952_p() + 0.5, 0.125 * Math.sin(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)), 0.0, 0.125 * Math.cos(Math.toRadians(270.0 + 360.0 * (double)(this.getProgress() % 100) / 100.0)));
                }
            }
            if (this.getProgress() == 0 && this.getRitualCurrent() != null) {
                this.getRitualCurrent().doEffect(this.func_145831_w(), this.func_174877_v(), InventoryUtil.createIInventory((IItemHandler)this.inventory), this.getIncenses());
                this.setRitualName(null);
                this.setRitualCurrent(null);
                this.emptyAltar();
                this.func_70296_d();
                this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
            }
        }
    }

    public ArrayList<ItemStack> getIncenses() {
        return this.incenses;
    }

    public void setIncenses(ArrayList<ItemStack> incenses) {
        this.incenses = incenses;
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public ResourceLocation getRitualName() {
        return this.ritualName;
    }

    public void setRitualNameFromString(String ritualName) {
        this.ritualName = ResourceLocation.func_208304_a((String)ritualName);
    }

    public void setRitualName(ResourceLocation ritualName) {
        this.ritualName = ritualName;
    }

    public RitualBase getRitualCurrent() {
        return this.ritualCurrent;
    }

    public void setRitualCurrent(RitualBase ritualCurrent) {
        this.ritualCurrent = ritualCurrent;
    }

    public void emptyAltar() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

