/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.block.brazier;

import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.tile.TEBase;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class BrazierTile
extends TEBase
implements ITickableTileEntity {
    private static final int TOTAL_BURN_TIME = 2400;
    private int ticker = 0;
    private boolean burning = false;
    private int progress = 0;
    public final ItemStackHandler inventory = new ItemStackHandler(1){

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> inventoryHolder = LazyOptional.of(() -> this.inventory);

    public BrazierTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public BrazierTile() {
        super((TileEntityType)RootsRegistry.BRAZIER_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("InventoryHandler"));
        if (tag.func_74764_b("burning")) {
            this.setBurning(tag.func_74767_n("burning"));
        }
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        tag = super.func_189515_b(tag);
        tag.func_218657_a("InventoryHandler", (INBT)this.inventory.serializeNBT());
        tag.func_74757_a("burning", this.isBurning());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        if (this.getHeldItem() != null && !this.isBurning()) {
            this.dropContaining();
        }
        this.func_145843_s();
    }

    private void dropContaining() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, this.getHeldItem()));
        }
        this.setHeldItem(ItemStack.field_190927_a);
    }

    private void notifyUpdate(BlockState state) {
        this.func_70296_d();
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    @Override
    public ActionResultType activate(World world, BlockPos pos, BlockState state, PlayerEntity player, Hand hand, ItemStack playerItem, BlockRayTraceResult hit) {
        if (playerItem.func_190926_b()) {
            if (!this.getHeldItem().func_190926_b() && !this.isBurning()) {
                if (player.func_225608_bj_()) {
                    player.func_146105_b(this.getHeldItem().func_200301_q(), true);
                } else {
                    this.dropContaining();
                    this.notifyUpdate(state);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.brazier.burning.empty"), true);
                }
                return ActionResultType.SUCCESS;
            }
            if (this.isBurning() && player.func_225608_bj_()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.brazier.burning.off"), true);
                this.stopBurning();
                this.notifyUpdate(state);
                return ActionResultType.SUCCESS;
            }
        } else if (playerItem.func_77973_b() == Items.field_151033_d) {
            if (!this.getHeldItem().func_190926_b()) {
                this.startBurning();
                player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.brazier.burning.on"), true);
                this.notifyUpdate(state);
                return ActionResultType.SUCCESS;
            }
        } else if (this.getHeldItem().func_190926_b()) {
            this.setHeldItem(new ItemStack((IItemProvider)playerItem.func_77973_b(), 1));
            if (playerItem.func_77942_o()) {
                this.getHeldItem().func_77982_d(playerItem.func_77978_p());
            }
            playerItem.func_190918_g(1);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("rootsclassic.brazier.burning.added"), true);
            this.notifyUpdate(state);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    private void startBurning() {
        this.setBurning(true);
        this.progress = 2400;
    }

    private void stopBurning() {
        this.setBurning(false);
        this.progress = 0;
    }

    public void func_73660_a() {
        this.setTicker(this.getTicker() + (this.isBurning() ? 12 : 3));
        if (this.progress > 0) {
            World world = this.func_145831_w();
            --this.progress;
            if (world.field_72995_K) {
                if (this.progress % 2 == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, world.field_73012_v.nextDouble() * 0.0625 + 0.0625, 0.0);
                }
                if (this.progress % 20 == 0) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197631_x, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, 0.0, 0.0, 0.0);
                }
            }
            if (this.progress <= 0) {
                this.setBurning(false);
                this.func_70296_d();
                world.func_184138_a(this.func_174877_v(), world.func_180495_p(this.func_174877_v()), world.func_180495_p(this.func_174877_v()), 3);
            }
        }
        if (this.getTicker() > 360) {
            this.setTicker(0);
        }
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }

    public int getTicker() {
        return this.ticker;
    }

    public void setTicker(int ticker) {
        this.ticker = ticker;
    }

    public ItemStack getHeldItem() {
        return this.inventory.getStackInSlot(0);
    }

    public void setHeldItem(ItemStack heldItem) {
        this.inventory.setStackInSlot(0, heldItem);
    }

    protected void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHolder.invalidate();
    }
}

