/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.compat;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.actions.IAction;
import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.managers.IRecipeManager;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionAddRecipe;
import com.blamejared.crafttweaker.impl.actions.recipes.ActionRemoveRecipeByName;
import com.blamejared.crafttweaker.impl.managers.CTCraftingTableManager;
import elucent.rootsclassic.component.ComponentManager;
import elucent.rootsclassic.recipe.ComponentRecipe;
import elucent.rootsclassic.registry.RootsRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.rootsclassic.Spell")
public class SpellZen
implements IRecipeManager {
    public static final SpellZen INSTANCE = new SpellZen();

    private SpellZen() {
    }

    @ZenCodeType.Method
    public void setSpellIngredients(ResourceLocation name, IItemStack[] ingredients) {
        if (ingredients.length == 0 || ingredients.length > 4) {
            throw new IllegalArgumentException("Invalid spell ingredients, must be in range [1,4]");
        }
        ComponentRecipe found = this.findSpellByName(name);
        CraftTweakerAPI.logInfo((String)("Changing spell ingredients of " + found.getEffectResult()), (Object[])new Object[0]);
        NonNullList ingredientList = NonNullList.func_191196_a();
        for (IItemStack ingredient : ingredients) {
            ingredientList.add((Object)ingredient.asVanillaIngredient());
        }
        ComponentRecipe newRecipe = new ComponentRecipe(found.func_199560_c(), found.getEffectResult(), found.func_193358_e(), found.func_77571_b(), (NonNullList<Ingredient>)ingredientList, found.needsMixin());
        CraftTweakerAPI.apply((IAction)new ActionRemoveRecipeByName((IRecipeManager)INSTANCE, found.func_199560_c()));
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (IRecipe)newRecipe));
    }

    @ZenCodeType.Method
    public void addMortarCrafting(String uniqueName, IItemStack[] items, IItemStack output) {
        if (items.length == 0 || items.length > 4) {
            throw new IllegalArgumentException("Invalid ingredient size, must be in range [1,4]");
        }
        NonNullList ingredients = NonNullList.func_191196_a();
        for (IItemStack stack : items) {
            ingredients.add((Object)stack.asVanillaIngredient());
        }
        ComponentRecipe craftingRecipe = new ComponentRecipe(new ResourceLocation("crafttweaker", uniqueName), new ResourceLocation("rootsclassic", "none"), "crafttweaker", output.getInternal(), (NonNullList<Ingredient>)ingredients, true);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe((IRecipeManager)INSTANCE, (IRecipe)craftingRecipe));
    }

    private ComponentRecipe findSpellByName(ResourceLocation name) {
        ComponentRecipe found = ComponentManager.getSpellFromName(CTCraftingTableManager.recipeManager, name);
        if (found == null) {
            StringBuilder names = new StringBuilder();
            for (ComponentRecipe recipe : CTCraftingTableManager.recipeManager.func_241447_a_(RootsRecipes.COMPONENT_RECIPE_TYPE)) {
                if (!name.func_110624_b().equals("rootsclassic") || name.func_110623_a().equals("none")) continue;
                names.append(recipe.getEffectResult()).append(", ");
            }
            throw new IllegalArgumentException("Invalid spell [" + name + "], names must be one of: " + names);
        }
        return found;
    }

    public IRecipeType<?> getRecipeType() {
        return RootsRecipes.COMPONENT_RECIPE_TYPE;
    }
}

