/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.config;

import elucent.rootsclassic.Roots;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class RootsConfig {
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfig.Loading configEvent) {
        Roots.LOGGER.debug("Loaded Roots Classic's config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        Roots.LOGGER.fatal("Roots Classic's config just got changed on the file system!");
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue oldRootDropChance;
        public final ForgeConfigSpec.IntValue verdantSprigDropChance;
        public final ForgeConfigSpec.IntValue infernalStemDropChance;
        public final ForgeConfigSpec.IntValue dragonsEyeDropChance;
        public final ForgeConfigSpec.IntValue berriesDropChance;
        public final ForgeConfigSpec.DoubleValue barkKnifeBlockStripChance;
        public final ForgeConfigSpec.IntValue chargeTicks;
        public final ForgeConfigSpec.IntValue staffUses;
        public final ForgeConfigSpec.IntValue efficiencyBonus;
        public final ForgeConfigSpec.BooleanValue disablePVP;
        public final ForgeConfigSpec.IntValue ticksPerManaRegen;
        public final ForgeConfigSpec.IntValue staffUsesBasic;
        public final ForgeConfigSpec.IntValue staffUsesEfficiency;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings related to actual gameplay-affecting features").push("items");
            this.oldRootDropChance = builder.comment("Old Roots will drop from tall grass with a 1/oldRootDropChance probability").defineInRange("oldRootDropChance", 40, 0, Short.MAX_VALUE);
            this.verdantSprigDropChance = builder.comment("Verdant Sprigs will drop from grown crops with a 1/verdantSprigDropChance probability").defineInRange("verdantSprigDropChance", 30, 0, Short.MAX_VALUE);
            this.infernalStemDropChance = builder.comment("Infernal Bulbs will drop from nether wart with a 1/infernalBulbDropChance probability").defineInRange("infernalStemDropChance", 20, 0, Short.MAX_VALUE);
            this.dragonsEyeDropChance = builder.comment("Dragon's Eyes will drop from chorus flowers with a 1/dragonsEyeDropChance probability").defineInRange("dragonsEyeDropChance", 10, 0, Short.MAX_VALUE);
            this.berriesDropChance = builder.comment("Berries will drop from oak leaves with a 1/berriesDropChance probability").defineInRange("berriesDropChance", 25, 0, Short.MAX_VALUE);
            this.barkKnifeBlockStripChance = builder.comment("Chance that the bark knife will strip the log, 1 is always strip on first harvest").defineInRange("barkKnifeBlockStripChance", (double)0.3f, (double)0.1f, 1.0);
            builder.pop();
            builder.comment("Settings related to actual gameplay-affecting features").push("magic");
            this.chargeTicks = builder.comment("The number of ticks required to prepare a spell with a staff").defineInRange("staffChargeTicks", 20, 1, Short.MAX_VALUE);
            this.staffUses = builder.comment("The number of uses an unmodified staff will have upon being crafted").defineInRange("staffUses", 65, 0, Short.MAX_VALUE);
            this.efficiencyBonus = builder.comment("The number of additional uses each efficiency modifier gives").defineInRange("efficiencyBonusUses", 32, 0, Short.MAX_VALUE);
            this.disablePVP = builder.comment("Whether or not damaging spells can affect players").define("disablePVP", false);
            this.ticksPerManaRegen = builder.comment("Number of ticks between each mana regeneration (20 ticks = 1 second)").defineInRange("ticksPerManaRegen", 15, 1, 100);
            this.staffUsesBasic = builder.comment("Number of basic uses for one spell staff").defineInRange("staffUsesBasic", 15, 1, 100);
            this.staffUsesEfficiency = builder.comment("Number of uses added by each efficiency level on a spell").defineInRange("staffUsesEfficiency", 15, 1, 100);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue showTabletWave;
        public final ForgeConfigSpec.IntValue manaBarOffset;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client settings").push("client");
            this.showTabletWave = builder.comment("Toggles the wave effect in the Runic Tablet GUI").define("showTabletWave", true);
            this.manaBarOffset = builder.comment("The number of pixels above the bottom of the screen that the mana bar should be rendered. If it's conflicting with a bar from another mod, raising it by 10 will normally position it right").defineInRange("manaBarOffset", 49, 0, Short.MAX_VALUE);
            builder.pop();
        }
    }
}

