/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.datagen;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import elucent.rootsclassic.block.AttunedStandingStoneBlock;
import elucent.rootsclassic.lootmodifiers.DropModifier;
import elucent.rootsclassic.registry.RootsEntities;
import elucent.rootsclassic.registry.RootsRegistry;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.Inverted;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class RootsDataGen {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeServer()) {
            generator.func_200390_a((IDataProvider)new Loots(generator));
            generator.func_200390_a((IDataProvider)new Recipes(generator));
            generator.func_200390_a((IDataProvider)new GLMProvider(generator));
        }
        if (event.includeClient()) {
            // empty if block
        }
    }

    private static class Recipes
    extends RecipeProvider {
        public Recipes(DataGenerator gen) {
            super(gen);
        }

        protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.PESTLE.get())).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_196654_e).func_200473_b("pestle").func_200472_a("X  ").func_200472_a(" XX").func_200472_a(" XX").func_200465_a("has_diorite", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Blocks.field_196654_e)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.PESTLE.get())).func_200462_a(Character.valueOf('X'), (IItemProvider)Blocks.field_196654_e).func_200473_b("pestle").func_200472_a("  X").func_200472_a("XX ").func_200472_a("XX ").func_200465_a("has_diorite", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Blocks.field_196654_e)).func_200466_a(consumer, Registry.field_212630_s.func_177774_c((Object)RootsRegistry.PESTLE.get()) + "2");
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.MORTAR.get())).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.STONE).func_200472_a("X X").func_200472_a("X X").func_200472_a(" X ").func_200465_a("has_stone", (ICriterionInstance)Recipes.func_200409_a((ITag)Tags.Items.STONE)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.IMBUER.get())).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('L'), (ITag)ItemTags.field_200038_h).func_200462_a(Character.valueOf('S'), (IItemProvider)Blocks.field_196702_dl).func_200472_a("X X").func_200472_a("LSL").func_200465_a("has_chiseled_stone_bricks", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Blocks.field_196702_dl)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.MUNDANE_STANDING_STONE.get())).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('B'), (IItemProvider)Blocks.field_196696_di).func_200469_a(Character.valueOf('L'), (ITag)Tags.Items.STORAGE_BLOCKS_LAPIS).func_200472_a("SBS").func_200472_a("BLB").func_200472_a("SBS").func_200465_a("has_lapis_block", (ICriterionInstance)Recipes.func_200409_a((ITag)Tags.Items.STORAGE_BLOCKS_LAPIS)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.ATTUNED_STANDING_STONE.get())).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200469_a(Character.valueOf('N'), (ITag)Tags.Items.INGOTS_NETHER_BRICK).func_200469_a(Character.valueOf('D'), (ITag)Tags.Items.GEMS_DIAMOND).func_200472_a("SNS").func_200472_a("NDN").func_200472_a("SNS").func_200465_a("has_diamond", (ICriterionInstance)Recipes.func_200409_a((ITag)Tags.Items.GEMS_DIAMOND)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.BRAZIER.get())).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STRING).func_200462_a(Character.valueOf('C'), (IItemProvider)Items.field_222089_ms).func_200469_a(Character.valueOf('X'), (ITag)Tags.Items.RODS_WOODEN).func_200472_a("ISI").func_200472_a("ICI").func_200472_a("IXI").func_200465_a("has_cauldron", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Items.field_222089_ms)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.ALTAR.get())).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('F'), (IItemProvider)Items.field_221620_aV).func_200462_a(Character.valueOf('B'), (IItemProvider)RootsRegistry.VERDANT_SPRIG.get()).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.STORAGE_BLOCKS_GOLD).func_200462_a(Character.valueOf('C'), (IItemProvider)Blocks.field_196702_dl).func_200472_a("BFB").func_200472_a("SGS").func_200472_a(" C ").func_200465_a("has_gold_block", (ICriterionInstance)Recipes.func_200409_a((ITag)Tags.Items.STORAGE_BLOCKS_GOLD)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.BARK_KNIFE.get())).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200469_a(Character.valueOf('V'), (ITag)ItemTags.field_200037_g).func_200469_a(Character.valueOf('P'), (ITag)ItemTags.field_199905_b).func_200472_a(" VV").func_200472_a("VPV").func_200472_a("SV ").func_200465_a("has_sapling", (ICriterionInstance)Recipes.func_200409_a((ITag)ItemTags.field_200037_g)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)((IItemProvider)RootsRegistry.RUNIC_TABLET.get())).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.SEEDS_WHEAT).func_200469_a(Character.valueOf('B'), (ITag)Tags.Items.STONE).func_200462_a(Character.valueOf('R'), (IItemProvider)RootsRegistry.OLD_ROOT.get()).func_200472_a(" R ").func_200472_a("SBS").func_200472_a(" S ").func_200465_a("has_old_root", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)RootsRegistry.OLD_ROOT.get()))).func_200464_a(consumer);
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)RootsRegistry.GROWTH_POWDER.get()), (int)4).func_203221_a((ITag)Tags.Items.SEEDS_WHEAT).func_200487_b((IItemProvider)Items.field_221674_ay).func_203221_a((ITag)Tags.Items.DUSTS_REDSTONE).func_200487_b((IItemProvider)RootsRegistry.PESTLE.get()).func_200483_a("has_pestle", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)RootsRegistry.PESTLE.get()))).func_200482_a(consumer);
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)RootsRegistry.MUTATING_POWDER.get())).func_200487_b((IItemProvider)RootsRegistry.GROWTH_POWDER.get()).func_200487_b((IItemProvider)RootsRegistry.GROWTH_POWDER.get()).func_200487_b((IItemProvider)RootsRegistry.GROWTH_POWDER.get()).func_200487_b((IItemProvider)RootsRegistry.GROWTH_POWDER.get()).func_203221_a((ITag)Tags.Items.NETHER_STARS).func_203221_a((ITag)Tags.Items.CROPS_NETHER_WART).func_200487_b((IItemProvider)RootsRegistry.PESTLE.get()).func_200483_a("has_pestle", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)RootsRegistry.PESTLE.get()))).func_200482_a(consumer);
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)RootsRegistry.ROOTY_STEW.get())).func_203221_a((ITag)Tags.Items.CROPS_WHEAT).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)RootsRegistry.OLD_ROOT.get()).func_200483_a("has_bowl", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Items.field_151054_z)).func_200482_a(consumer);
            ShapelessRecipeBuilder.func_200486_a((IItemProvider)((IItemProvider)RootsRegistry.FRUIT_SALAD.get())).func_200487_b((IItemProvider)Items.field_221794_dg).func_200487_b((IItemProvider)Items.field_221794_dg).func_200487_b((IItemProvider)Items.field_221794_dg).func_200487_b((IItemProvider)Items.field_151034_e).func_200487_b((IItemProvider)Items.field_151054_z).func_200487_b((IItemProvider)RootsRegistry.ELDERBERRY.get()).func_200487_b((IItemProvider)RootsRegistry.WHITECURRANT.get()).func_200487_b((IItemProvider)RootsRegistry.BLACKCURRANT.get()).func_200487_b((IItemProvider)RootsRegistry.REDCURRANT.get()).func_200483_a("has_bowl", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)Items.field_151054_z)).func_200482_a(consumer);
            ShapelessRecipeBuilder.func_200488_a((IItemProvider)((IItemProvider)RootsRegistry.HEALING_POULTICE.get()), (int)2).func_200487_b((IItemProvider)RootsRegistry.REDCURRANT.get()).func_200487_b((IItemProvider)Items.field_151121_aF).func_200487_b((IItemProvider)RootsRegistry.PESTLE.get()).func_200487_b((IItemProvider)RootsRegistry.VERDANT_SPRIG.get()).func_200483_a("has_pestle", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)RootsRegistry.PESTLE.get()))).func_200482_a(consumer);
            CookingRecipeBuilder.func_218629_c((Ingredient)Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)RootsRegistry.DRAGONS_EYE.get()}), (IItemProvider)Items.field_151079_bi, (float)1.0f, (int)200).func_218628_a("has_dragons_eye", (ICriterionInstance)Recipes.func_200403_a((IItemProvider)((IItemProvider)RootsRegistry.DRAGONS_EYE.get()))).func_218632_a(consumer, "rootsclassic:ender_pearl");
        }

        protected void func_208310_b(DirectoryCache cache, JsonObject advancementJson, Path path) {
        }
    }

    private static class GLMProvider
    extends GlobalLootModifierProvider {
        public GLMProvider(DataGenerator gen) {
            super(gen, "rootsclassic");
        }

        protected void start() {
            this.add("rootsclassic_drops", (GlobalLootModifierSerializer)DropModifier.ROOTSCLASSIC_DROPS.get(), (IGlobalLootModifier)new DropModifier.BlockDropModifier(new ILootCondition[]{Inverted.func_215979_a((ILootCondition.IBuilder)MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.SHEARS))).build()}));
        }
    }

    private static class Loots
    extends LootTableProvider {
        public Loots(DataGenerator gen) {
            super(gen);
        }

        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new RootsBlockLoot(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new RootsEntityLoot(), (Object)LootParameterSets.field_216263_d));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
            map.forEach((name, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)name, (LootTable)table));
        }

        private class RootsEntityLoot
        extends EntityLootTables {
            private RootsEntityLoot() {
            }

            protected void addTables() {
                this.func_218582_a((EntityType)RootsEntities.PHANTOM_SKELETON.get(), LootTable.func_216119_b());
            }

            protected boolean isNonLiving(EntityType<?> entityType) {
                return entityType.func_220339_d() == EntityClassification.MISC;
            }

            protected Iterable<EntityType<?>> getKnownEntities() {
                Stream<EntityType> entities = RootsEntities.ENTITIES.getEntries().stream().map(RegistryObject::get);
                return entities::iterator;
            }
        }

        private class RootsBlockLoot
        extends BlockLootTables {
            private RootsBlockLoot() {
            }

            protected void addTables() {
                this.func_218492_c((Block)RootsRegistry.MORTAR.get());
                this.func_218492_c((Block)RootsRegistry.ALTAR.get());
                this.func_218492_c((Block)RootsRegistry.BRAZIER.get());
                this.func_218492_c((Block)RootsRegistry.IMBUER.get());
                this.func_218492_c((Block)RootsRegistry.MUNDANE_STANDING_STONE.get());
                this.func_218492_c((Block)RootsRegistry.MIDNIGHT_BLOOM.get());
                this.func_218492_c((Block)RootsRegistry.FLARE_ORCHID.get());
                this.func_218492_c((Block)RootsRegistry.RADIANT_DAISY.get());
                this.func_218522_a((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.VACUUM_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.REPULSOR_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.ACCELERATOR_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.AESTHETIC_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.ENTANGLER_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.IGNITER_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.GROWER_STANDING_STONE.get(), this::registerStandingStone);
                this.func_218522_a((Block)RootsRegistry.HEALER_STANDING_STONE.get(), this::registerStandingStone);
            }

            public LootTable.Builder registerStandingStone(Block standingStone) {
                return RootsBlockLoot.func_218562_a((Block)standingStone, AttunedStandingStoneBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
            }

            protected Iterable<Block> getKnownBlocks() {
                return RootsRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get)::iterator;
            }
        }
    }
}

