/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.lootmodifiers;

import com.google.gson.JsonObject;
import elucent.rootsclassic.config.RootsConfig;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.registry.RootsTags;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.TallGrassBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.state.Property;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class DropModifier {
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)"rootsclassic");
    public static final RegistryObject<BlockDropModifier.Serializer> ROOTSCLASSIC_DROPS = GLM.register("rootsclassic_drops", () -> new BlockDropModifier.Serializer());

    public static class BlockDropModifier
    extends LootModifier {
        public BlockDropModifier(ILootCondition[] lootConditions) {
            super(lootConditions);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            if (context.func_216033_a(LootParameters.field_216287_g)) {
                BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
                Block block = state.func_177230_c();
                Random rand = context.func_216032_b();
                if (block instanceof TallGrassBlock && rand.nextInt((Integer)RootsConfig.COMMON.oldRootDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((IItemProvider)RootsRegistry.OLD_ROOT.get(), 1));
                }
                if ((block == Blocks.field_150464_aj || block == Blocks.field_150459_bM || block == Blocks.field_150469_bN || block == Blocks.field_185773_cZ) && ((CropsBlock)block).func_185525_y(state) && rand.nextInt((Integer)RootsConfig.COMMON.verdantSprigDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((IItemProvider)RootsRegistry.VERDANT_SPRIG.get(), 1));
                }
                if (block == Blocks.field_150388_bm && (Integer)state.func_177229_b((Property)NetherWartBlock.field_176486_a) == 3 && rand.nextInt((Integer)RootsConfig.COMMON.infernalStemDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((IItemProvider)RootsRegistry.INFERNAL_BULB.get(), 1));
                }
                if (block == Blocks.field_185766_cS && rand.nextInt((Integer)RootsConfig.COMMON.dragonsEyeDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((IItemProvider)RootsRegistry.DRAGONS_EYE.get(), 1));
                }
                if (block instanceof LeavesBlock && !generatedLoot.stream().anyMatch(stack -> stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() == block) && rand.nextInt((Integer)RootsConfig.COMMON.berriesDropChance.get()) == 0) {
                    generatedLoot.add(new ItemStack((IItemProvider)RootsTags.BERRIES.func_205596_a(rand)));
                }
            }
            return generatedLoot;
        }

        private static class Serializer
        extends GlobalLootModifierSerializer<BlockDropModifier> {
            private Serializer() {
            }

            public BlockDropModifier read(ResourceLocation location, JsonObject jsonObject, ILootCondition[] lootConditions) {
                return new BlockDropModifier(lootConditions);
            }

            public JsonObject write(BlockDropModifier instance) {
                return this.makeConditions(instance.conditions);
            }
        }
    }
}

