/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import elucent.rootsclassic.item.SpellPowderItem;
import elucent.rootsclassic.registry.RootsRecipes;
import elucent.rootsclassic.registry.RootsRegistry;
import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ComponentRecipe
implements IRecipe<IInventory> {
    private static final int MAX_INGREDIENTS = 4;
    private final ResourceLocation id;
    private final ResourceLocation effectResult;
    private final String group;
    private final ItemStack recipeOutput;
    private final NonNullList<Ingredient> materials;
    private final boolean needsMixin;

    public boolean func_192399_d() {
        return true;
    }

    public ComponentRecipe(ResourceLocation idIn, ResourceLocation effectResult, String groupIn, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn, boolean needsMixin) {
        this.id = idIn;
        this.effectResult = effectResult;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.materials = recipeItemsIn;
        this.needsMixin = needsMixin;
    }

    public ComponentRecipe(ResourceLocation idIn, ResourceLocation effectResult, String groupIn, NonNullList<Ingredient> recipeItemsIn, boolean needsMixin) {
        this(idIn, effectResult, groupIn, new ItemStack((IItemProvider)RootsRegistry.SPELL_POWDER.get()), recipeItemsIn, needsMixin);
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public ResourceLocation getEffectResult() {
        return this.effectResult;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)RootsRecipes.COMPONENT_SERIALIZER.get();
    }

    public String func_193358_e() {
        return this.group;
    }

    public ItemStack func_77572_b(IInventory inventory) {
        ItemStack outputStack = this.func_77571_b();
        if (outputStack.func_77973_b() instanceof SpellPowderItem) {
            SpellPowderItem.createData(outputStack, this.getEffectResult(), inventory);
        }
        return outputStack;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput.func_77946_l();
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.materials;
    }

    public IRecipeType<?> func_222127_g() {
        return RootsRecipes.COMPONENT_RECIPE_TYPE;
    }

    public boolean needsMixin() {
        return this.needsMixin;
    }

    public TranslationTextComponent getLocalizedName() {
        return new TranslationTextComponent("rootsclassic.component." + this.func_199560_c());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Ingredient mat : this.func_192400_c()) {
            if (!mat.func_203189_d()) {
                s.append(mat.func_193365_a()[0].func_200301_q().getString()).append(" ");
                continue;
            }
            s.append("One of the ingredients has no matching ItemStack's");
        }
        return s.toString();
    }

    public boolean func_77569_a(IInventory inventory, World worldIn) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inventory.func_70302_i_(); ++j) {
            ItemStack stack = inventory.func_70301_a(j);
            if (stack.func_190926_b() || this.isSupplementItem(stack)) continue;
            ++i;
            inputs.add(stack);
        }
        return i == this.materials.size() && RecipeMatcher.findMatches(inputs, this.materials) != null;
    }

    private boolean isSupplementItem(ItemStack stack) {
        if (this.func_77571_b().func_77973_b() instanceof SpellPowderItem) {
            return stack.func_77973_b() == RootsRegistry.OLD_ROOT.get() || stack.func_77973_b() == RootsRegistry.VERDANT_SPRIG.get() || stack.func_77973_b() == RootsRegistry.INFERNAL_BULB.get() || stack.func_77973_b() == RootsRegistry.DRAGONS_EYE.get() || stack.func_77973_b() == Items.field_151114_aO || stack.func_77973_b() == Items.field_151137_ax || stack.func_77973_b() == Items.field_151016_H;
        }
        return false;
    }

    public static int getModifierCapacity(IInventory inventory) {
        int maxCapacity = -1;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() == RootsRegistry.OLD_ROOT.get() && maxCapacity < 0) {
                maxCapacity = 0;
            }
            if (stack.func_77973_b() == RootsRegistry.VERDANT_SPRIG.get() && maxCapacity < 1) {
                maxCapacity = 1;
            }
            if (stack.func_77973_b() == RootsRegistry.INFERNAL_BULB.get() && maxCapacity < 2) {
                maxCapacity = 2;
            }
            if (stack.func_77973_b() != RootsRegistry.DRAGONS_EYE.get() || maxCapacity >= 3) continue;
            maxCapacity = 3;
        }
        return maxCapacity;
    }

    public static int getModifierCount(IInventory inventory) {
        int count = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_77973_b() == Items.field_151114_aO) {
                ++count;
                continue;
            }
            if (stack.func_77973_b() == Items.field_151137_ax) {
                ++count;
                continue;
            }
            if (stack.func_77973_b() != Items.field_151016_H) continue;
            ++count;
        }
        return count;
    }

    public static class SerializeComponentRecipe
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<ComponentRecipe> {
        public ComponentRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = SerializeComponentRecipe.readIngredients(JSONUtils.func_151214_t((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for component recipe");
            }
            if (nonnulllist.size() > 4) {
                throw new JsonParseException("Too many ingredients for component recipe the max is 4");
            }
            boolean needsMixin = JSONUtils.func_151209_a((JsonObject)json, (String)"needs_mixin", (boolean)true);
            String effect = JSONUtils.func_151200_h((JsonObject)json, (String)"effect");
            ResourceLocation effectResult = ResourceLocation.func_208304_a((String)effect);
            if (JSONUtils.func_151204_g((JsonObject)json, (String)"result")) {
                ItemStack itemstack = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
                return new ComponentRecipe(recipeId, effectResult, s, itemstack, nonnulllist, needsMixin);
            }
            return new ComponentRecipe(recipeId, effectResult, s, nonnulllist, needsMixin);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredientArray.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ComponentRecipe fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
            String s = buffer.func_150789_c(Short.MAX_VALUE);
            int i = buffer.func_150792_a();
            NonNullList nonnulllist = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            boolean needsMixin = buffer.readBoolean();
            ResourceLocation effectResult = buffer.func_192575_l();
            ItemStack itemstack = buffer.func_150791_c();
            return new ComponentRecipe(recipeId, effectResult, s, itemstack, (NonNullList<Ingredient>)nonnulllist, needsMixin);
        }

        public void toNetwork(PacketBuffer buffer, ComponentRecipe recipe) {
            buffer.func_180714_a(recipe.group);
            buffer.func_150787_b(recipe.materials.size());
            for (Ingredient ingredient : recipe.materials) {
                ingredient.func_199564_a(buffer);
            }
            buffer.writeBoolean(recipe.needsMixin);
            buffer.func_192572_a(recipe.effectResult);
            buffer.func_150788_a(recipe.recipeOutput);
        }
    }
}

