/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.ritual;

import elucent.rootsclassic.Roots;
import elucent.rootsclassic.block.brazier.BrazierTile;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.util.RootsUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class RitualBase
extends ForgeRegistryEntry<RitualBase> {
    private static final int RADIUS = 4;
    private ArrayList<Block> blocks = new ArrayList();
    private ArrayList<BlockPos> positionsRelative = new ArrayList();
    private List<ItemStack> incenses = new ArrayList<ItemStack>();
    private List<ItemStack> ingredients = new ArrayList<ItemStack>();
    private Vector3d color = new Vector3d(255.0, 255.0, 255.0);
    private Vector3d secondaryColor = new Vector3d(255.0, 255.0, 255.0);
    private int level;

    public RitualBase(int level, double r, double g, double b) {
        this.setPrimaryColor(r, g, b);
        this.setSecondaryColor(r, g, b);
        this.setLevel(level);
    }

    public void setLevel(int level) {
        if (level < 0 || level > 2) {
            throw new IllegalArgumentException("Level must be 0, 1 or 2");
        }
        this.blocks = new ArrayList();
        this.level = level;
        if (level == 1 || level == 2) {
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, -3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, -3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 3, 0, 0);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), -3, 0, 0);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, 3);
            this.addRitualPillar((Block)RootsRegistry.MUNDANE_STANDING_STONE.get(), 0, 0, -3);
        } else if (level == 2) {
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 5, 1, 0);
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), -5, 1, 0);
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, 5);
            this.addRitualPillar((Block)RootsRegistry.ATTUNED_STANDING_STONE.get(), 0, 1, -5);
        }
    }

    public RitualBase addRitualPillar(Block b, int x, int y, int z) {
        this.getBlocks().add(b);
        this.getPositionsRelative().add(new BlockPos(x, y, z));
        return this;
    }

    public RitualBase addIngredient(ItemStack i) {
        this.getIngredients().add(i);
        return this;
    }

    public RitualBase addIncense(ItemStack i) {
        this.getIncenses().add(i);
        return this;
    }

    public boolean doIngredientsMatch(RitualBase ritual) {
        return RootsUtil.itemListsMatch(this.getIngredients(), ritual.getIngredients());
    }

    public abstract void doEffect(World var1, BlockPos var2, IInventory var3, List<ItemStack> var4);

    public boolean verifyPositionBlocks(World world, BlockPos pos) {
        if (this.getPositionsRelative().size() > 0) {
            for (int i = 0; i < this.getPositionsRelative().size(); ++i) {
                BlockPos loopPos = this.getPositionsRelative().get(i);
                Block loopBlock = this.getBlocks().get(i);
                BlockPos loopPosOffset = pos.func_177982_a(loopPos.func_177958_n(), loopPos.func_177956_o(), loopPos.func_177952_p());
                if (world.func_180495_p(loopPosOffset).func_177230_c() == loopBlock) continue;
                Roots.LOGGER.info(this.level + " level recipe has Missing block " + loopBlock + " at position " + loopPosOffset);
                return false;
            }
        }
        return true;
    }

    public List<BrazierTile> getRecipeBraziers(World world, BlockPos pos) {
        ArrayList<BrazierTile> links = new ArrayList<BrazierTile>();
        for (int i = -4; i <= 4; ++i) {
            for (int j = -4; j <= 4; ++j) {
                TileEntity tileHere;
                if (world.func_180495_p(pos.func_177982_a(i, 0, j)).func_177230_c() != RootsRegistry.BRAZIER.get() || !((tileHere = world.func_175625_s(pos.func_177982_a(i, 0, j))) instanceof BrazierTile)) continue;
                links.add((BrazierTile)tileHere);
            }
        }
        return links;
    }

    public boolean incenseMatches(World world, BlockPos pos) {
        ArrayList<ItemStack> incenseFromNearby = new ArrayList<ItemStack>();
        List<BrazierTile> braziers = this.getRecipeBraziers(world, pos);
        for (BrazierTile brazier : braziers) {
            if (brazier.getHeldItem().func_190926_b()) continue;
            incenseFromNearby.add(brazier.getHeldItem());
        }
        return RootsUtil.itemListsMatch(this.getIncenses(), incenseFromNearby);
    }

    public String toString() {
        StringBuilder s = new StringBuilder("[A] ");
        for (ItemStack mat : this.getIngredients()) {
            s.append(mat.func_200301_q().getString()).append("; ");
        }
        s.append("[I] ");
        for (ItemStack mat : this.getIncenses()) {
            s.append(mat.func_200301_q().getString()).append("; ");
        }
        return s.toString();
    }

    public List<ItemStack> getIngredients() {
        return this.ingredients;
    }

    public void setIngredients(List<ItemStack> ingredients) throws IllegalArgumentException {
        if (ingredients.size() == 0 || ingredients.size() > 3) {
            throw new IllegalArgumentException("Invalid ritual ingredients, must be in range [1,3]");
        }
        this.ingredients = ingredients;
    }

    public List<ItemStack> getIncenses() {
        return this.incenses;
    }

    public void setIncenses(List<ItemStack> incenses) throws IllegalArgumentException {
        if (incenses.size() == 0 || incenses.size() > 4) {
            throw new IllegalArgumentException("Invalid ritual incense, must be in range [1,4]");
        }
        this.incenses = incenses;
    }

    public ArrayList<BlockPos> getPositionsRelative() {
        return this.positionsRelative;
    }

    public void setPositionsRelative(ArrayList<BlockPos> positionsRelative) {
        this.positionsRelative = positionsRelative;
    }

    public ArrayList<Block> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(ArrayList<Block> blocks) {
        this.blocks = blocks;
    }

    public Vector3d getColor() {
        return this.color;
    }

    public void setPrimaryColor(double r, double g, double b) {
        this.color = this.buildColor(r, g, b);
    }

    public Vector3d getSecondaryColor() {
        return this.secondaryColor;
    }

    public RitualBase setSecondaryColor(double r, double g, double b) {
        this.secondaryColor = this.buildColor(r, g, b);
        return this;
    }

    private Vector3d buildColor(double r, double g, double b) throws IllegalArgumentException {
        if (r < 0.0 || r > 255.0 || g < 0.0 || g > 255.0 || b < 0.0 || b > 255.0) {
            throw new IllegalArgumentException("Invalid color value use [0, 255]");
        }
        return new Vector3d(r, g, b);
    }
}

