/*
 * Decompiled with CFR 0.152.
 */
package elucent.rootsclassic.tile;

import elucent.rootsclassic.client.particles.MagicAuraParticleData;
import elucent.rootsclassic.item.GrowthPowderItem;
import elucent.rootsclassic.registry.RootsRegistry;
import elucent.rootsclassic.tile.TEBase;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;

public class GrowerStandingStoneTile
extends TEBase
implements ITickableTileEntity {
    private static final double PCT_CHANCE_PER_BLOCK = 0.03;
    private static final int TICK_SPEED = 100;
    private static final int MAX_TICKER = 10000;
    private static final int RADIUS = 4;
    int ticker = 0;

    public GrowerStandingStoneTile(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public GrowerStandingStoneTile() {
        this((TileEntityType)RootsRegistry.GROWER_STANDING_STONE_TILE.get());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        return tag;
    }

    public void func_73660_a() {
        this.updateTicker();
        this.spawnParticles();
        if (this.ticker % 100 == 0) {
            this.applyGrowthToArea();
        }
    }

    private void updateTicker() {
        ++this.ticker;
        if (this.ticker >= 10000) {
            this.ticker = 0;
        }
    }

    private void applyGrowthToArea() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int xp = -4; xp <= 4; ++xp) {
            for (int zp = -4; zp <= 4; ++zp) {
                positions.add(this.func_174877_v().func_177982_a(xp, -1, zp));
                positions.add(this.func_174877_v().func_177982_a(xp, -2, zp));
            }
        }
        Collections.shuffle(positions);
        for (BlockPos pos : positions) {
            if (!(this.field_145850_b.field_73012_v.nextDouble() < 0.03)) continue;
            GrowthPowderItem.applyGrowthHere(this.field_145850_b, pos);
        }
    }

    private void spawnParticles() {
        if (this.ticker % 5 == 0 && this.field_145850_b.field_72995_K) {
            for (double i = 0.0; i < 720.0; i += 45.0) {
                double xShift = 0.5 * Math.sin(Math.PI * (i / 360.0));
                double zShift = 0.5 * Math.cos(Math.PI * (i / 360.0));
                this.field_145850_b.func_195594_a(MagicAuraParticleData.createData(32.0, 255.0, 32.0), (double)this.field_174879_c.func_177958_n() + 0.5 + xShift, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5 + zShift, 0.0, 0.0, 0.0);
            }
        }
    }
}

