/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.block.EntityHoldingBlock;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.ItemCollectorsClient;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorContainer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CollectorBlock
extends BaseBlock
implements EntityHoldingBlock {
    public static final EnumProperty<Direction> DIRECTION = BlockStateProperties.field_208155_H;
    private static final BlockShape SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)5.0, (double)1.0, (double)5.0, (double)11.0, (double)2.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)5.0, (double)10.0), BlockShape.createBlockShape((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)5.0, (double)6.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)5.0, (double)6.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)10.0, (double)6.0, (double)10.0, (double)11.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)5.0, (double)11.0, (double)11.0, (double)6.0), BlockShape.createBlockShape((double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)11.0, (double)11.0), BlockShape.createBlockShape((double)5.0, (double)10.0, (double)6.0, (double)6.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)10.0, (double)10.0, (double)6.0, (double)11.0, (double)11.0, (double)10.0), BlockShape.createBlockShape((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0)});
    private static final BlockShape[] SHAPES = new BlockShape[6];
    private final Supplier<BaseBlockEntityType<?>> entityType;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;

    public CollectorBlock(Supplier<BaseBlockEntityType<?>> entityType, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(false, BlockProperties.create((Material)Material.field_151576_e, (MaterialColor)MaterialColor.field_151646_E).requiresCorrectTool().destroyTime(5.0f).explosionResistance(1200.0f));
        this.entityType = entityType;
        this.maxRange = maxRange;
        this.hasFilter = hasFilter;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a(DIRECTION, (Comparable)Direction.DOWN));
    }

    protected BaseBlock.InteractionFeedback interact(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, Direction hitSide, Vector3d hitLocation) {
        if (level.field_72995_K && !this.hasFilter.get().booleanValue()) {
            ItemCollectorsClient.openBasicCollectorScreen(level, pos);
        } else if (!level.field_72995_K && this.hasFilter.get().booleanValue()) {
            CommonUtils.openContainer((BaseContainer)new AdvancedCollectorContainer(ItemCollectors.filter_collector_container, player, level, pos));
        }
        return BaseBlock.InteractionFeedback.SUCCESS;
    }

    public TileEntity createNewBlockEntity() {
        return this.entityType.get().func_200968_a();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader level, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b(DIRECTION)).func_176745_a()].getUnderlying();
    }

    protected void appendItemInformation(ItemStack stack, @Nullable IBlockReader level, Consumer<ITextComponent> info, boolean advanced) {
        info.accept((ITextComponent)TextComponents.translation((String)("itemcollectors." + (this.hasFilter.get() != false ? "advanced" : "basic") + "_collector.info")).color(TextFormatting.AQUA).get());
        info.accept((ITextComponent)TextComponents.translation((String)"itemcollectors.basic_collector.info.range", (Object[])new Object[]{TextComponents.number((int)this.maxRange.get()).color(TextFormatting.GOLD).get()}).get());
        super.appendItemInformation(stack, level, info, advanced);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{DIRECTION});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a(DIRECTION, (Comparable)context.func_196000_l().func_176734_d());
    }

    static {
        CollectorBlock.SHAPES[Direction.DOWN.func_176745_a()] = SHAPE;
        CollectorBlock.SHAPES[Direction.UP.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.NORTH.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.EAST.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        CollectorBlock.SHAPES[Direction.SOUTH.func_176745_a()] = SHAPE.rotate(Direction.Axis.X);
        CollectorBlock.SHAPES[Direction.WEST.func_176745_a()] = SHAPE.rotate(Direction.Axis.X).rotate(Direction.Axis.Y);
    }
}

