/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.TickableBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlock;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.ItemCollectorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CollectorBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    private static final int MIN_RANGE = 1;
    private final Supplier<Integer> maxRange;
    private final Supplier<Boolean> hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;
    public boolean showArea = false;

    public static CollectorBlockEntity basicCollectorEntity() {
        return new CollectorBlockEntity(ItemCollectors.basic_collector_tile, ItemCollectorsConfig.basicCollectorMaxRange, ItemCollectorsConfig.basicCollectorFilter);
    }

    public static CollectorBlockEntity advancedCollectorEntity() {
        return new CollectorBlockEntity(ItemCollectors.advanced_collector_tile, ItemCollectorsConfig.advancedCollectorMaxRange, ItemCollectorsConfig.advancedCollectorFilter);
    }

    public CollectorBlockEntity(BaseBlockEntityType<CollectorBlockEntity> blockEntityType, Supplier<Integer> maxRange, Supplier<Boolean> hasFilter) {
        super(blockEntityType);
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = (int)Math.ceil((float)maxRange.get().intValue() / 2.0f);
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.field_190927_a);
        }
    }

    public void update() {
        if (!this.field_145850_b.field_72995_K) {
            this.getOutputItemHandler().ifPresent(itemHandler -> {
                if (itemHandler.getSlots() <= 0) {
                    return;
                }
                AxisAlignedBB area = this.getAffectedArea();
                List items = this.field_145850_b.func_217357_a(ItemEntity.class, area);
                if (items.isEmpty()) {
                    return;
                }
                int maxInsertions = ItemCollectorsConfig.maxInsertions.get();
                if (maxInsertions <= 0) {
                    maxInsertions = items.size();
                }
                int remainingInsertions = maxInsertions;
                block0: for (int i = 0; i < items.size() && remainingInsertions > 0 && i < maxInsertions * 10; ++i) {
                    ItemStack stack;
                    ItemEntity entity = (ItemEntity)items.get(i);
                    if (!entity.func_70089_S() || entity.getPersistentData().func_74764_b("PreventRemoteMovement") && !entity.getPersistentData().func_74764_b("AllowMachineRemoteMovement") || (stack = entity.func_92059_d().func_77946_l()).func_190926_b()) continue;
                    if (this.hasFilter.get().booleanValue()) {
                        boolean matchesFilter = false;
                        for (int slot = 0; slot < 9; ++slot) {
                            ItemStack filter = this.filter.get(slot);
                            if (filter.func_190926_b() || !ItemStack.func_179545_c((ItemStack)filter, (ItemStack)stack) || this.filterDurability && !ItemStack.func_77970_a((ItemStack)filter, (ItemStack)stack)) continue;
                            matchesFilter = true;
                            break;
                        }
                        if (matchesFilter != this.filterWhitelist) continue;
                    }
                    --remainingInsertions;
                    for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
                        if (!itemHandler.isItemValid(slot, stack) || !(stack = itemHandler.insertItem(slot, stack, false)).func_190926_b()) continue;
                        entity.func_92058_a(ItemStack.field_190927_a);
                        entity.func_70106_y();
                        continue block0;
                    }
                    entity.func_92058_a(stack);
                }
            });
        }
    }

    public AxisAlignedBB getAffectedArea() {
        return new AxisAlignedBB(this.field_174879_c.func_177982_a(-this.rangeX, -this.rangeY, -this.rangeZ), this.field_174879_c.func_177982_a(this.rangeX + 1, this.rangeY + 1, this.rangeZ + 1));
    }

    private LazyOptional<IItemHandler> getOutputItemHandler() {
        BlockState state = this.func_195044_w();
        if (!state.func_235901_b_(CollectorBlock.DIRECTION)) {
            return LazyOptional.empty();
        }
        Direction direction = (Direction)state.func_177229_b(CollectorBlock.DIRECTION);
        TileEntity entity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(direction));
        if (entity == null) {
            return LazyOptional.empty();
        }
        return entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.func_176734_d());
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, 1), this.maxRange.get());
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    public void setShowArea(boolean showArea) {
        if (this.showArea != showArea) {
            this.showArea = showArea;
            this.dataChanged();
        }
    }

    protected CompoundNBT writeData() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("rangeX", this.rangeX);
        tag.func_74768_a("rangeY", this.rangeY);
        tag.func_74768_a("rangeZ", this.rangeZ);
        for (int i = 0; i < 9; ++i) {
            if (this.filter.get(i).func_190926_b()) continue;
            tag.func_218657_a("filter" + i, (INBT)this.filter.get(i).func_77955_b(new CompoundNBT()));
        }
        tag.func_74757_a("filterWhitelist", this.filterWhitelist);
        tag.func_74757_a("filterDurability", this.filterDurability);
        tag.func_74757_a("showArea", this.showArea);
        return tag;
    }

    protected void readData(CompoundNBT tag) {
        if (tag.func_74764_b("rangeX")) {
            this.rangeX = tag.func_74762_e("rangeX");
        }
        if (tag.func_74764_b("rangeY")) {
            this.rangeY = tag.func_74762_e("rangeY");
        }
        if (tag.func_74764_b("rangeZ")) {
            this.rangeZ = tag.func_74762_e("rangeZ");
        }
        for (int i = 0; i < 9; ++i) {
            this.filter.set(i, tag.func_74764_b("filter" + i) ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("filter" + i)) : ItemStack.field_190927_a);
        }
        this.filterWhitelist = tag.func_74764_b("filterWhitelist") && tag.func_74767_n("filterWhitelist");
        this.filterDurability = tag.func_74764_b("filterDurability") && tag.func_74767_n("filterDurability");
        this.showArea = tag.func_74764_b("showArea") && tag.func_74767_n("showArea");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.getAffectedArea();
    }
}

