/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.itemcollectors;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.gui.BaseContainer;
import com.supermartijn642.core.gui.WidgetContainerScreen;
import com.supermartijn642.core.gui.WidgetScreen;
import com.supermartijn642.core.gui.widget.Widget;
import com.supermartijn642.core.registry.ClientRegistrationHandler;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.itemcollectors.CollectorBlockEntity;
import com.supermartijn642.itemcollectors.CollectorBlockEntityRenderer;
import com.supermartijn642.itemcollectors.ItemCollectors;
import com.supermartijn642.itemcollectors.screen.AdvancedCollectorScreen;
import com.supermartijn642.itemcollectors.screen.BasicCollectorScreen;
import java.util.Random;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ItemCollectorsClient {
    public static void register() {
        ClientRegistrationHandler handler = ClientRegistrationHandler.get((String)"itemcollectors");
        handler.registerContainerScreen(() -> ItemCollectors.filter_collector_container, container -> WidgetContainerScreen.of((Widget)new AdvancedCollectorScreen(container.level, container.getCollectorPosition()), (BaseContainer)container, (boolean)false));
        handler.registerCustomBlockEntityRenderer(() -> ItemCollectors.basic_collector_tile, CollectorBlockEntityRenderer::new);
        handler.registerCustomBlockEntityRenderer(() -> ItemCollectors.advanced_collector_tile, CollectorBlockEntityRenderer::new);
    }

    public static void openBasicCollectorScreen(World level, BlockPos pos) {
        ClientUtils.displayScreen((Screen)WidgetScreen.of((Widget)new BasicCollectorScreen(level, pos)));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class Events {
        @SubscribeEvent
        public static void onBlockHighlight(DrawHighlightEvent.HighlightBlock e) {
            World level = ClientUtils.getWorld();
            TileEntity entity = level.func_175625_s(e.getTarget().func_216350_a());
            if (entity instanceof CollectorBlockEntity) {
                e.getMatrix().func_227860_a_();
                Vector3d camera = RenderUtils.getCameraPosition();
                e.getMatrix().func_227861_a_(-camera.field_72450_a, -camera.field_72448_b, -camera.field_72449_c);
                AxisAlignedBB area = ((CollectorBlockEntity)entity).getAffectedArea().func_186662_g((double)0.05f);
                Random random = new Random(entity.func_174877_v().hashCode());
                float red = random.nextFloat();
                float green = random.nextFloat();
                float blue = random.nextFloat();
                float alpha = 0.3f;
                RenderUtils.renderBox((MatrixStack)e.getMatrix(), (AxisAlignedBB)area, (float)red, (float)green, (float)blue, (boolean)true);
                RenderUtils.renderBoxSides((MatrixStack)e.getMatrix(), (AxisAlignedBB)area, (float)red, (float)green, (float)blue, (float)alpha, (boolean)true);
                e.getMatrix().func_227865_b_();
            }
        }
    }
}

