/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.module.config.type;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.quark.base.client.config.gui.CategoryScreen;
import vazkii.quark.base.client.config.gui.ColorMatrixInputScreen;
import vazkii.quark.base.client.config.gui.WidgetWrapper;
import vazkii.quark.base.client.config.gui.widget.IWidgetProvider;
import vazkii.quark.base.client.config.gui.widget.PencilButton;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.module.config.ConfigFlagManager;
import vazkii.quark.base.module.config.type.AbstractConfigType;

public class ColorMatrixConfig
extends AbstractConfigType
implements IWidgetProvider {
    @Config
    List<Double> r;
    @Config
    List<Double> g;
    @Config
    List<Double> b;
    public final double[] defaultMatrix;
    public double[] colorMatrix;

    public ColorMatrixConfig(double[] defaultMatrix) {
        assert (defaultMatrix.length == 9);
        this.defaultMatrix = defaultMatrix;
        this.colorMatrix = Arrays.copyOf(defaultMatrix, defaultMatrix.length);
        this.r = Arrays.asList(defaultMatrix[0], defaultMatrix[1], defaultMatrix[2]);
        this.g = Arrays.asList(defaultMatrix[3], defaultMatrix[4], defaultMatrix[5]);
        this.b = Arrays.asList(defaultMatrix[6], defaultMatrix[7], defaultMatrix[8]);
    }

    @Override
    public void onReload(ConfigFlagManager flagManager) {
        try {
            this.colorMatrix = new double[]{this.r.get(0), this.r.get(1), this.r.get(2), this.g.get(0), this.g.get(1), this.g.get(2), this.b.get(0), this.b.get(1), this.b.get(2)};
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            e.printStackTrace();
            this.colorMatrix = Arrays.copyOf(this.defaultMatrix, this.defaultMatrix.length);
        }
    }

    public void inherit(ColorMatrixConfig other) {
        this.r = other.r;
        this.g = other.g;
        this.b = other.b;
        this.colorMatrix = Arrays.copyOf(other.colorMatrix, other.colorMatrix.length);
        if (this.category != null) {
            this.category.refresh();
            this.category.updateDirty();
        }
    }

    public ColorMatrixConfig copy() {
        ColorMatrixConfig newMatrix = new ColorMatrixConfig(this.colorMatrix);
        newMatrix.inherit(this);
        return newMatrix;
    }

    public int convolve(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        int outR = this.clamp((int)((double)r * this.colorMatrix[0] + (double)g * this.colorMatrix[1] + (double)b * this.colorMatrix[2]));
        int outG = this.clamp((int)((double)r * this.colorMatrix[3] + (double)g * this.colorMatrix[4] + (double)b * this.colorMatrix[5]));
        int outB = this.clamp((int)((double)r * this.colorMatrix[6] + (double)g * this.colorMatrix[7] + (double)b * this.colorMatrix[8]));
        return 0xFF000000 | ((outR & 0xFF) << 16) + ((outG & 0xFF) << 8) + (outB & 0xFF);
    }

    private int clamp(int val) {
        return Math.min(255, Math.max(0, val));
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ColorMatrixConfig && Arrays.equals(((ColorMatrixConfig)obj).colorMatrix, this.colorMatrix);
    }

    public int hashCode() {
        return this.colorMatrix.hashCode();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addWidgets(CategoryScreen parent, List<WidgetWrapper> widgets) {
        Minecraft minecraft = Minecraft.func_71410_x();
        widgets.add(new WidgetWrapper((Widget)new PencilButton(230, 3, b -> minecraft.func_147108_a((Screen)new ColorMatrixInputScreen(parent, this, this.category)))));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String getSubtitle() {
        return "[" + Arrays.stream(this.colorMatrix).boxed().map(d -> String.format("%.1f", d)).collect(Collectors.joining(", ")) + "]";
    }
}

