/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.automation.module;

import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.JukeboxBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.OptionalDispenseBehavior;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MusicDiscItem;
import net.minecraft.state.Property;
import net.minecraft.tileentity.JukeboxTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

@LoadModule(category=ModuleCategory.AUTOMATION, hasSubscriptions=true)
public class JukeboxAutomationModule
extends QuarkModule {
    private static final ResourceLocation JUKEBOX_ITEM_HANDLER = new ResourceLocation("quark", "jukebox_item_handler");

    @Override
    public void setup() {
        MusicDiscBehaviour behaviour = new MusicDiscBehaviour();
        ForgeRegistries.ITEMS.forEach(i -> {
            if (i instanceof MusicDiscItem) {
                DispenserBlock.field_149943_a.put(i, behaviour);
            }
        });
    }

    @SubscribeEvent
    public void attachCaps(AttachCapabilitiesEvent<TileEntity> event) {
        if (event.getObject() instanceof JukeboxTileEntity) {
            event.addCapability(JUKEBOX_ITEM_HANDLER, (ICapabilityProvider)new JukeboxItemHandler((JukeboxTileEntity)event.getObject()));
        }
    }

    public static class MusicDiscBehaviour
    extends OptionalDispenseBehavior {
        @Nonnull
        protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            JukeboxTileEntity jukebox;
            Direction dir = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(dir);
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(pos);
            if (state.func_177230_c() == Blocks.field_150421_aI && (jukebox = (JukeboxTileEntity)world.func_175625_s(pos)) != null) {
                ItemStack currentRecord = jukebox.func_195537_c();
                ((JukeboxBlock)state.func_177230_c()).func_176431_a((IWorld)world, pos, state, stack);
                world.func_217378_a(null, 1010, pos, Item.func_150891_b((Item)stack.func_77973_b()));
                return currentRecord;
            }
            return super.func_82487_b(source, stack);
        }
    }

    public static class JukeboxItemHandler
    implements ICapabilityProvider,
    IItemHandler {
        final JukeboxTileEntity tile;

        public JukeboxItemHandler(JukeboxTileEntity tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return 1;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.tile.func_195537_c();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack stackAt = this.getStackInSlot(slot);
            if (!stackAt.func_190926_b()) {
                ItemStack copy = stackAt.func_77946_l();
                if (!simulate) {
                    this.tile.func_145831_w().func_217379_c(1010, this.tile.func_174877_v(), 0);
                    this.tile.func_195535_a(ItemStack.field_190927_a);
                    BlockState state = (BlockState)this.tile.func_195044_w().func_206870_a((Property)JukeboxBlock.field_176432_a, (Comparable)Boolean.valueOf(false));
                    this.tile.func_145831_w().func_180501_a(this.tile.func_174877_v(), state, 3);
                }
                return copy;
            }
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return LazyOptional.of(() -> this).cast();
            }
            return LazyOptional.empty();
        }
    }
}

