/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.module;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.api.IUsageTickerOverride;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.CLIENT, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class UsageTickerModule
extends QuarkModule {
    public static List<TickerElement> elements = new ArrayList<TickerElement>();
    @Config(description="Switch the armor display to the off hand side and the hand display to the main hand side")
    public static boolean invert = false;
    @Config
    public static int shiftLeft = 0;
    @Config
    public static int shiftRight = 0;
    @Config
    public static boolean enableMainHand = true;
    @Config
    public static boolean enableOffHand = true;
    @Config
    public static boolean enableArmor = true;

    @Override
    public void configChanged() {
        elements = new ArrayList<TickerElement>();
        if (enableMainHand) {
            elements.add(new TickerElement(EquipmentSlotType.MAINHAND));
        }
        if (enableOffHand) {
            elements.add(new TickerElement(EquipmentSlotType.OFFHAND));
        }
        if (enableArmor) {
            elements.add(new TickerElement(EquipmentSlotType.HEAD));
            elements.add(new TickerElement(EquipmentSlotType.CHEST));
            elements.add(new TickerElement(EquipmentSlotType.LEGS));
            elements.add(new TickerElement(EquipmentSlotType.FEET));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && mc.field_71441_e != null) {
                for (TickerElement ticker : elements) {
                    if (ticker == null) continue;
                    ticker.tick((PlayerEntity)mc.field_71439_g);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.HOTBAR) {
            MainWindow window = event.getWindow();
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            float partial = event.getPartialTicks();
            for (TickerElement ticker : elements) {
                if (ticker == null) continue;
                ticker.render(window, (PlayerEntity)player, invert, partial);
            }
        }
    }

    public static class TickerElement {
        private static final int MAX_TIME = 60;
        private static final int ANIM_TIME = 5;
        public int liveTicks;
        public final EquipmentSlotType slot;
        public ItemStack currStack = ItemStack.field_190927_a;
        public ItemStack currRealStack = ItemStack.field_190927_a;
        public int currCount;

        public TickerElement(EquipmentSlotType slot) {
            this.slot = slot;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void tick(PlayerEntity player) {
            int count;
            ItemStack realStack = this.getStack(player);
            ItemStack displayedStack = this.getDisplayedStack(realStack, count = this.getStackCount(player, realStack));
            if (displayedStack.func_190926_b()) {
                this.liveTicks = 0;
            } else if (this.shouldChange(realStack, this.currRealStack, count, this.currCount) || this.shouldChange(displayedStack, this.currStack, count, this.currCount)) {
                boolean animatingOut;
                boolean done = this.liveTicks == 0;
                boolean animatingIn = this.liveTicks > 55;
                boolean bl = animatingOut = this.liveTicks < 5 && !done;
                if (animatingOut) {
                    this.liveTicks = 60 - this.liveTicks;
                } else if (!animatingIn) {
                    this.liveTicks = !done ? 55 : 60;
                }
            } else if (this.liveTicks > 0) {
                --this.liveTicks;
            }
            this.currCount = count;
            this.currStack = displayedStack;
            this.currRealStack = realStack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(MainWindow window, PlayerEntity player, boolean invert, float partialTicks) {
            if (this.liveTicks > 0) {
                float mul;
                float animProgress = this.liveTicks < 5 ? Math.max(0.0f, (float)this.liveTicks - partialTicks) / 5.0f : Math.min(5.0f, (float)(60 - this.liveTicks) + partialTicks) / 5.0f;
                float anim = -animProgress * (animProgress - 2.0f) * 20.0f;
                float x = (float)window.func_198107_o() / 2.0f;
                float y = (float)window.func_198087_p() - anim;
                int barWidth = 190;
                boolean armor = this.slot.func_188453_a() == EquipmentSlotType.Group.ARMOR;
                HandSide primary = player.func_184591_cq();
                HandSide ourSide = armor != invert ? primary : primary.func_188468_a();
                int slots = armor ? 4 : 2;
                int index = slots - this.slot.func_188454_b() - 1;
                float f = mul = ourSide == HandSide.LEFT ? -1.0f : 1.0f;
                if (ourSide != primary && !player.func_184586_b(Hand.OFF_HAND).func_190926_b()) {
                    barWidth += 58;
                }
                Minecraft mc = Minecraft.func_71410_x();
                x += (float)barWidth / 2.0f * mul + (float)(index * 20);
                if (ourSide == HandSide.LEFT) {
                    x -= (float)(slots * 20);
                    x += (float)shiftLeft;
                } else {
                    x += (float)shiftRight;
                }
                ItemStack stack = this.getRenderedStack(player);
                mc.func_175599_af().func_180450_b(stack, (int)x, (int)y);
                mc.func_175599_af().func_175030_a(Minecraft.func_71410_x().field_71466_p, stack, (int)x, (int)y);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean shouldChange(ItemStack currStack, ItemStack prevStack, int currentTotal, int pastTotal) {
            return !prevStack.func_77969_a(currStack) || currStack.func_77984_f() && currStack.func_77952_i() != prevStack.func_77952_i() || currentTotal != pastTotal;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getStack(PlayerEntity player) {
            return player.func_184582_a(this.slot);
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getDisplayedStack(ItemStack stack, int count) {
            boolean verifySize = true;
            if ((stack.func_77973_b() instanceof BowItem || stack.func_77973_b() instanceof CrossbowItem) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) == 0) {
                stack = new ItemStack((IItemProvider)Items.field_151032_g);
                verifySize = false;
            } else if (stack.func_77973_b() instanceof IUsageTickerOverride) {
                IUsageTickerOverride over = (IUsageTickerOverride)stack.func_77973_b();
                stack = over.getUsageTickerItem(stack);
                verifySize = over.shouldUsageTickerCheckMatchSize(this.currStack);
            } else {
                if (!stack.func_77985_e() && this.slot.func_188453_a() == EquipmentSlotType.Group.HAND) {
                    return ItemStack.field_190927_a;
                }
                if (verifySize && stack.func_77985_e() && count == stack.func_190916_E()) {
                    return ItemStack.field_190927_a;
                }
            }
            return stack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public ItemStack getRenderedStack(PlayerEntity player) {
            int count;
            ItemStack stack = this.getStack(player);
            ItemStack displayStack = this.getDisplayedStack(stack, count = this.getStackCount(player, stack)).func_77946_l();
            if (displayStack != stack) {
                count = this.getStackCount(player, displayStack);
            }
            displayStack.func_190920_e(count);
            return displayStack;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getStackCount(PlayerEntity player, ItemStack stack) {
            if (!stack.func_77985_e()) {
                return 1;
            }
            Predicate<ItemStack> predicate = stackAt -> ItemStack.func_179545_c((ItemStack)stackAt, (ItemStack)stack) && ItemStack.func_77970_a((ItemStack)stackAt, (ItemStack)stack);
            if (stack.func_77973_b() == Items.field_151032_g) {
                predicate = stackAt -> stackAt.func_77973_b() instanceof ArrowItem;
            }
            int total = 0;
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stackAt2 = player.field_71071_by.func_70301_a(i);
                if (predicate.test(stackAt2)) {
                    total += stackAt2.func_190916_E();
                    continue;
                }
                if (!(stackAt2.func_77973_b() instanceof IUsageTickerOverride)) continue;
                IUsageTickerOverride over = (IUsageTickerOverride)stackAt2.func_77973_b();
                total += over.getUsageTickerCountForItem(stackAt2, predicate);
            }
            return total;
        }
    }
}

