/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.client.tooltip;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.ShulkerBoxBlock;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.handler.SimilarBlockTypeHandler;
import vazkii.quark.content.client.module.ChestSearchingModule;
import vazkii.quark.content.client.module.ImprovedTooltipsModule;

public class ShulkerBoxTooltips {
    public static final ResourceLocation WIDGET_RESOURCE = new ResourceLocation("quark", "textures/misc/shulker_widget.png");
    private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {9, 3}, {9, 5}, {9, 6}, {9, 8}, {9, 9}, {12, 9}};
    private static final int CORNER = 5;
    private static final int BUFFER = 1;
    private static final int EDGE = 18;

    @OnlyIn(value=Dist.CLIENT)
    public static void makeTooltip(ItemTooltipEvent event) {
        CompoundNBT cmp;
        if (SimilarBlockTypeHandler.isShulkerBox(event.getItemStack()) && event.getItemStack().func_77942_o() && (cmp = ItemNBTHelper.getCompound((ItemStack)event.getItemStack(), (String)"BlockEntityTag", (boolean)true)) != null) {
            TileEntity te;
            if (cmp.func_74764_b("LootTable")) {
                return;
            }
            if (!cmp.func_150297_b("id", 8)) {
                cmp = cmp.func_74737_b();
                cmp.func_74778_a("id", "minecraft:shulker_box");
            }
            if ((te = TileEntity.func_235657_b_((BlockState)((BlockItem)event.getItemStack().func_77973_b()).func_179223_d().func_176223_P(), (CompoundNBT)cmp)) != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                List tooltip = event.getToolTip();
                ArrayList tooltipCopy = new ArrayList(tooltip);
                for (int i = 1; i < tooltipCopy.size(); ++i) {
                    ITextComponent t = (ITextComponent)tooltipCopy.get(i);
                    String s = t.getString();
                    if (s.startsWith("\u00a7") && !s.startsWith("\u00a7o")) continue;
                    tooltip.remove(t);
                }
                if (ImprovedTooltipsModule.shulkerBoxRequireShift && !Screen.func_231173_s_()) {
                    tooltip.add(1, new TranslationTextComponent("quark.misc.shulker_box_shift"));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderTooltip(RenderTooltipEvent.PostText event) {
        if (SimilarBlockTypeHandler.isShulkerBox(event.getStack()) && event.getStack().func_77942_o() && (!ImprovedTooltipsModule.shulkerBoxRequireShift || Screen.func_231173_s_())) {
            Minecraft mc = Minecraft.func_71410_x();
            MatrixStack matrix = event.getMatrixStack();
            CompoundNBT cmp = ItemNBTHelper.getCompound((ItemStack)event.getStack(), (String)"BlockEntityTag", (boolean)true);
            if (cmp != null) {
                TileEntity te;
                if (cmp.func_74764_b("LootTable")) {
                    return;
                }
                if (!cmp.func_150297_b("id", 8)) {
                    cmp = cmp.func_74737_b();
                    cmp.func_74778_a("id", "minecraft:shulker_box");
                }
                if ((te = TileEntity.func_235657_b_((BlockState)((BlockItem)event.getStack().func_77973_b()).func_179223_d().func_176223_P(), (CompoundNBT)cmp)) != null) {
                    if (te instanceof LockableLootTileEntity) {
                        ((LockableLootTileEntity)te).func_189404_a(null, 0L);
                    }
                    LazyOptional handler = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                    handler.ifPresent(capability -> {
                        DyeColor dye;
                        MainWindow window;
                        int right;
                        ItemStack currentBox = event.getStack();
                        int currentX = event.getX() - 5;
                        int currentY = event.getY() - 70;
                        int size = capability.getSlots();
                        int[] dims = new int[]{Math.min(size, 9), Math.max(size / 9, 1)};
                        for (int[] testAgainst : TARGET_RATIOS) {
                            if (testAgainst[0] * testAgainst[1] != size) continue;
                            dims = testAgainst;
                            break;
                        }
                        int texWidth = 10 + 18 * dims[0];
                        if (currentY < 0) {
                            currentY = event.getY() + event.getLines().size() * 10 + 5;
                        }
                        if ((right = currentX + texWidth) > (window = mc.func_228018_at_()).func_198107_o()) {
                            currentX -= right - window.func_198107_o();
                        }
                        RenderSystem.pushMatrix();
                        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)700.0f);
                        int color = -1;
                        if (ImprovedTooltipsModule.shulkerBoxUseColors && ((BlockItem)currentBox.func_77973_b()).func_179223_d() instanceof ShulkerBoxBlock && (dye = ((ShulkerBoxBlock)((BlockItem)currentBox.func_77973_b()).func_179223_d()).func_190956_e()) != null) {
                            float[] colorComponents = dye.func_193349_f();
                            color = (int)(colorComponents[0] * 255.0f) << 16 | (int)(colorComponents[1] * 255.0f) << 8 | (int)(colorComponents[2] * 255.0f);
                        }
                        ShulkerBoxTooltips.renderTooltipBackground(mc, matrix, currentX, currentY, dims[0], dims[1], color);
                        ItemRenderer render = mc.func_175599_af();
                        for (int i = 0; i < size; ++i) {
                            ItemStack itemstack = capability.getStackInSlot(i);
                            int xp = currentX + 6 + i % 9 * 18;
                            int yp = currentY + 6 + i / 9 * 18;
                            if (!itemstack.func_190926_b()) {
                                render.func_180450_b(itemstack, xp, yp);
                                render.func_175030_a(mc.field_71466_p, itemstack, xp, yp);
                            }
                            if (ChestSearchingModule.namesMatch(itemstack)) continue;
                            RenderSystem.disableDepthTest();
                            AbstractGui.func_238467_a_((MatrixStack)matrix, (int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)-1442840576);
                        }
                        RenderSystem.popMatrix();
                    });
                }
            }
        }
    }

    public static void renderTooltipBackground(Minecraft mc, MatrixStack matrix, int x, int y, int width, int height, int color) {
        mc.func_110434_K().func_110577_a(WIDGET_RESOURCE);
        RenderSystem.color3f((float)((float)((color & 0xFF0000) >> 16) / 255.0f), (float)((float)((color & 0xFF00) >> 8) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * width), (int)(y + 5 + 18 * height), (float)25.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * width), (int)y, (float)25.0f, (float)0.0f, (int)5, (int)5, (int)256, (int)256);
        AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)(y + 5 + 18 * height), (float)0.0f, (float)25.0f, (int)5, (int)5, (int)256, (int)256);
        for (int row = 0; row < height; ++row) {
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)x, (int)(y + 5 + 18 * row), (float)0.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
            AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * width), (int)(y + 5 + 18 * row), (float)25.0f, (float)6.0f, (int)5, (int)18, (int)256, (int)256);
            for (int col = 0; col < width; ++col) {
                if (row == 0) {
                    AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * col), (int)y, (float)6.0f, (float)0.0f, (int)18, (int)5, (int)256, (int)256);
                    AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * col), (int)(y + 5 + 18 * height), (float)6.0f, (float)25.0f, (int)18, (int)5, (int)256, (int)256);
                }
                AbstractGui.func_238463_a_((MatrixStack)matrix, (int)(x + 5 + 18 * col), (int)(y + 5 + 18 * row), (float)6.0f, (float)6.0f, (int)18, (int)18, (int)256, (int)256);
            }
        }
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
    }
}

