/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.module;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.function.BooleanSupplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.GhostRecipe;
import net.minecraft.client.gui.recipebook.RecipeBookGui;
import net.minecraft.client.gui.recipebook.RecipeBookPage;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CraftingScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;

@LoadModule(category=ModuleCategory.EXPERIMENTAL, enabledByDefault=false, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class MicrocraftingHelperModule
extends QuarkModule {
    @OnlyIn(value=Dist.CLIENT)
    private static Screen currentScreen;
    private static Stack<StackedRecipe> recipes;
    private static int compoundCount;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onClick(GuiScreenEvent.MouseClickedEvent.Pre event) {
        RecipeBookGui recipeBook;
        CraftingScreen cscreen;
        Pair<GhostRecipe, GhostRecipe.GhostIngredient> pair;
        Minecraft mc = Minecraft.func_71410_x();
        Screen screen = mc.field_71462_r;
        if (screen instanceof CraftingScreen && event.getButton() == 1 && (pair = this.getHoveredGhost((ContainerScreen<?>)(cscreen = (CraftingScreen)screen), recipeBook = cscreen.func_194310_f())) != null) {
            GhostRecipe ghost = (GhostRecipe)pair.getLeft();
            GhostRecipe.GhostIngredient ghostIngr = (GhostRecipe.GhostIngredient)pair.getRight();
            Ingredient ingr = ghostIngr.field_194186_b;
            IRecipe<?> recipeToSet = this.getRecipeToSet(recipeBook, ingr, true);
            if (recipeToSet == null) {
                recipeToSet = this.getRecipeToSet(recipeBook, ingr, false);
            }
            if (recipeToSet != null) {
                int ourCount = 0;
                ItemStack testStack = recipeToSet.func_77571_b();
                for (int j = 1; j < ghost.func_192684_b(); ++j) {
                    GhostRecipe.GhostIngredient testGhostIngr = ghost.func_192681_a(j);
                    Ingredient testIngr = testGhostIngr.field_194186_b;
                    if (!testIngr.test(testStack)) continue;
                    ++ourCount;
                }
                if (ourCount > 0) {
                    StackedRecipe stackedRecipe = new StackedRecipe(ghost.func_192686_c(), testStack, compoundCount *= (int)Math.ceil((double)ourCount / (double)testStack.func_190916_E()), this.getClearCondition(ingr));
                    recipes.add(stackedRecipe);
                }
                ghost.func_192682_a();
                mc.field_71442_b.func_203413_a(mc.field_71439_g.field_71070_bA.field_75152_c, recipeToSet, true);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!recipes.isEmpty()) {
            Minecraft mc = Minecraft.func_71410_x();
            Screen screen = mc.field_71462_r;
            if (screen instanceof CraftingScreen) {
                GhostRecipe.GhostIngredient ingr;
                int start;
                CraftingScreen cscreen = (CraftingScreen)screen;
                MatrixStack mstack = event.getMatrixStack();
                ItemRenderer render = mc.func_175599_af();
                int left = cscreen.getGuiLeft() + 95;
                int top = cscreen.getGuiTop() + 6;
                mc.field_71446_o.func_110577_a(MiscUtil.GENERAL_ICONS);
                Screen.func_238464_a_((MatrixStack)mstack, (int)left, (int)top, (int)0, (float)0.0f, (float)108.0f, (int)80, (int)20, (int)256, (int)256);
                for (int i = start = Math.max(0, recipes.size() - 3); i < recipes.size(); ++i) {
                    int index = i - start;
                    StackedRecipe recipe = (StackedRecipe)recipes.get(i);
                    int x = left + index * 24 + 2;
                    int y = top + 2;
                    ItemStack drawStack = recipe.displayItem;
                    render.func_175042_a(drawStack, x, y);
                    render.func_175030_a(mc.field_71466_p, drawStack, x, y);
                    if (index <= 0) continue;
                    mc.field_71466_p.func_238421_b_(mstack, "<", (float)(x - 6), (float)(y + 4), 0x3F3F3F);
                }
                Pair<GhostRecipe, GhostRecipe.GhostIngredient> pair = this.getHoveredGhost((ContainerScreen<?>)cscreen, cscreen.func_194310_f());
                if (pair != null && (ingr = (GhostRecipe.GhostIngredient)pair.getRight()) != null) {
                    List<ITextProperties> tooltip = Arrays.asList(new TranslationTextComponent("Right Click to Craft"));
                    cscreen.renderWrappedToolTip(mstack, tooltip, event.getMouseX(), event.getMouseY() - 15, mc.field_71466_p);
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Screen prevScreen = currentScreen;
        if (prevScreen != (currentScreen = mc.field_71462_r)) {
            recipes.clear();
        }
        if (!recipes.isEmpty()) {
            StackedRecipe top = recipes.peek();
            if (top.clearCondition.getAsBoolean()) {
                mc.field_71442_b.func_203413_a(mc.field_71439_g.field_71070_bA.field_75152_c, top.recipe, true);
                compoundCount = top.count;
                recipes.pop();
            }
        } else {
            compoundCount = 1;
        }
    }

    private IRecipe<?> getRecipeToSet(RecipeBookGui recipeBook, Ingredient ingr, boolean craftableOnly) {
        TextFieldWidget text = recipeBook.field_193962_q;
        for (ItemStack stack : ingr.func_193365_a()) {
            text.func_146180_a(stack.func_200301_q().func_230531_f_().getString().toLowerCase(Locale.ROOT));
            recipeBook.func_195603_h();
            RecipeBookPage page = recipeBook.field_193022_s;
            if (page == null) continue;
            ArrayList<RecipeList> recipeLists = page.field_194203_f;
            if ((recipeLists = new ArrayList<RecipeList>(recipeLists)) == null || recipeLists.size() <= 0) continue;
            recipeLists.removeIf(rl -> {
                List list = rl.func_194207_b(craftableOnly);
                return list == null || list.isEmpty();
            });
            if (recipeLists.isEmpty()) {
                return null;
            }
            Collections.sort(recipeLists, (rl1, rl2) -> {
                if (rl1 == rl2) {
                    return 0;
                }
                IRecipe r1 = (IRecipe)rl1.func_194207_b(craftableOnly).get(0);
                IRecipe r2 = (IRecipe)rl2.func_194207_b(craftableOnly).get(0);
                return this.compareRecipes(r1, r2);
            });
            for (RecipeList list : recipeLists) {
                List recipeList = list.func_194207_b(craftableOnly);
                Collections.sort(recipeList, this::compareRecipes);
                for (int i = 0; i < recipeList.size(); ++i) {
                    if (!ingr.test(((IRecipe)recipeList.get(i)).func_77571_b())) continue;
                    return (IRecipe)recipeList.get(i);
                }
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private int compareRecipes(IRecipe<?> r1, IRecipe<?> r2) {
        boolean id2Mc;
        if (r1 == r2) {
            return 0;
        }
        String id1 = r1.func_199560_c().toString();
        String id2 = r2.func_199560_c().toString();
        boolean id1Mc = id1.startsWith("minecraft");
        if (id1Mc != (id2Mc = id2.startsWith("minecraft"))) {
            return id1Mc ? -1 : 1;
        }
        return id1.compareTo(id2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private BooleanSupplier getClearCondition(Ingredient ingr) {
        Minecraft mc = Minecraft.func_71410_x();
        return () -> {
            int missing = compoundCount;
            for (ItemStack invStack : mc.field_71439_g.field_71071_by.field_70462_a) {
                if (!ingr.test(invStack) || (missing -= invStack.func_190916_E()) > 0) continue;
                return true;
            }
            return false;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    private Pair<GhostRecipe, GhostRecipe.GhostIngredient> getHoveredGhost(ContainerScreen<?> cscreen, RecipeBookGui recipeBook) {
        GhostRecipe ghost;
        Slot slot = cscreen.getSlotUnderMouse();
        if (recipeBook != null && slot != null && (ghost = recipeBook.field_191915_z) != null && ghost.func_192686_c() != null) {
            for (int i = 1; i < ghost.func_192684_b(); ++i) {
                GhostRecipe.GhostIngredient ghostIngr = ghost.func_192681_a(i);
                if (ghostIngr.func_193713_b() != slot.field_75223_e || ghostIngr.func_193712_c() != slot.field_75221_f) continue;
                return Pair.of((Object)ghost, (Object)ghostIngr);
            }
        }
        return null;
    }

    static {
        recipes = new Stack();
        compoundCount = 1;
    }

    private static class StackedRecipe {
        public final IRecipe<?> recipe;
        public final ItemStack displayItem;
        public final int count;
        public final BooleanSupplier clearCondition;

        StackedRecipe(IRecipe<?> recipe, ItemStack displayItem, int count, BooleanSupplier clearCondition) {
            this.recipe = recipe;
            this.count = count;
            this.clearCondition = clearCondition;
            this.displayItem = displayItem.func_77946_l();
            this.displayItem.func_190920_e(count);
        }
    }
}

