/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.experimental.pallet;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import vazkii.arl.block.tile.TileSimpleInventory;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.experimental.module.PalletModule;

public class PalletTileEntity
extends TileSimpleInventory
implements ITickableTileEntity {
    private static final int MAX_HEIGHT = 4;
    private static final int STACKS_PER_HEIGHT = 64;
    private static final int[] SLOTS = new int[]{0, 1};
    public ItemStack stack = ItemStack.field_190927_a;
    public int count = 0;
    public int maxAcceptedCount = 0;
    public int currVisibleItems = 0;

    public PalletTileEntity() {
        super(PalletModule.tileEntityType);
    }

    public void writeSharedNBT(CompoundNBT compound) {
        super.writeSharedNBT(compound);
        CompoundNBT itemNbt = new CompoundNBT();
        this.stack.func_77955_b(itemNbt);
        compound.func_218657_a("palletItem", (INBT)itemNbt);
        compound.func_74768_a("palletCount", this.count);
    }

    public void readSharedNBT(CompoundNBT nbt) {
        super.readSharedNBT(nbt);
        CompoundNBT itemNbt = nbt.func_74775_l("palletItem");
        this.stack = ItemStack.func_199557_a((CompoundNBT)itemNbt);
        this.count = nbt.func_74762_e("palletCount");
    }

    public int func_70302_i_() {
        return 2;
    }

    public boolean func_191420_l() {
        return this.count == 0 || this.stack.func_190926_b();
    }

    public ItemStack func_70301_a(int index) {
        if (this.func_191420_l()) {
            return ItemStack.field_190927_a;
        }
        ItemStack ret = this.stack.func_77946_l();
        int maxStackSize = ret.func_77976_d();
        if (index == 0) {
            ret.func_190920_e(Math.min(maxStackSize, this.count));
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 0 && this.count >= count) {
            ItemStack stackAt = this.func_70301_a(index).func_77946_l();
            stackAt.func_190920_e(count);
            this.count = Math.max(0, this.count - count);
            return stackAt;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index == 0) {
            ItemStack stackAt = this.func_70301_a(index).func_77946_l();
            this.count = Math.max(0, this.count - this.stack.func_77976_d());
            return stackAt;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index == 1) {
            if (this.func_191420_l()) {
                ItemStack copy = stack.func_77946_l();
                copy.func_190920_e(1);
                this.stack = copy;
                this.count = stack.func_190916_E();
            } else {
                ItemStack curr = this.func_70301_a(index);
                if (curr.func_190926_b()) {
                    this.count += stack.func_190916_E();
                }
            }
        }
    }

    public int[] func_180463_a(Direction side) {
        return SLOTS;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return index == 1 && this.count <= this.maxAcceptedCount && this.count + itemStackIn.func_190916_E() <= this.maxAcceptedCount && (this.func_191420_l() || ItemStack.func_179545_c((ItemStack)itemStackIn, (ItemStack)this.stack) && ItemStack.func_77970_a((ItemStack)itemStackIn, (ItemStack)this.stack));
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 0;
    }

    public boolean func_70300_a(PlayerEntity player) {
        return false;
    }

    public void func_174888_l() {
        this.count = 0;
        this.stack = ItemStack.field_190927_a;
    }

    public void func_73660_a() {
        int height = 1;
        BlockPos test = this.field_174879_c.func_177984_a();
        while (height < 4 && this.field_145850_b.func_175623_d(test)) {
            ++height;
            test = test.func_177984_a();
        }
        int stackSize = this.stack.func_190926_b() ? 64 : this.stack.func_77976_d();
        this.maxAcceptedCount = height * 64 * stackSize;
        this.maxAcceptedCount = 120;
        int prevVisibleItems = this.currVisibleItems;
        this.currVisibleItems = this.getDisplayedItems();
        if (prevVisibleItems != this.currVisibleItems && !this.field_145850_b.field_72995_K) {
            this.sync();
        }
    }

    public int getDisplayedItems() {
        if (this.func_191420_l()) {
            return 0;
        }
        int multiplier = this.stack.func_77976_d();
        multiplier = 1;
        return (int)Math.ceil((double)this.count / (double)multiplier);
    }

    public void sync() {
        MiscUtil.syncTE((TileEntity)this);
    }
}

