/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import journeymap.client.JourneymapClient;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.nbt.cache.CacheStorage;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.biome.Biome;

public class RegionData {
    private static final String BIOME_TAG_NAME = "biome_name";
    private static final String BLOCK_TAG_NAME = "block";
    private static final String TOP_Y_TAG_NAME = "top_y";
    private static final String BLOCK_COLOR_TAG_NAME = "block_color_";
    protected final RegionCoord regionCoord;
    protected final MapType mapType;
    protected boolean enabled;
    protected boolean loaded = false;
    protected final RegionDataStorageHandler.Key key;
    private final CacheStorage storage;

    public RegionData(RegionDataStorageHandler.Key key, CacheStorage storage) {
        this.regionCoord = key.rCoord;
        this.mapType = key.mapType;
        this.key = key;
        this.storage = storage;
        this.enabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
    }

    public Biome getBiome(BlockPos blockPos) {
        CompoundNBT blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).func_74764_b(BIOME_TAG_NAME)) {
            String biomeName = blockData.func_74779_i(BIOME_TAG_NAME);
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(BlockPos blockPos) {
        CompoundNBT blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).func_74764_b(TOP_Y_TAG_NAME)) {
            return blockData.func_74762_e(TOP_Y_TAG_NAME);
        }
        return blockPos.func_177956_o();
    }

    public Integer getColor(BlockPos blockPos) {
        CompoundNBT blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).func_74764_b(BLOCK_COLOR_TAG_NAME)) {
            return blockData.func_74762_e(BLOCK_COLOR_TAG_NAME);
        }
        return null;
    }

    public BlockState getBlockState(BlockPos blockPos) {
        CompoundNBT blockData;
        if (this.enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).func_74764_b(BLOCK_TAG_NAME)) {
            CompoundNBT blockState = blockData.func_74775_l(BLOCK_TAG_NAME);
            return NBTUtil.func_190008_d((CompoundNBT)blockState);
        }
        return null;
    }

    public void setBiome(CompoundNBT blockData, Biome biome) {
        if (this.enabled) {
            String biomeName;
            String biomeString = BiomeHelper.getBiomeResource(biome).toString();
            if (blockData.func_74764_b(BIOME_TAG_NAME) && (biomeName = blockData.func_74779_i(BIOME_TAG_NAME)).equals(biomeString)) {
                return;
            }
            blockData.func_74778_a(BIOME_TAG_NAME, biomeString);
        }
    }

    public void setBlockState(CompoundNBT blockData, ChunkMD chunkMD, BlockPos pos) {
        if (this.enabled) {
            BlockMD blockMD = chunkMD.getBlockMD(pos.func_177984_a());
            if (blockMD == null || blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(pos);
            }
            if (blockMD == null || blockMD.isIgnore()) {
                blockMD = chunkMD.getBlockMD(pos.func_177977_b());
            }
            CompoundNBT blockState = NBTUtil.func_190009_a((BlockState)blockMD.getBlockState());
            blockData.func_218657_a(BLOCK_TAG_NAME, (INBT)blockState);
        }
    }

    public void setY(CompoundNBT blockData, int topY) {
        if (this.enabled) {
            int savedTopY;
            if (blockData.func_74764_b(TOP_Y_TAG_NAME) && (savedTopY = blockData.func_74762_e(TOP_Y_TAG_NAME)) == topY) {
                return;
            }
            blockData.func_74768_a(TOP_Y_TAG_NAME, topY);
        }
    }

    public void setBlockColor(CompoundNBT blockData, int color, MapType.Name mapTypeName) {
        if (this.enabled) {
            int savedColor;
            if (blockData.func_74764_b(BLOCK_COLOR_TAG_NAME + mapTypeName.name()) && (savedColor = blockData.func_74762_e(BLOCK_COLOR_TAG_NAME + mapTypeName.name())) == color) {
                return;
            }
            blockData.func_74768_a(BLOCK_COLOR_TAG_NAME + mapTypeName.name(), color);
        }
    }

    public CompoundNBT getBlockDataFromBlockPos(ChunkPos chunkPos, CompoundNBT chunk, int x, int z) {
        if (this.enabled && chunk != null) {
            return this.getBlockDataForChunk(chunk, (chunkPos.field_77276_a << 4) + x, (chunkPos.field_77275_b << 4) + z);
        }
        return null;
    }

    private CompoundNBT getBlockDataFromBlockPos(BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        CompoundNBT chunk = this.getChunkNbt(chunkPos);
        return this.getBlockDataForChunk(chunk, pos.func_177958_n(), pos.func_177952_p());
    }

    public CompoundNBT getChunkNbt(ChunkPos chunkPos) {
        if (this.enabled) {
            CompoundNBT chunkTag = this.storage.read(chunkPos);
            if (chunkTag == null) {
                chunkTag = new CompoundNBT();
            }
            return chunkTag;
        }
        return null;
    }

    private CompoundNBT getBlockDataForChunk(CompoundNBT chunk, int x, int z) {
        if (chunk != null) {
            CompoundNBT blockTag;
            String blockTagName = x + "," + z;
            if (chunk.func_74764_b(blockTagName)) {
                blockTag = chunk.func_74775_l(blockTagName);
            } else {
                blockTag = new CompoundNBT();
                chunk.func_218657_a(blockTagName, (INBT)blockTag);
            }
            return blockTag;
        }
        return null;
    }

    public void writeChunk(ChunkPos chunkPos, CompoundNBT tag) {
        this.storage.write(chunkPos, tag);
    }
}

