/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.extensions.PackExtension;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import com.supermartijn642.fusion.resources.FusionPackMetadata;
import com.supermartijn642.fusion.resources.FusionPackMetadataSection;
import java.io.FileNotFoundException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ResourcePackInfo.class})
public class PackMixin
implements PackExtension {
    @Unique
    private FusionPackMetadata metadata;

    @Override
    @Nullable
    public FusionPackMetadata getFusionMetadata() {
        return this.metadata;
    }

    @Inject(method={"<init>(Ljava/lang/String;ZLjava/util/function/Supplier;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/util/text/ITextComponent;Lnet/minecraft/resources/PackCompatibility;Lnet/minecraft/resources/ResourcePackInfo$Priority;ZLnet/minecraft/resources/IPackNameDecorator;Z)V"}, at={@At(value="RETURN")})
    private void init(String identifier, boolean required, Supplier<IResourcePack> resourcesSupplier, ITextComponent title, ITextComponent description, PackCompatibility compatibility, ResourcePackInfo.Priority position, boolean fixedPosition, IPackNameDecorator packSource, boolean hidden, CallbackInfo ci) {
        try (IResourcePack resources2 = resourcesSupplier.get();){
            this.metadata = (FusionPackMetadata)resources2.func_195760_a((IMetadataSectionSerializer)FusionPackMetadataSection.INSTANCE);
        }
        catch (FileNotFoundException resources2) {
        }
        catch (Exception e) {
            FusionClient.LOGGER.error("Encountered an exception whilst reading fusion metadata for pack '" + identifier + "':", (Throwable)e);
        }
    }

    @Inject(method={"open"}, at={@At(value="RETURN")})
    private void open(CallbackInfoReturnable<IResourcePack> ci) {
        IResourcePack resources = (IResourcePack)ci.getReturnValue();
        if (this.metadata != null && this.metadata.hasOverridesFolder() && resources instanceof PackResourcesExtension) {
            ((PackResourcesExtension)resources).setFusionOverridesFolder(this.metadata.getOverridesFolder());
        }
    }
}

