/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.types.connecting.predicates;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.predicate.ConnectionDirection;
import com.supermartijn642.fusion.api.predicate.ConnectionPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class MatchBlockInFrontConnectionPredicate
implements ConnectionPredicate {
    public static final Serializer<MatchBlockInFrontConnectionPredicate> SERIALIZER = new Serializer<MatchBlockInFrontConnectionPredicate>(){

        @Override
        public MatchBlockInFrontConnectionPredicate deserialize(JsonObject json) throws JsonParseException {
            if (!(json.has("block") && json.get("block").isJsonPrimitive() && json.getAsJsonPrimitive("block").isString())) {
                throw new JsonParseException("Match block predicate must have string property 'block'!");
            }
            if (!IdentifierUtil.isValidIdentifier(json.get("block").getAsString())) {
                throw new JsonParseException("Property 'block' must be a valid identifier!");
            }
            ResourceLocation identifier = new ResourceLocation(json.get("block").getAsString());
            if (!Registry.field_212618_g.func_212607_c(identifier)) {
                throw new JsonParseException("Unknown block '" + identifier + "'!");
            }
            Block block = (Block)Registry.field_212618_g.func_82594_a(identifier);
            return new MatchBlockInFrontConnectionPredicate(block);
        }

        @Override
        public JsonObject serialize(MatchBlockInFrontConnectionPredicate value) {
            JsonObject json = new JsonObject();
            json.addProperty("block", Registry.field_212618_g.func_177774_c((Object)value.block).toString());
            return json;
        }
    };
    private final Block block;

    public MatchBlockInFrontConnectionPredicate(Block block) {
        this.block = block;
    }

    @Override
    public boolean shouldConnect(Direction side, @Nullable BlockState ownState, BlockState otherState, BlockState blockInFront, ConnectionDirection direction) {
        return blockInFront.func_177230_c() == this.block;
    }

    @Override
    public Serializer<? extends ConnectionPredicate> getSerializer() {
        return SERIALIZER;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MatchBlockInFrontConnectionPredicate)) {
            return false;
        }
        MatchBlockInFrontConnectionPredicate that = (MatchBlockInFrontConnectionPredicate)o;
        return this.block.equals(that.block);
    }

    public int hashCode() {
        return this.block.hashCode();
    }
}

