/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.texture.types.random;

import com.supermartijn642.fusion.api.texture.data.BaseTextureData;
import com.supermartijn642.fusion.api.texture.data.RandomTextureData;
import com.supermartijn642.fusion.texture.types.random.RandomTextureDataImpl;
import javax.annotation.Nullable;

public class RandomTextureDataBuilderImpl
implements RandomTextureData.Builder {
    private BaseTextureData.RenderType renderType;
    private boolean emissive = false;
    private BaseTextureData.QuadTinting tinting;
    private int rows = 1;
    private int columns = 1;
    private int count;
    private Long seed;

    @Override
    public RandomTextureDataBuilderImpl renderType(@Nullable BaseTextureData.RenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    @Override
    public RandomTextureDataBuilderImpl emissive(boolean emissive) {
        this.emissive = emissive;
        return this;
    }

    @Override
    public RandomTextureDataBuilderImpl tinting(@Nullable BaseTextureData.QuadTinting tinting) {
        this.tinting = tinting;
        return this;
    }

    @Override
    public RandomTextureData.Builder rows(int rows) {
        if (rows < 1 || rows > 10) {
            throw new IllegalArgumentException("rows must be between 1 and 10");
        }
        this.rows = rows;
        return this;
    }

    @Override
    public RandomTextureData.Builder columns(int columns) {
        if (columns < 1 || columns > 10) {
            throw new IllegalArgumentException("columns must be between 1 and 10");
        }
        this.columns = columns;
        return this;
    }

    @Override
    public RandomTextureData.Builder count(int count) {
        if (count < 1 || count > 100) {
            throw new IllegalArgumentException("count must be between 1 and 100");
        }
        this.count = count;
        return this;
    }

    @Override
    public RandomTextureData.Builder seed(Long seed) {
        this.seed = seed;
        return this;
    }

    @Override
    public RandomTextureData build() {
        if (this.count > this.rows * this.columns) {
            throw new IllegalArgumentException("Count cannot be greater than rows * columns!");
        }
        return new RandomTextureDataImpl(this.renderType, this.emissive, this.tinting, this.rows, this.columns, this.count, this.seed);
    }
}

